/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public final class MigrationFileHandler
extends FileHandler {
    private static final int MAX_LOG_FILE_SIZE = 50000000;
    private static String MIGRATION_ERROR_LOG_FILE = "MigrationLog.xml";

    public MigrationFileHandler(String string) throws IOException {
        super(string + File.separator + MIGRATION_ERROR_LOG_FILE, 50000000, 1, false);
        XMLFormatter xMLFormatter = new XMLFormatter(){

            @Override
            public String format(LogRecord logRecord) {
                String string = super.format(logRecord);
                String string2 = "(method)|(millis)|(sequence)|(thread)";
                string = string.replaceAll(".*<(" + string2 + ")>.*[" + System.getProperty("line.separator") + "]", "");
                List<LogInfo> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
                if (list.size() == 1) {
                    string = string.replace("</record>", "");
                    StringBuffer stringBuffer = new StringBuffer(string);
                    for (LogRecord logRecord2 : list.get(0).getChildRecords()) {
                        stringBuffer.append(this.format(logRecord2));
                    }
                    stringBuffer.append("</record>" + System.getProperty("line.separator"));
                    string = stringBuffer.toString();
                }
                return string;
            }

            @Override
            public String getHead(Handler handler) {
                return super.getHead(handler).replaceAll(".*(logger\\.dtd).*[" + System.getProperty("line.separator") + "]", "");
            }
        };
        this.setFormatter(xMLFormatter);
    }
}

