/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.identifierMapping;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.identifierMapping.IdentifierMappingCmd;
import oracle.dbtools.migration.identifierMapping.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerateMappingXML {
    private IdentifierMappingCmd.IdentifierMappingDetails m_details = null;
    private Connection m_reposConn = null;

    public GenerateMappingXML(Connection connection, IdentifierMappingCmd.IdentifierMappingDetails identifierMappingDetails) {
        this.m_details = identifierMappingDetails;
        this.m_reposConn = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateXML() throws Exception {
        Element element = null;
        String string = null;
        String string2 = null;
        HashMap hashMap = new HashMap();
        ResultSet resultSet = null;
        DBUtil dBUtil = null;
        String string3 = "select distinct CONNNAME, CONNID from MGV_ALL_DETAILS WHERE CAPTUREDORCONVERTED = 'CAPTURED'";
        String string4 = this.m_details.getCapturedModel();
        if (string4 == null || string4.trim().equals("")) {
            throw new Exception(Messages.getString("GenerateMappingXML.2"));
        }
        String string5 = this.m_details.getFilePath();
        if (string5 == null || string5.equals("")) {
            throw new Exception(Messages.getString("GenerateMappingXML.4"));
        }
        if (this.m_reposConn != null) {
            block7: {
                try {
                    dBUtil = DBUtil.getInstance((Connection)this.m_reposConn);
                    DBUtil.getConnectionResolver().lock(this.m_reposConn);
                    resultSet = dBUtil.executeOracleQuery(string3, hashMap);
                    boolean bl = false;
                    while (resultSet.next()) {
                        string = resultSet.getString(1);
                        string2 = resultSet.getString(2);
                        if (!string.equals(string4) && !string2.equals(string4)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        throw new Exception(MessageFormat.format(Messages.getString("GenerateMappingXML.5"), string4));
                    }
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    element = this.generateCaptureId(string2, document);
                    this.generateMap(dBUtil, string2, element, document);
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    DOMSource dOMSource = new DOMSource(document);
                    File file = new File(string5);
                    StreamResult streamResult = new StreamResult(file);
                    transformer.transform(dOMSource, streamResult);
                    if (!file.exists()) break block7;
                    System.out.println(MessageFormat.format(Messages.getString("GenerateMappingXML.8"), string5));
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    DBUtil.getConnectionResolver().unlock(this.m_reposConn);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            DBUtil.getConnectionResolver().unlock(this.m_reposConn);
        }
    }

    private Element generateCaptureId(String string, Document document) {
        Element element = document.createElement("IdentifierMapping");
        document.appendChild(element);
        document.createAttribute("captureId");
        element.setAttribute("captureId", string);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMap(DBUtil dBUtil, String string, Element element, Document document) throws Exception {
        ResultSet resultSet = null;
        Element element2 = null;
        if (dBUtil != null) {
            element2 = document.createElement("database");
            String string2 = "select distinct s.project_name, s.username from mgv_all_catalogs s, mgv_all_details t where s.connection_id = :CONNID and t.connid = :CONNID  and t.capturedorconverted = 'CAPTURED'";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("CONNID", string);
            try {
                resultSet = dBUtil.executeOracleQuery(string2, hashMap);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    document.createAttribute("databaseName");
                    element2.setAttribute("databaseName", string3);
                    document.createAttribute("userName");
                    element2.setAttribute("userName", string4);
                    element.appendChild(element2);
                }
                this.generateSchemas(element2, document, string, dBUtil);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSchemas(Element element, Document document, String string, DBUtil dBUtil) throws Exception {
        Element element2 = null;
        String string2 = "select s.schemaname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where connid = :CONNID  and s.objtype = 'MD_SCHEMAS' and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CONNID", string);
        ResultSet resultSet = null;
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                element2 = this.findString("schemas", document);
                if (element2 == null) {
                    element2 = document.createElement("schemas");
                    element.appendChild(element2);
                }
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                Element element3 = this.setData(document, "schema", string4, string5, string3, string6, string7);
                element2.appendChild(element3);
                this.generateTables(element3, string4, dBUtil, document);
                this.generateConstraints(element3, string4, dBUtil, document);
                this.generateStoredPrograms(element3, string4, dBUtil, document);
                this.generateSequences(element3, string4, dBUtil, document);
                this.generateTriggers(element3, string4, dBUtil, document);
                this.generateViews(element3, string4, dBUtil, document);
                this.generateIndexes(element3, string4, dBUtil, document);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    private Element setData(Document document, String string, String string2, String string3, String string4, String string5, String string6) {
        Element element = document.createElement(string);
        this.setAttributes(document, element, string2, string3, string4, string5, string6);
        return element;
    }

    private void setAttributes(Document document, Element element, String string, String string2, String string3, String string4, String string5) {
        document.createAttribute("internalObjID");
        element.setAttribute("internalObjID", string);
        document.createAttribute("qualifiedSourceName");
        element.setAttribute("qualifiedSourceName", string2);
        document.createAttribute("sourceName");
        element.setAttribute("sourceName", string3);
        document.createAttribute("targetName");
        element.setAttribute("targetName", string4);
        document.createAttribute("transformed");
        element.setAttribute("transformed", string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTables(Element element, String string, DBUtil dBUtil, Document document) throws Exception {
        String string2 = "select s.objname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where s.objtype = 'MD_TABLES' and s.schemaid = :SCHID and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        ResultSet resultSet = null;
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                Element element2 = this.findString("tables", element);
                if (element2 == null) {
                    element2 = document.createElement("tables");
                    element.appendChild(element2);
                }
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                Element element3 = this.setData(document, "table", string4, string5, string3, string6, string7);
                element2.appendChild(element3);
                this.generateColumns(element3, string, string4, dBUtil, document);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateColumns(Element element, String string, String string2, DBUtil dBUtil, Document document) throws Exception {
        ResultSet resultSet = null;
        String string3 = "select s.objname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where s.objtype = 'MD_COLUMNS' AND s.schemaid = :SCHID and s.mainobjid = :TBLID and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        hashMap.put("TBLID", string2);
        try {
            resultSet = dBUtil.executeOracleQuery(string3, hashMap);
            while (resultSet.next()) {
                Element element2 = this.findString("columns", element);
                if (element2 == null) {
                    element2 = document.createElement("columns");
                    element.appendChild(element2);
                }
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                Element element3 = this.setData(document, "column", string5, string6, string4, string7, string8);
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    private Element findString(String string, Node node) {
        NodeList nodeList = null;
        if (node instanceof Element) {
            nodeList = ((Element)node).getElementsByTagName(string);
        } else if (node instanceof Document) {
            nodeList = ((Document)node).getElementsByTagName(string);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 == null || !node2.getNodeName().equals(string)) continue;
            return (Element)node2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStoredPrograms(Element element, String string, DBUtil dBUtil, Document document) throws Exception {
        Element element2 = null;
        Element element3 = null;
        ResultSet resultSet = null;
        String string2 = "select distinct t.objname, t.objid, t.qualifiedname, s.programtype, q.NEW_IDENTIFIER, q.TRANSFORMED from mgv_all_details t, mgv_all_stored_programs s, MD_DERIVATIVES q where objtype = 'MD_STORED_PROGRAMS' and t.schemaid = :SCHID and s.schema_id = :SCHID and t.capturedorconverted = 'CAPTURED' and t.objtype = q.SRC_TYPE and t.objid = q.SRC_ID and q.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                String string8 = resultSet.getString(6);
                if (string6.equals("FUNCTION")) {
                    element2 = this.findString("functions", element);
                    if (element2 == null) {
                        element2 = document.createElement("functions");
                        element.appendChild(element2);
                    }
                    element3 = document.createElement("function");
                } else if (string6.equals("PROCEDURE")) {
                    element2 = this.findString("procedures", element);
                    if (element2 == null) {
                        element2 = document.createElement("procedures");
                        element.appendChild(element2);
                    }
                    element3 = document.createElement("procedure");
                }
                this.setAttributes(document, element3, string4, string5, string3, string7, string8);
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSequences(Element element, String string, DBUtil dBUtil, Document document) throws Exception {
        ResultSet resultSet = null;
        String string2 = "select s.objname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where s.objtype = 'MD_SEQUENCES' and s.schemaid = :SCHID and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                Element element2 = this.findString("sequences", element);
                if (element2 == null) {
                    element2 = document.createElement("sequences");
                    element.appendChild(element2);
                }
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                Element element3 = this.setData(document, "sequence", string4, string5, string3, string6, string7);
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTriggers(Element element, String string, DBUtil dBUtil, Document document) throws Exception {
        ResultSet resultSet = null;
        String string2 = "select s.objname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where s.objtype = 'MD_TRIGGERS' and s.schemaid = :SCHID and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                Element element2 = this.findString("triggers", element);
                if (element2 == null) {
                    element2 = document.createElement("triggers");
                    element.appendChild(element2);
                }
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                Element element3 = this.setData(document, "trigger", string4, string5, string3, string6, string7);
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateViews(Element element, String string, DBUtil dBUtil, Document document) throws Exception {
        ResultSet resultSet = null;
        String string2 = "select s.objname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where s.objtype = 'MD_VIEWS' and s.schemaid = :SCHID and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                Element element2 = this.findString("views", element);
                if (element2 == null) {
                    element2 = document.createElement("views");
                    element.appendChild(element2);
                }
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                Element element3 = this.setData(document, "view", string4, string5, string3, string6, string7);
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateIndexes(Element element, String string, DBUtil dBUtil, Document document) throws Exception {
        ResultSet resultSet = null;
        String string2 = "select s.objname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where s.objtype = 'MD_INDEXES' and s.schemaid = :SCHID and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                Element element2 = this.findString("indexes", element);
                if (element2 == null) {
                    element2 = document.createElement("indexes");
                    element.appendChild(element2);
                }
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                Element element3 = this.setData(document, "index", string4, string5, string3, string6, string7);
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConstraints(Element element, String string, DBUtil dBUtil, Document document) throws Exception {
        ResultSet resultSet = null;
        String string2 = "select s.objname, s.objid, s.qualifiedname, t.NEW_IDENTIFIER, t.TRANSFORMED from mgv_all_details s, MD_DERIVATIVES t where s.objtype = 'MD_CONSTRAINTS' and s.schemaid = :SCHID and s.capturedorconverted = 'CAPTURED' and s.objtype = t.SRC_TYPE and s.objid = t.SRC_ID and t.DERIVATIVE_REASON = 'SCRATCH'";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHID", string);
        try {
            resultSet = dBUtil.executeOracleQuery(string2, hashMap);
            while (resultSet.next()) {
                Element element2 = this.findString("constraints", element);
                if (element2 == null) {
                    element2 = document.createElement("constraints");
                    element.appendChild(element2);
                }
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                Element element3 = this.setData(document, "constraint", string4, string5, string3, string6, string7);
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }
}

