/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class UntranslatedTriggersIterator
extends PersistableObjectIterator {
    private static final String QUERY_UNTRANSLATED_TRIGGERS = "SELECT ID FROM MD_TRIGGERS WHERE  (TABLE_OR_VIEW_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE SCHEMA_ID = ?) OR TABLE_OR_VIEW_ID_FK IN (SELECT VIEW_ID FROM MGV_ALL_VIEWS WHERE SCHEMA_ID = ?)) AND ID NOT IN (SELECT OBJECT_ID FROM MIGR_GENERATION_ORDER WHERE OBJECT_TYPE = 'MD_TRIGGERS'   AND CONNECTION_ID_FK IN (SELECT CONNECTION_ID FROM MGV_ALL_SCHEMA WHERE SCHEMA_ID = ?))";
    private PreparedStatement m_myStatement;

    public UntranslatedTriggersIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        super(MdTrigger.class, persistenceManager);
        MigrationObjectFilter migrationObjectFilter;
        String string = QUERY_UNTRANSLATED_TRIGGERS;
        String string2 = null;
        if (migrationObjectFilterList != null && (migrationObjectFilter = migrationObjectFilterList.getFilterForType("MD_TRIGGERS")) != null) {
            string2 = migrationObjectFilter.toConditionClause("TRIGGER_NAME", "ID");
        }
        if (string2 != null) {
            string = string + " AND " + string2;
        }
        try {
            this.m_myStatement = persistenceManager.getPreparedStatement(string);
            this.m_myStatement.setLong(1, dBObjectId.getId());
            this.m_myStatement.setLong(2, dBObjectId.getId());
            this.m_myStatement.setLong(3, dBObjectId.getId());
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement() throws SQLException {
        return this.m_myStatement;
    }
}

