/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdHelp;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;

public class MigrationCommandProcessor
implements HeadlessCommandProcessor {
    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headlessCore, String ... stringArray) throws InvalidCommandArgumentException {
        MigrationDetails migrationDetails = new MigrationDetails(stringArray);
        if (stringArray.length > 0) {
            return new migrationTask(stringArray[0], migrationDetails);
        }
        MigrationCmdHelp.help(migrationDetails, migrationDetails.getOut());
        return null;
    }

    public String getUsageString() {
        return null;
    }

    public static class migrationTask
    extends HeadlessTask<Void> {
        private MigrationDetails m_migrationDetails = null;
        private CMDOut m_out = null;

        protected migrationTask(String string, MigrationDetails migrationDetails) {
            super(string);
            this.m_migrationDetails = migrationDetails;
            this.m_out = migrationDetails.getOut();
        }

        protected Void doWork() throws TaskException {
            if (this.m_migrationDetails.isValid()) {
                try {
                    this.m_migrationDetails.setDescriptor(this.getDescriptor());
                    this.execute(this.m_migrationDetails);
                }
                catch (CMDLineError cMDLineError) {
                    this.m_out.printError(cMDLineError);
                    throw new TaskException(cMDLineError.getCause());
                }
                catch (Exception exception) {
                    this.m_out.printError(exception);
                    MigrationCmdHelp.help(this.m_migrationDetails, this.m_out);
                    throw new TaskException(exception.getCause());
                }
                finally {
                    this.m_out.close();
                }
            } else {
                MigrationCmdHelp.help(this.m_migrationDetails, this.m_out);
            }
            return null;
        }

        private void execute(MigrationDetails migrationDetails) throws Exception {
            MigrationCmd migrationCmd = null;
            String[] stringArray = null;
            boolean bl = false;
            if (migrationDetails != null) {
                stringArray = migrationDetails.getAllActionNames();
                if (migrationDetails.contains("help") || migrationDetails.contains("h")) {
                    if (stringArray != null && stringArray.length > 0) {
                        MigrationCmdHelp.usages(stringArray, this.m_out);
                    } else {
                        MigrationCmdHelp.help(migrationDetails, this.m_out);
                    }
                    return;
                }
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    bl = false;
                    migrationCmd = MigrationCmdRegistry.getMigrationCmd(stringArray[i], migrationDetails, this.m_out, false);
                    if (migrationCmd == null) {
                        throw new CMDLineError(stringArray[i], "Invalid Command", null);
                    }
                    migrationCmd.execute();
                    bl = true;
                }
            }
        }
    }
}

