/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Image;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.LazyIcon;
import oracle.dbtools.raptor.utils.RaptorResourceBundleControl;

public abstract class MessagesBase {
    private static Map<IconKey, ImageIcon> s_icons = new HashMap<IconKey, ImageIcon>();
    private final ResourceBundle m_bundle;

    protected MessagesBase(String string, ClassLoader classLoader) {
        this.m_bundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader, RaptorResourceBundleControl.INSTANCE);
    }

    protected ResourceBundle getResourceBundle() {
        return this.m_bundle;
    }

    protected String getStringImpl(String string) {
        try {
            return this.m_bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return '!' + string + '!';
        }
    }

    protected Image getImageImpl(String string) {
        ImageIcon imageIcon = this.getImageIconImpl(string);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon getImageIconImpl(String string) {
        ImageIcon imageIcon;
        String string2 = this.m_bundle.getString(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        Class<?> clazz = this.getClass();
        IconKey iconKey = new IconKey(clazz.getName(), string);
        Object object = s_icons;
        synchronized (object) {
            imageIcon = s_icons.get(iconKey);
            if (imageIcon != null) {
                return imageIcon;
            }
        }
        object = clazz.getResource(string2);
        imageIcon = null;
        if (object != null) {
            imageIcon = new LazyIcon((URL)object);
            Map<IconKey, ImageIcon> map = s_icons;
            synchronized (map) {
                s_icons.put(iconKey, imageIcon);
            }
        }
        return imageIcon;
    }

    protected Icon getIconImpl(String string) {
        return this.getImageIconImpl(string);
    }

    protected String formatImpl(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(this.m_bundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return '!' + string + '!';
        }
    }

    public final Integer getIntegerImpl(String string) {
        String string2 = this.getStringImpl(string);
        if (string2.length() == 1 && Character.isLetter(string2.charAt(0))) {
            return new Integer(string2.charAt(0));
        }
        return Integer.valueOf(string2);
    }

    private static class IconKey {
        private String m_cls;
        private String m_key;

        private IconKey(String string, String string2) {
            this.m_cls = string;
            this.m_key = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof IconKey) {
                return ModelUtil.areEqual(((IconKey)object).m_cls, this.m_cls) && ModelUtil.areEqual(((IconKey)object).m_key, this.m_key);
            }
            return false;
        }

        public int hashCode() {
            return this.m_cls.hashCode() + this.m_key.hashCode();
        }

        public String toString() {
            return this.m_cls + ":" + this.m_key;
        }
    }
}

