/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.util.Random;

public class GuidGen {
    private static byte[] m_arrIeee = null;
    private static int m_nClockSeq = 0;
    private static char[] m_arrHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int GUID_LENGTH = 16;
    private static String m_lastUuid = null;

    public static synchronized byte[] uuidCreate() {
        byte[] byArray = GuidGen.uuidCreateImpl().toByteArray();
        m_lastUuid = GuidGen.toString(byArray);
        return byArray;
    }

    private static synchronized ByteArrayOutputStream uuidCreateImpl() {
        long l = System.currentTimeMillis();
        byte[] byArray = GuidGen.getIeeeNodeIdentifier();
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16);
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        short s = (short)(l >> 32 & 0xFFFFL);
        short s2 = (short)((l >> 32 & 0xFFF0000L) >> 16);
        s2 = (short)(s2 | 0x1000);
        byte by = (byte)(m_nClockSeq & 0xFF);
        byte by2 = (byte)((m_nClockSeq & 0x3F00) >> 8);
        by2 = (byte)(by2 | 0x80);
        byteArrayOutputStream.write(n >> 24 & 0xFF);
        byteArrayOutputStream.write(n >> 16 & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(s >> 8 & 0xFF);
        byteArrayOutputStream.write(s & 0xFF);
        byteArrayOutputStream.write(s2 >> 8 & 0xFF);
        byteArrayOutputStream.write(s2 & 0xFF);
        byteArrayOutputStream.write(by2);
        byteArrayOutputStream.write(by);
        byteArrayOutputStream.write(byArray, 0, 6);
        ++m_nClockSeq;
        if (m_lastUuid != null && m_lastUuid.equals(GuidGen.toString(byteArrayOutputStream.toByteArray()))) {
            byteArrayOutputStream = GuidGen.uuidCreateImpl();
        }
        return byteArrayOutputStream;
    }

    public static String toString(byte[] byArray) {
        if (byArray.length != 16) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            GuidGen.byteToHex(stringBuffer, byArray[i]);
            if (i != 3 && i != 5 && i != 7 && i != 9) continue;
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    public static byte[] toRaw(String string) {
        if (string == null || string.length() != 36 || string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            return null;
        }
        byte[] byArray = new byte[16];
        int n = 0;
        for (int i = 0; i < string.length(); i += 2) {
            if (i == 8 || i == 13 || i == 18 || i == 23) {
                ++i;
            }
            String string2 = string.substring(i, i + 2);
            byArray[n++] = (byte)Short.parseShort(string2, 16);
        }
        return byArray;
    }

    public static void byteToHex(StringBuffer stringBuffer, byte by) {
        stringBuffer.append(m_arrHex[by >> 4 & 0xF]);
        stringBuffer.append(m_arrHex[by & 0xF]);
    }

    private static byte[] getIeeeNodeIdentifier() {
        if (m_arrIeee != null) {
            return m_arrIeee;
        }
        Random random = new Random(System.currentTimeMillis() + (long)m_nClockSeq++);
        m_arrIeee = new byte[6];
        byte[] byArray = null;
        try {
            byArray = InetAddress.getLocalHost().getAddress();
            if (byArray.length != 4) {
                throw new Exception("IP address != 4 bytes!!");
            }
            byte[] byArray2 = new byte[2];
            random.nextBytes(byArray2);
            GuidGen.m_arrIeee[0] = byArray[0];
            GuidGen.m_arrIeee[1] = byArray[1];
            GuidGen.m_arrIeee[2] = byArray[2];
            GuidGen.m_arrIeee[3] = byArray[3];
            GuidGen.m_arrIeee[4] = byArray2[0];
            GuidGen.m_arrIeee[5] = byArray2[1];
        }
        catch (Exception exception) {
            GuidGen.TRACE("getIeeeNodeIdentifier() - " + exception);
            random.nextBytes(m_arrIeee);
        }
        return m_arrIeee;
    }

    private static void TRACE(String string) {
        System.out.println("GuidGen." + string);
    }

    static void main(String[] stringArray) {
        byte[] byArray = null;
        String string = null;
        try {
            for (int i = 0; i < 100; ++i) {
                byArray = GuidGen.uuidCreate();
                string = GuidGen.toString(byArray);
                GuidGen.TRACE("UUID = " + string);
            }
            byArray = GuidGen.uuidCreate();
            string = GuidGen.toString(byArray);
            byte[] byArray2 = GuidGen.toRaw(string);
            String string2 = GuidGen.toString(byArray2);
            GuidGen.TRACE("----------------------------------------------------------");
            GuidGen.TRACE("SRC - " + string);
            GuidGen.TRACE("DST - " + string2);
        }
        catch (Exception exception) {
            GuidGen.TRACE(exception.toString());
        }
    }
}

