/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QueryXMLSupport {
    private static Map<String, QueryXMLSupport> s_sql = new HashMap<String, QueryXMLSupport>();
    private static Map<String, Map<String, String>> s_typeAtts = new HashMap<String, Map<String, String>>();
    private Map<String, ObjectQueries> m_queryMap;

    public static QueryXMLSupport getQueryXMLSupport(String string) {
        return QueryXMLSupport.getQueryXMLSupport(new MetaResource(QueryXMLSupport.class.getClassLoader(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryXMLSupport getQueryXMLSupport(MetaResource metaResource) {
        QueryXMLSupport queryXMLSupport;
        if (metaResource.getResourcePath().startsWith("file://")) {
            s_sql.remove(metaResource.getResourcePath());
        }
        if ((queryXMLSupport = s_sql.get(metaResource.getResourcePath())) == null) {
            URL uRL = metaResource.toURL();
            if (uRL == null && metaResource.getResourcePath().startsWith("file://")) {
                try {
                    uRL = new URL(metaResource.getResourcePath());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL != null) {
                DOMParser dOMParser = new DOMParser();
                dOMParser.setPreserveWhitespace(false);
                InputStream inputStream = null;
                try {
                    inputStream = uRL.openStream();
                    dOMParser.parse(inputStream);
                    XMLDocument xMLDocument = dOMParser.getDocument();
                    Node node = XMLHelper.getChildNode((Node)xMLDocument, "/source");
                    if (node != null) {
                        HashMap<String, ObjectQueries> hashMap = new HashMap<String, ObjectQueries>();
                        for (XMLNode xMLNode : XMLHelper.getChildNodes(node, "queryType")) {
                            String string = XMLHelper.getAttributeNode((Node)xMLNode, "id");
                            ObjectQueries objectQueries = new ObjectQueries((XMLNode)XMLHelper.getChildNode((Node)xMLNode, "queries"));
                            hashMap.put(string, objectQueries);
                            HashMap<String, String> hashMap2 = new HashMap<String, String>();
                            NamedNodeMap namedNodeMap = xMLNode.getAttributes();
                            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                                Attr attr = (Attr)namedNodeMap.item(i);
                                hashMap2.put(attr.getName(), attr.getValue());
                            }
                            s_typeAtts.put(string, hashMap2);
                        }
                        queryXMLSupport = new QueryXMLSupport(hashMap);
                        s_sql.put(metaResource.getResourcePath(), queryXMLSupport);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(QueryXMLSupport.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return queryXMLSupport;
    }

    private QueryXMLSupport(Map<String, ObjectQueries> map) {
        this.m_queryMap = map;
    }

    public String getQueryAttribute(String string, String string2) {
        if (s_typeAtts.get(string) != null && s_typeAtts.get(string).get(string2) != null) {
            return s_typeAtts.get(string).get(string2);
        }
        return null;
    }

    public Query getQuery(String string, String string2) {
        ObjectQueries objectQueries = this.m_queryMap.get(string);
        return objectQueries != null ? objectQueries.getQuery(string2) : null;
    }

    public Query getQuery(String string, Connection connection) {
        ObjectQueries objectQueries = this.m_queryMap.get(string);
        return objectQueries != null ? objectQueries.getQuery(connection) : null;
    }
}

