/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.Serializable;
import oracle.dbtools.common.utils.ModelUtil;

public abstract class QueryParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String type;
    private boolean sortable;
    private boolean filterable;
    private String prompt;
    private String tooltip;
    private boolean isDefaultFilter;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setFilterable(boolean bl) {
        this.filterable = bl;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setDefaultFilter(boolean bl) {
        this.isDefaultFilter = bl;
    }

    public boolean isDefaultFilter() {
        return this.isDefaultFilter;
    }

    public abstract String toXML(int var1);

    public static String getIndent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        return string;
    }

    protected String getBaseAttributes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterable) {
            stringBuffer.append("filterable=\"true\"");
        }
        if (this.sortable) {
            stringBuffer.append("sortable=\"true\"");
        }
        return stringBuffer.toString();
    }

    protected String getBaseChildren(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (ModelUtil.hasLength(this.type)) {
            stringBuffer.append(QueryParameter.getIndent(n) + "<type><![CDATA[" + this.type + "]]></type>\n");
        }
        if (ModelUtil.hasLength(this.prompt)) {
            stringBuffer.append(QueryParameter.getIndent(n) + "<prompt><![CDATA[" + this.prompt + "]]></prompt>\n");
        }
        if (ModelUtil.hasLength(this.tooltip)) {
            stringBuffer.append(QueryParameter.getIndent(n) + "<tooltip><![CDATA[" + this.tooltip + "]]></tooltip>\n");
        }
        return stringBuffer.toString();
    }
}

