/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proformatter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.raptor.proformatter.ICodingStyleSQLOptions;
import oracle.dbtools.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FormatHelper {
    public static final int UNKNOWNINT = -1;
    public static final String ORACLE = "Oracle";
    public static final int ORACLEINT = 1;
    public static final String DB2 = "DB2";
    public static final int DB2INT = 2;
    public static final String SYBASE = "Sybase";
    public static final int SYBASEINT = 3;
    public static final String ACCESS = "Microsoft Access";
    public static final int ACCESSINT = 4;
    public static final String SQLSERVER = "Microsoft SQL Server";
    public static final int SQLSERVERINT = 5;
    public static final String MYSQL = "MySQL";
    public static final int MYSQLINT = 6;
    private static URL u;

    public static ICodingStyleSQLOptions loadFromXML(ICodingStyleSQLOptions iCodingStyleSQLOptions, URL uRL) {
        u = uRL;
        return FormatHelper.loadFromXML(iCodingStyleSQLOptions);
    }

    public static ICodingStyleSQLOptions loadFromXML(ICodingStyleSQLOptions iCodingStyleSQLOptions) {
        String string = System.getenv("SQLFORMATPATH");
        if (string == null && u != null) {
            FormatHelper.populateBean(u, (Object)iCodingStyleSQLOptions, "Item");
        } else if (!new File(string).exists() && u != null) {
            FormatHelper.populateBean(u, (Object)iCodingStyleSQLOptions, "Item");
        } else {
            return null;
        }
        return iCodingStyleSQLOptions;
    }

    public static void populateBean(String string, Object object, String string2) {
        File file = new File(string);
        try {
            FormatHelper.populateBean(file.toURI().toURL(), object, string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void populateBean(URL uRL, Object object, String string) {
        Object object2;
        Method[] methodArray = object.getClass().getDeclaredMethods();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        boolean bl = false;
        for (Method object32 : methodArray) {
            object2 = object32.getName();
            if (!((String)object2).startsWith("set")) continue;
            hashMap.put((String)object2, object32);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Exception object4 = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(uRL.openStream());
            object2 = document.getElementsByTagName(string);
            for (int i = 0; i < object2.getLength(); ++i) {
                Object object3;
                Node node = object2.item(i);
                Node node2 = null;
                Node node3 = null;
                NodeList nodeList = node.getChildNodes();
                for (int j = 0; j < object2.getLength(); ++j) {
                    object3 = nodeList.item(j);
                    if (object3.getNodeName().equals("Key")) {
                        node2 = object3;
                    }
                    if (!object3.getNodeName().equals("Value")) continue;
                    node3 = object3;
                    break;
                }
                if (node2 == null || node3 == null || node2.getFirstChild() == null || node2.getFirstChild().getNodeValue() == null || !node2.getFirstChild().getNodeValue().equals("1:SQL")) continue;
                Node node4 = node3;
                object3 = node4.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    try {
                        String string2 = object3.item(j).getNodeName();
                        String string3 = "set" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
                        Method method = null;
                        if (string3.equals("set#text") || string3.equals("setMemberOrderHashStructure")) continue;
                        method = (Method)hashMap.get(string3);
                        if (method == null) {
                            Logger.info(new FormatHelper().getClass(), "the method: " + string3 + " does not exist");
                            continue;
                        }
                        String string4 = object3.item(j).getChildNodes().item(0).getNodeValue();
                        if (string2.equals("name")) {
                            method.invoke(object, string4);
                            hashMap.remove(string3);
                            continue;
                        }
                        if (string4 == null || string4.equals("")) continue;
                        if (string4.equals("true")) {
                            method.invoke(object, true);
                            hashMap.remove(string3);
                            continue;
                        }
                        if (string4.equals("false")) {
                            method.invoke(object, false);
                            hashMap.remove(string3);
                            continue;
                        }
                        method.invoke(object, Integer.parseInt(string4));
                        hashMap.remove(string3);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object4 = illegalAccessException;
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object4 = invocationTargetException;
                        continue;
                    }
                    finally {
                        if (object4 != null) {
                            Logger.severe(new FormatHelper().getClass(), object4);
                        }
                    }
                }
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Logger.info(new FormatHelper().getClass(), "Method " + (String)iterator.next() + "has not been matched");
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            void var9_19;
            SAXParseException sAXParseException2 = sAXParseException;
            if (sAXParseException.getException() != null) {
                Exception exception = sAXParseException.getException();
            }
            Logger.severe(new FormatHelper().getClass(), "\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "  " + sAXParseException.getMessage() + var9_19.getMessage());
        }
        catch (SAXException sAXException) {
            void var9_22;
            SAXException sAXException2 = sAXException;
            if (sAXException.getException() != null) {
                Exception exception = sAXException.getException();
            }
            object4 = var9_22;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            object4 = iOException;
        }
        finally {
            if (object4 != null) {
                Logger.severe(new FormatHelper().getClass(), object4);
            }
        }
    }

    public static final String dbToFormatter(int n) {
        if (n == 1) {
            return ORACLE;
        }
        if (n == 2) {
            return "DB2/UDB";
        }
        if (n == 3) {
            return SYBASE;
        }
        if (n == 4) {
            return "MSAccess";
        }
        if (n == 5) {
            return "SQL Server";
        }
        if (n == 6) {
            return "MYSQL";
        }
        return "Any SQL";
    }
}

