/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowUsercmd
implements IShowCommand {
    private static final String[] SHOWUSERCMD = new String[]{"user"};

    @Override
    public String[] getShowAliases() {
        return SHOWUSERCMD;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowUsercmd(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowUsercmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (connection == null) {
                scriptRunnerContext.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", "")));
            } else {
                scriptRunnerContext.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", DBUtil.getInstance(connection).executeOracleReturnOneCol("select USER from dual", new HashMap()))));
            }
            scriptRunnerContext.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner("\n"));
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }
}

