/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class ShowTopLevel
implements IShowCommand {
    private static final String[] SHOWTOPLEVEL = new String[]{"toplevel"};

    @Override
    public String[] getShowAliases() {
        return SHOWTOPLEVEL;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return ShowTopLevel.doShowTopLevel(connection, scriptRunnerContext, iSQLCommand);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private static boolean doShowTopLevel(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            boolean bl = scriptRunnerContext.getTopLevel();
            scriptRunnerContext.write("Toplevel ");
            if (bl) {
                scriptRunnerContext.write("TRUE \n");
            } else {
                scriptRunnerContext.write("FALSE     SCRIPT_DEPTH " + (Integer)scriptRunnerContext.getProperty("script.runner.script_depth"));
            }
        }
        catch (Exception exception) {
            Logger.getLogger("ShowTopLevel").log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }
}

