/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowServeroutput
implements IShowCommand {
    private static final String[] SHOWSERVEROUTPUT = new String[]{"serverout", "serveroutp", "serveroutpu", "serveroutput"};

    @Override
    public String[] getShowAliases() {
        return SHOWSERVEROUTPUT;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowServeroutput(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doShowServeroutput(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.context.serveroutput");
        Integer n = (Integer)scriptRunnerContext.getProperty("script.runner.lastsetserveroutput");
        if (bl != null && bl.equals(Boolean.TRUE)) {
            scriptRunnerContext.write("serveroutput ON SIZE " + n + "\n");
        } else {
            scriptRunnerContext.write("serveroutput OFF\n");
        }
        return true;
    }
}

