/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IEndOfShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowAllNeither;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowRegistry;
import oracle.jdbc.OracleConnection;

public class ShowParameter
implements IShowCommand,
IEndOfShowCommand,
IShowAllNeither {
    private static final String[] SHOWPARAMETER = new String[]{"parameter", "parameters"};

    @Override
    public String[] getShowAliases() {
        return SHOWPARAMETER;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowParameter(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doShowParameter(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        block30: {
            String string = ScriptUtils.eatOneWord(iSQLCommand.getSql()).toLowerCase();
            String string2 = null;
            string2 = string.startsWith(SHOWPARAMETER[1]) ? string.replaceAll("^" + SHOWPARAMETER[1], "").trim().split("\\s+")[0] : string.replaceAll("^" + SHOWPARAMETER[0], "").trim().split("\\s+")[0];
            if (string2.equalsIgnoreCase("flagger") && !ShowRegistry.get(string2)) {
                scriptRunnerContext.write(ScriptUtils.eatOneWord(iSQLCommand.getSql()) + " unsupported\n");
                return false;
            }
            String string3 = "%";
            if (!string2.equals("")) {
                string3 = "%" + string2 + "%";
            }
            boolean bl = false;
            ResultSet resultSet = null;
            ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
            try {
                bl = connectionResolver.lock(scriptRunnerContext.getCurrentConnection());
                if (!bl) break block30;
                String string4 = null;
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
                string4 = DBUtil.getDbVersion(scriptRunnerContext.getCurrentConnection()).compareTo(new Version("10.0")) >= 0 ? "SELECT   substr(NAME,0,50) NAME, DECODE(TYPE,1,'boolean',2,'string',3,'integer',4,'file',5,'number',  6,'big integer', 'unknown') TYPE, substr(DISPLAY_VALUE,0,100) VALUE FROM V$PARAMETER  WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ) ORDER BY NAME,ROWNUM" : "SELECT substr(NAME,0,50) NAME, DECODE(TYPE,1,'boolean',2,'string',3,'integer',4,'file',6,'big integer',  'unknown') TYPE, substr(VALUE,0,100) VALUE FROM V$PARAMETER WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ)  ORDER BY NAME,ROWNUM ";
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string3);
                resultSet = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeQuery(string4, arrayList);
                if (resultSet != null) {
                    Integer n;
                    ResultSetFormatter resultSetFormatter;
                    block31: {
                        resultSetFormatter = new ResultSetFormatter(scriptRunnerContext);
                        resultSetFormatter.setProgressUpdater(scriptRunnerContext.getTaskProgressUpdater());
                        n = null;
                        try {
                            if (scriptRunnerContext.getProperty("script.runner.arraysize") != null) {
                                n = Integer.valueOf((String)scriptRunnerContext.getProperty("script.runner.arraysize"));
                                break block31;
                            }
                            boolean bl2 = false;
                            Connection connection2 = scriptRunnerContext.getBaseConnection();
                            if (connection2 != null) {
                                bl2 = connectionResolver.lock(connection2);
                            }
                            if (!bl2) break block31;
                            try {
                                Properties properties = connectionResolver.getConnectionInfo(connectionResolver.getConnectionName(connection2));
                                n = Integer.valueOf(properties.getProperty("PreferfedFetchSize"));
                            }
                            finally {
                                connectionResolver.unlock(connection2);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (n != null) {
                        try {
                            resultSet.setFetchSize(n);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    resultSetFormatter.rset2sqlplusShrinkToSize(resultSet, scriptRunnerContext.getCurrentConnection(), scriptRunnerContext.getOutputStream());
                    break block30;
                }
                scriptRunnerContext.write(Messages.getString("SHOWPARAMETERSNORESULTSET"));
            }
            catch (IOException iOException) {
                scriptRunnerContext.write(iOException.getLocalizedMessage());
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                scriptRunnerContext.write(sQLException.getLocalizedMessage());
            }
            finally {
                if (resultSet != null) {
                    DBUtil.closeResultSet(resultSet);
                }
                if (bl) {
                    try {
                        connectionResolver.unlock(scriptRunnerContext.getCurrentConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }
}

