/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.newscriptrunner.commands.net.Net;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NetParser {
    private static final String NET = "net";
    private static final String NETENTRIES = "netentries";
    private static final String DESC = "description";
    private static final String QUERIES = "queries";
    private static final String QUERY = "query";
    private static final String SQL = "sql";
    private static final String NAME = "name";
    protected static Logger LOGGER = Logger.getLogger(NetParser.class.getName());
    private XMLDocument _document;
    private DOMParser parser;
    ArrayList<Net> netAL = new ArrayList();

    public NetParser() {
    }

    public NetParser(URL uRL) {
        try {
            this.parser.parse(uRL.openStream());
            this._document = this.parser.getDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putXML(File file, ArrayList<Net> arrayList) throws Exception {
        file.createNewFile();
        Element element = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element2 = document.createElement(NETENTRIES);
        for (Net object2 : arrayList) {
            element = document.createElement(NET);
            element.setAttribute(NAME, object2.getName());
            Element element3 = document.createElement(DESC);
            element3.appendChild(document.createCDATASection(object2.getDesc()));
            element.appendChild(element3);
            Element element4 = document.createElement(QUERIES);
            Element element5 = document.createElement(QUERY);
            Element element6 = document.createElement(SQL);
            element6.appendChild(document.createCDATASection(object2.getQuery()));
            element5.appendChild(element6);
            element4.appendChild(element5);
            element.appendChild(element4);
            element2.appendChild(element);
        }
        document.appendChild(element2);
        Object object = null;
        try {
            Transformer iOException = TransformerFactory.newInstance().newTransformer();
            iOException.setOutputProperty("indent", "yes");
            iOException.setOutputProperty("method", "xml");
            iOException.setOutputProperty("encoding", "UTF-8");
            iOException.setOutputProperty("cdata-section-elements", "sql description");
            iOException.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            object = new FileOutputStream(file.getAbsolutePath());
            iOException.transform(new DOMSource(document), new StreamResult((OutputStream)object));
        }
        finally {
            if (object != null) {
                try {
                    ((FileOutputStream)object).close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getLocalizedMessage());
                }
            }
        }
    }

    public ArrayList<Net> processXML(URL uRL) throws Exception {
        if (this.parser == null) {
            this.parser = new DOMParser();
        } else {
            this.parser.reset();
        }
        this.parser.setPreserveWhitespace(false);
        this.parser.parse(uRL.openStream());
        this._document = this.parser.getDocument();
        NodeList nodeList = this._document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.processNodes(nodeList.item(i));
        }
        return this.netAL;
    }

    private void processNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equalsIgnoreCase(NET)) continue;
            this.newItem(node2);
        }
    }

    private void newItem(Node node) {
        String string = XMLHelper.getAttributeNode(node, NAME);
        String string2 = "";
        String string3 = "";
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equalsIgnoreCase(DESC) && (object = node2.getFirstChild()) instanceof Text) {
                string2 = ((Text)object).getTextContent();
            }
            if (!node2.getNodeName().equalsIgnoreCase(QUERIES)) continue;
            object = node2.getChildNodes();
            for (int j = 0; j < object.getLength(); ++j) {
                Node node3 = object.item(j);
                if (!node3.getLocalName().equalsIgnoreCase(QUERY)) continue;
                NodeList nodeList2 = node3.getChildNodes();
                for (int k = 0; k < nodeList2.getLength(); ++k) {
                    Node node4 = nodeList2.item(k);
                    Node node5 = node4.getFirstChild();
                    if (!(node5 instanceof Text)) continue;
                    string3 = ((Text)node5).getTextContent();
                }
            }
        }
        this.netAL.add(new Net(string, string3, string2));
    }
}

