/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.editor;

import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.plusplus.FileSystem;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;

public class SaveCommand
extends CommandListener
implements IHelp {
    private static final String CMD = "save";
    private static final String FILE = "file";
    private static final String CREATE_PATTERN = "(?i:cre(?:ate))";
    private static final String APPEND_PATTERN = "(?i:app(?:end))";
    private static final String REPLACE_PATTERN = "(?i:rep(?:lace))";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string;
        String string2 = iSQLCommand.getSql().trim();
        String[] stringArray = string2.split("\\s+");
        String string3 = "";
        FileSystem.State state = FileSystem.State.UNKNOWN;
        switch (stringArray.length) {
            case 1: {
                scriptRunnerContext.write("SP2-0105: Illegal, or missing, entity name\n\n");
                scriptRunnerContext.write(this.getHelp());
                return true;
            }
            case 2: {
                string3 = scriptRunnerContext.prependCD(stringArray[1]);
                break;
            }
            case 3: {
                if (stringArray[1].toLowerCase().equals(FILE)) {
                    string3 = scriptRunnerContext.prependCD(stringArray[2]);
                    break;
                }
                string3 = scriptRunnerContext.prependCD(stringArray[1]);
                state = this.getMode(stringArray[2]);
                break;
            }
            case 4: {
                string3 = scriptRunnerContext.prependCD(stringArray[2]);
                state = this.getMode(stringArray[3]);
                break;
            }
        }
        if (string3.lastIndexOf(".") == -1 && (string = (String)scriptRunnerContext.getProperty("script.runner.file.suffix")).length() > 0) {
            string3 = string3 + "." + string;
        }
        switch (state) {
            case UNKNOWN: 
            case CREATE: {
                scriptRunnerContext.write(scriptRunnerContext.getSQLPlusBuffer().save(string3, FileSystem.State.CREATE, (String)scriptRunnerContext.getProperty("script.runner.file.suffix")));
                break;
            }
            case APPEND: {
                scriptRunnerContext.write(scriptRunnerContext.getSQLPlusBuffer().save(string3, FileSystem.State.APPEND, (String)scriptRunnerContext.getProperty("script.runner.file.suffix")));
                break;
            }
            case REPLACE: {
                scriptRunnerContext.write(scriptRunnerContext.getSQLPlusBuffer().save(string3, FileSystem.State.REPLACE, (String)scriptRunnerContext.getProperty("script.runner.file.suffix")));
                break;
            }
        }
        return true;
    }

    private FileSystem.State getMode(String string) {
        Matcher matcher = Pattern.compile(CREATE_PATTERN).matcher(string);
        if (matcher != null && matcher.find()) {
            return FileSystem.State.CREATE;
        }
        matcher = Pattern.compile(APPEND_PATTERN).matcher(string);
        if (matcher != null && matcher.find()) {
            return FileSystem.State.APPEND;
        }
        matcher = Pattern.compile(REPLACE_PATTERN).matcher(string);
        if (matcher != null && matcher.find()) {
            return FileSystem.State.REPLACE;
        }
        return FileSystem.State.UNKNOWN;
    }

    @Override
    public String getCommand() {
        return CMD.toUpperCase();
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

