/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.editor;

import java.sql.Connection;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;

public class ListCommand
extends CommandListener
implements IHelp {
    private static final String LIST = "LIST";
    private static final String CMD = "list|lis|li|l";
    private static final String STAR = "*";
    private static final String LAST = "last";

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim();
        String[] stringArray = string.split("\\s+");
        if (stringArray.length >= 1 && stringArray[0].matches(CMD) && scriptRunnerContext.getSQLPlusBuffer() != null) {
            IBuffer iBuffer = scriptRunnerContext.getSQLPlusBuffer().getBufferSafe();
            if (stringArray.length == 1) {
                scriptRunnerContext.write(iBuffer.list());
            } else if (stringArray.length == 2) {
                String string2 = stringArray[1];
                int n = 0;
                if (string2.equals(STAR)) {
                    scriptRunnerContext.write(iBuffer.listStar());
                } else if (string2.equals(LAST)) {
                    scriptRunnerContext.write(iBuffer.listLast());
                } else {
                    try {
                        n = Integer.parseInt(string2);
                        scriptRunnerContext.write(iBuffer.list(n));
                    }
                    catch (NumberFormatException numberFormatException) {
                        scriptRunnerContext.write(this.getHelp());
                    }
                }
            } else if (stringArray.length == 3) {
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                if (string3.equals(STAR) || string4.equals(STAR)) {
                    if (string3.equals(STAR)) {
                        if (this.isAnInteger(string4)) {
                            scriptRunnerContext.write(iBuffer.listStarN(Integer.parseInt(string4)));
                        }
                    } else if (string4.equals(STAR) && this.isAnInteger(string3)) {
                        scriptRunnerContext.write(iBuffer.listNStar(Integer.parseInt(string3)));
                    }
                } else if (this.isAnInteger(string3) && this.isAnInteger(string4)) {
                    scriptRunnerContext.write(iBuffer.list(Integer.parseInt(string3), Integer.parseInt(string4)));
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public String getCommand() {
        return LIST;
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(LIST);
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

