/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.AliasParser;

public class Aliases {
    public static final String CONFIGFILE = File.separator + "aliases.xml";
    public static final String CONFIGBACK = File.separator + "aliases.xml~";
    private HashMap<String, Alias> aliases = new HashMap();
    private static Aliases _INSTANCE;
    private Set<String> defaultAliases = new HashSet<String>();

    public static String getBase() {
        String string = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String string2 = System.getenv("APPDATA");
            string = string2 != null ? string2 + File.separator + "sqlcl" : null;
        }
        return string;
    }

    public static Aliases getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new Aliases();
            _INSTANCE.load();
        }
        return _INSTANCE;
    }

    public Aliases() {
        URL uRL = this.getClass().getClassLoader().getResource("oracle/dbtools/raptor/newscriptrunner/commands/alias/aliases.xml");
        AliasParser aliasParser = new AliasParser();
        try {
            ArrayList<Alias> arrayList = aliasParser.processXML(uRL);
            for (Alias alias : arrayList) {
                this.defaultAliases.add(alias.getName().toUpperCase());
                this.aliases.put(alias.getName(), alias);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getLocalizedMessage());
        }
    }

    public void add() {
    }

    public void add(String string, String string2, String string3) {
        if (this.aliases.containsKey(string)) {
            this.aliases.remove(string);
        }
        Alias alias = new Alias(string, string2, string3);
        this.aliases.put(string, alias);
    }

    public void add(String string, String string2) {
        this.add(string, string2, "");
    }

    public void drop(String string) {
        if (this.aliases.containsKey(string)) {
            this.aliases.remove(string);
        }
    }

    public ArrayList<String> getAliases() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.aliases.keySet()) {
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean contains(String string) {
        return this.aliases.containsKey(string);
    }

    public Alias get(String string) {
        return this.aliases.get(string);
    }

    public String save() {
        return this.save(null);
    }

    public String save(String string) {
        String string2 = Aliases.getBase();
        new File(string2).mkdirs();
        File file = null;
        if (string != null) {
            file = new File(string);
        } else {
            string = string2 + CONFIGFILE;
            file = new File(string);
        }
        ArrayList<Alias> arrayList = new ArrayList<Alias>();
        AliasParser aliasParser = new AliasParser();
        try {
            for (Map.Entry<String, Alias> entry : this.aliases.entrySet()) {
                Alias alias = entry.getValue();
                if (this.defaultAliases.contains(alias.getName().toUpperCase())) continue;
                arrayList.add(alias);
            }
            if (string2 == null) {
                return "ALIAS-013 APPDATA is null\n";
            }
            if (file.exists()) {
                if (!file.delete()) {
                    return MessageFormat.format("ALIAS-011 {0} could not be deleted \n", string);
                }
                try {
                    Files.move(Paths.get(string, new String[0]), Paths.get(string + ".bak", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception exception) {
                    return MessageFormat.format("ALIAS-010 {0} could not be renamed to {1} : {2}\n", string, string + ".bak", exception.getMessage());
                }
            }
            if (string2 != null) {
                aliasParser.putXML(new File(string), arrayList);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getLocalizedMessage());
        }
        return MessageFormat.format("ALIAS-007 - Aliases saved to {0}\n", string);
    }

    public String load() {
        return this.load(null);
    }

    public String load(String string) {
        Object object;
        File file = null;
        if (string != null) {
            file = new File(string);
        } else {
            object = Aliases.getBase();
            if (object == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "ALIAS-013 APPDATA is null\n");
            }
            string = (String)object + CONFIGFILE;
            file = new File(string);
        }
        if (file.exists()) {
            try {
                object = new AliasParser();
                URL uRL = file.toURI().toURL();
                if (file.canRead()) {
                    ArrayList<Alias> arrayList = ((AliasParser)object).processXML(uRL);
                    for (Alias alias : arrayList) {
                        if (this.defaultAliases.contains(alias.getName().toUpperCase())) continue;
                        this.aliases.put(alias.getName(), alias);
                    }
                    return "Aliases Loaded\n";
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage());
            }
        } else {
            return MessageFormat.format("ALIAS-012 {0} could not be read.\n", string);
        }
        return "";
    }
}

