/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class ShowErrors
extends CommandListener {
    private static final String CMD = "show err";
    private static final String SHOCMD = "sho err";
    private static final String VERBOSE_CMD = "set errorswithlines";
    private static final String VERBOSE_CMD_NUM_LINES = "set errorswithlines num lines";
    private ISQLCommand _lastCmd;

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (!iSQLCommand.getSql().trim().toLowerCase().startsWith(CMD) && !iSQLCommand.getSql().trim().toLowerCase().startsWith(SHOCMD)) {
            this._lastCmd = iSQLCommand;
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSql().trim().toLowerCase().startsWith(VERBOSE_CMD)) {
            String[] stringArray = iSQLCommand.getSQLOrig().split(" ");
            if (stringArray.length >= 3 && stringArray[2].toLowerCase().trim().equals("on")) {
                scriptRunnerContext.putProperty(VERBOSE_CMD, Boolean.TRUE);
            } else {
                scriptRunnerContext.putProperty(VERBOSE_CMD, Boolean.FALSE);
            }
            if (stringArray.length == 5) {
                scriptRunnerContext.putProperty(VERBOSE_CMD_NUM_LINES, Integer.parseInt(stringArray[3]));
            }
        }
        if (iSQLCommand.getSql().trim().toLowerCase().startsWith(CMD) || iSQLCommand.getSql().trim().toLowerCase().startsWith(SHOCMD)) {
            String[] stringArray;
            Object object;
            Object object2;
            String[] stringArray2;
            Object object3;
            if (scriptRunnerContext.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                scriptRunnerContext.write(ScriptRunnerDbArb.getString("NOT_CONNECTED") + "\n");
                return true;
            }
            boolean bl = false;
            boolean bl2 = false;
            String string = iSQLCommand.getSql().trim().replaceAll("^[sS][hH][oO][wW]?\\s+[eE][rR][rR][^\\s]*", "").trim();
            String[] stringArray3 = string.toUpperCase().split("\\s+");
            String string2 = null;
            String string3 = null;
            if (stringArray3.length > 1) {
                object3 = new String[]{"PACKAGE BODY", "TYPE BODY", "JAVA CLASS", "JAVA SOURCE"};
                stringArray2 = new String[]{"FUNCTION", "PROCEDURE", "PACKAGE", "TRIGGER", "VIEW", "TYPE", "DIMENSION"};
                object2 = new String[][]{object3, stringArray2};
                boolean bl3 = false;
                boolean bl4 = false;
                object = object2;
                int n = ((String[][])object).length;
                for (int i = 0; i < n; ++i) {
                    String[] stringArray4;
                    for (CharSequence charSequence2 : stringArray4 = object[i]) {
                        String[] stringArray5 = stringArray3[0];
                        bl4 = false;
                        if (((String)charSequence2).contains(" ")) {
                            stringArray5 = stringArray3[0] + " " + stringArray3[1];
                            bl4 = true;
                        }
                        if (!stringArray5.equals(charSequence2)) continue;
                        bl3 = true;
                        string3 = charSequence2;
                        break;
                    }
                    if (bl3) break;
                }
                if (string3 != null) {
                    if (bl4) {
                        string = string.replaceAll("^[^\\s]*", "").trim();
                    }
                    string2 = string = string.replaceAll("^[^\\s]*", "").trim();
                }
            }
            if ((string3 == null && string.length() > 0) | (string3 != null && (string2 == null || string2.equals("")))) {
                scriptRunnerContext.write("Usage: SHOW ERRORS [{ FUNCTION | PROCEDURE | PACKAGE |\n    PACKAGE BODY | TRIGGER | VIEW\n    | TYPE | TYPE BODY | DIMENSION\n    | JAVA SOURCE | JAVA CLASS } [schema.]name]\n");
                return true;
            }
            if (string2 == null || string3 == null) {
                string2 = (String)scriptRunnerContext.getProperty("sqldev.last.err.name");
                string3 = (String)scriptRunnerContext.getProperty("sqldev.last.err.type");
                if (string2 == null || string3 == null) {
                    scriptRunnerContext.write("No Errors.\n");
                    return true;
                }
                bl = true;
            }
            if (string2.endsWith(".")) {
                scriptRunnerContext.write(MessageFormat.format(Messages.getString("RESOLVE_FAILED"), string2) + "\n");
                return true;
            }
            object3 = DBUtil.getInstance(connection).resolveName(string2, true);
            if (object3 == null) {
                scriptRunnerContext.write("No Errors.\n");
                return true;
            }
            if (string3.toUpperCase().indexOf("BODY") > 0 && ((String)object3.get("OBJECT_TYPE")).toUpperCase().indexOf("BODY") == -1) {
                object3.put("OBJECT_TYPE", (String)object3.get("OBJECT_TYPE") + " BODY");
            } else {
                object3.put("OBJECT_TYPE", ((String)object3.get("OBJECT_TYPE")).toUpperCase());
            }
            stringArray2 = new ArrayList();
            stringArray2.add(object3.get("OBJECT_TYPE"));
            stringArray2.add(object3.get("OBJECT_NAME"));
            stringArray2.add(object3.get("OWNER"));
            object2 = "select substr(line||'/'||position,0,10) linenum ,text from all_errors  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER and    attribute != 'WARNING' order by line, position, sequence";
            ResultSet resultSet = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            object = new ArrayList();
            ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
            try {
                stringArray = DBUtil.getInstance(connection);
                if (connectionResolver.lock(connection)) {
                    resultSet = stringArray.executeQuery((String)object2, (List<?>)stringArray2);
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                        object.add(resultSet.getString(2));
                    }
                }
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.write(sQLException.getMessage());
            }
            finally {
                DBUtil.closeResultSet(resultSet);
                connectionResolver.unlock(connection);
            }
            stringArray = null;
            if (arrayList.size() > 0) {
                int n;
                CharSequence charSequence2;
                arrayList.add(0, Messages.getString("LINE_COL"));
                object.add(0, Messages.getString("ERROR"));
                int n2 = 5;
                int n3 = 10;
                int n4 = 10;
                for (CharSequence charSequence2 : arrayList) {
                    if (((String)charSequence2).length() <= n2) continue;
                    n2 = ((String)charSequence2).length();
                }
                Object object4 = object.iterator();
                while (object4.hasNext()) {
                    charSequence2 = (String)object4.next();
                    if (((String)charSequence2).length() > n3) {
                        n3 = ((String)charSequence2).length();
                    }
                    for (String string4 : ((String)charSequence2).split("\\r?\\n")) {
                        if (string4 == null || string4.length() <= n4) continue;
                        n4 = string4.length();
                    }
                }
                ++n2;
                object4 = "                                       ";
                scriptRunnerContext.write(MessageFormat.format(Messages.getString("ERRORS_FOR_TYPE_NAME") + "\n\n", string3, string2));
                charSequence2 = new StringBuffer("");
                for (n = 1; n < n2 + 5; ++n) {
                    ((StringBuffer)charSequence2).append("-");
                }
                arrayList.add(1, ((StringBuffer)charSequence2).substring(0, n2 - 1) + " ");
                charSequence2 = new StringBuffer("");
                for (n = 1; n < n4 + 5; ++n) {
                    ((StringBuffer)charSequence2).append("-");
                }
                object.add(1, ((StringBuffer)charSequence2).substring(0, n4));
                for (n = 0; n < arrayList.size(); ++n) {
                    scriptRunnerContext.write((String)arrayList.get(n) + ((String)object4).substring(0, n2 - ((String)arrayList.get(n)).length()));
                    int n5 = 1;
                    for (Object object5 : ((String)object.get(n)).split("\\r?\\n", -1)) {
                        if (object5 != null) {
                            object5 = ((String)object5).trim();
                            if (n5 == 0) {
                                scriptRunnerContext.write(((String)object4).substring(0, n2));
                            } else {
                                n5 = 0;
                            }
                            scriptRunnerContext.write((String)object5 + "\n");
                            continue;
                        }
                        if (n5 == 0) continue;
                        scriptRunnerContext.write("\n");
                        n5 = 0;
                    }
                    Boolean bl5 = (Boolean)scriptRunnerContext.getProperty(VERBOSE_CMD);
                    if (bl5 != null && bl5.booleanValue()) {
                        if (bl) {
                            stringArray = this._lastCmd.getSQLOrig().split("\n");
                        } else if (!bl2) {
                            Object object5;
                            bl2 = true;
                            ArrayList arrayList2 = new ArrayList();
                            arrayList2.add(object3.get("OBJECT_TYPE"));
                            arrayList2.add(object3.get("OBJECT_NAME"));
                            arrayList2.add(object3.get("OWNER"));
                            String string5 = "select text from all_source  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER order by line";
                            object5 = new ArrayList();
                            try {
                                DBUtil dBUtil = DBUtil.getInstance(connection);
                                if (connectionResolver.lock(connection)) {
                                    resultSet = dBUtil.executeQuery(string5, arrayList2);
                                    while (resultSet.next()) {
                                        object5.add(resultSet.getString(1));
                                    }
                                    stringArray = object5.toArray(new String[object5.size()]);
                                    if (object5.size() == 0) {
                                        stringArray = null;
                                    }
                                }
                            }
                            catch (SQLException sQLException) {
                            }
                            finally {
                                if (resultSet != null) {
                                    DBUtil.closeResultSet(resultSet);
                                }
                                connectionResolver.unlock(connection);
                            }
                            if (stringArray == null) {
                                scriptRunnerContext.write(MessageFormat.format(Messages.getString("TYPE_NAME_SOURCE_NOT_FOUND"), object3.get("OBJECT_TYPE"), (String)object3.get("OWNER") + "." + (String)object3.get("OBJECT_NAME")));
                            }
                        }
                    }
                    if (bl5 == null || !bl5.booleanValue() || stringArray == null) continue;
                    Integer n6 = 1;
                    if (scriptRunnerContext.getProperty(VERBOSE_CMD_NUM_LINES) != null) {
                        n6 = (Integer)scriptRunnerContext.getProperty(VERBOSE_CMD_NUM_LINES);
                        n6 = n6 - 1;
                    }
                    int n7 = Integer.parseInt(((String)arrayList.get(n)).substring(0, ((String)arrayList.get(n)).indexOf("/")));
                    --n7;
                    int n8 = Integer.parseInt(((String)arrayList.get(n)).substring(((String)arrayList.get(n)).indexOf("/") + 1));
                    for (int i = n6.intValue(); i >= 0; --i) {
                        if (n7 - 1 - i < 0) continue;
                        scriptRunnerContext.write(n7 - i + "  " + stringArray[n7 - 1 - i] + "\n");
                    }
                    if (n7 > 0 && n7 < stringArray.length) {
                        scriptRunnerContext.write(n7 + 1 + "* " + stringArray[n7] + "\n");
                        String string6 = "                                                                                                    ";
                        int n9 = (int)Math.round(Math.floor(n8 / 100));
                        String string7 = new String();
                        string7 = "" + n7 + "  ";
                        scriptRunnerContext.write(string6.substring(0, string7.length()));
                        for (int i = 0; i < n9; ++i) {
                            scriptRunnerContext.write(string6);
                        }
                        scriptRunnerContext.write(string6.substring(0, n8 % 100) + "^\n");
                    }
                    for (int i = 1; i < n6 + 2; ++i) {
                        if (n7 + i >= stringArray.length) continue;
                        scriptRunnerContext.write(n7 + 1 + i + "  " + stringArray[n7 + i] + "\n");
                    }
                    scriptRunnerContext.write("\n\n");
                }
            } else {
                scriptRunnerContext.write(Messages.getString("ShowErrors.34"));
            }
            return true;
        }
        return false;
    }

    public void beginScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

