/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetLDAPCon
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setldapcon")) {
            String[] stringArray = iSQLCommand.getSQLOrig().split(" ");
            if (stringArray.length < 3 || stringArray.length == 3 && stringArray[2].equalsIgnoreCase("default")) {
                scriptRunnerContext.write(Messages.getString("LDAPCONCLEARED"));
                scriptRunnerContext.putProperty("script.runner.ldapcon", null);
                return true;
            }
            scriptRunnerContext.putProperty("script.runner.ldapcon", stringArray[2]);
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = null;
        string = scriptRunnerContext.getProperties().containsKey("script.runner.ldapcon") && scriptRunnerContext.getProperties().get("script.runner.ldapcon") != null ? (String)scriptRunnerContext.getProperties().get("script.runner.ldapcon") : "Default";
        scriptRunnerContext.write("");
        scriptRunnerContext.write(MessageFormat.format(Messages.getString("LDAPCON"), string) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"ldapcon"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

