/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetEscape
extends CommandListener {
    private static final String ESCAPE = "set esc";
    private static final String ESCAPE_ON = "on";
    private static final String ESCAPE_OFF = "off";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim().toLowerCase();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith(ESCAPE) && !string.substring(string.lastIndexOf(" ")).trim().equals(ESCAPE_OFF)) {
            char c;
            String string2 = string.substring(string.lastIndexOf(" ")).trim();
            if (string.replaceFirst("set esc[^\\s]*", "").trim().equals("")) {
                scriptRunnerContext.write(Messages.getString("NO_ESCAPE_VAL"));
                return true;
            }
            if (!string2.equals(ESCAPE_ON)) {
                String string3 = this.validString(string2, scriptRunnerContext);
                if (string3 == null) {
                    return true;
                }
                c = string3.charAt(0);
            } else {
                c = '\\';
            }
            scriptRunnerContext.setSubstitutionOn(true);
            scriptRunnerContext.setEscapeChar(c);
            scriptRunnerContext.setEscape(true);
            return true;
        }
        if (string.startsWith(ESCAPE)) {
            scriptRunnerContext.setSubstitutionOn(true);
            scriptRunnerContext.setSubstitutionChar('&');
            scriptRunnerContext.setEscape(false);
            scriptRunnerContext.setScanOn(true);
            return true;
        }
        return false;
    }

    public String validString(String string, ScriptRunnerContext scriptRunnerContext) {
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            scriptRunnerContext.write(Messages.getString("NO_ESCAPE_VAL"));
            return null;
        }
        if (string2.equals("\"\"\"\"") || string2.equals("'\"'")) {
            return "\"";
        }
        if (string2.equals("''''") || string2.equals("\"'\"")) {
            return "'";
        }
        if ((string2 = this.removeQuotesString(string2)).length() > 1) {
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("ONE_CHARACTER"), string2));
            return null;
        }
        if (string2.equals("") || string2.equals("\"") || string2.equals("'")) {
            scriptRunnerContext.write(Messages.getString("INVALID_ESCAPE"));
            return null;
        }
        if (string2.matches("^\\s") || string2.matches("^\\w") && !string2.startsWith("_") || string2.matches("^\\d")) {
            scriptRunnerContext.write(Messages.getString("NOT_ALHA_OR_WHITE"));
            return null;
        }
        return string2.substring(0, 1);
    }

    public String removeQuotesString(String string) {
        if (string.startsWith("'") && string.endsWith("'") && string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

