/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.query.Bind;

public class SetAutoPrint
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_AUTOPRINT;

    public SetAutoPrint() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        super.beginEvent(connection, scriptRunnerContext, iSQLCommand);
        if (iSQLCommand.getStmtSubType() != null && iSQLCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            Boolean bl = Boolean.FALSE;
            if (this.isCmdOn()) {
                bl = Boolean.TRUE;
            }
            scriptRunnerContext.putProperty("script.runner.context.autoprint", bl);
        }
    }

    @Override
    public void doEndWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        List<String> list = DBUtil.getBinds(iSQLCommand.getSql(), true);
        if (list != null && list.size() > 0) {
            Map<String, Bind> map = scriptRunnerContext.getVarMap();
            for (String string : list) {
                if (!map.containsKey(string = string.toUpperCase())) continue;
                Bind bind = map.get(string);
                String string2 = "";
                if (bind instanceof String) {
                    string2 = (String)((Object)bind);
                } else if (bind instanceof Bind) {
                    string2 = bind.getValue();
                }
                this.printBindValue(scriptRunnerContext, string, string2);
            }
        }
    }

    private void printBindValue(ScriptRunnerContext scriptRunnerContext, String string, String string2) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        string = string.concat("\n");
        try {
            if (string2 == null) {
                ((FilterOutputStream)wrapListenBufferOutputStream).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
                ((FilterOutputStream)wrapListenBufferOutputStream).write(ScriptRunnerContext.stringToByteArrayForScriptRunner("------\n"));
            } else {
                ((FilterOutputStream)wrapListenBufferOutputStream).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string2.length(); ++i) {
                    stringBuffer.append("-");
                }
                stringBuffer.append("\n");
                ((FilterOutputStream)wrapListenBufferOutputStream).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(stringBuffer.toString()));
                string2 = string2.concat("\n");
                ((FilterOutputStream)wrapListenBufferOutputStream).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string2));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }
}

