/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Compute
extends CommandListener {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final List<String> m_cmptFuncSequence = Arrays.asList("AVG", "COUNT", "MINIMUM", "MAXIMUM", "NUMBER", "SUM", "STD", "VARIANCE");
    private static final String COMPUTE = "\\b(?i:comp(?:|u|ut|ute))\\b";
    private static final String FUNCTION = "\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b";
    private static final String LABEL = "\\b(?i:lab(?:|e|el))\\b\\s+(?:([\\p{Alnum}&&['\"]]{1,500})|[\\p{Graph}]{1,166}([\\p{Space}]{1,166})?[\\p{Graph}]{1,166})";
    private static final String OF = "\\b(?i:of)\\b";
    private static final String CMPT_ELEMENT = "((\\s+)?(\\b(?!(?i:report)|(?i:row)|(?i:on)|(?i:of))(.+?)\\b))";
    private static final String FUNC_EXPR = "(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b(\\s+)?(\\b(?i:lab(?:|e|el))\\b\\s+(?:([\\p{Alnum}&&['\"]]{1,500})|[\\p{Graph}]{1,166}([\\p{Space}]{1,166})?[\\p{Graph}]{1,166})(\\s+(\\-(\\s+)?)?)?)?)";
    private static final String CMPT_EXPR = "(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b(\\s+)?(\\b(?i:lab(?:|e|el))\\b\\s+(?:([\\p{Alnum}&&['\"]]{1,500})|[\\p{Graph}]{1,166}([\\p{Space}]{1,166})?[\\p{Graph}]{1,166})(\\s+(\\-(\\s+)?)?)?)?)+(\\s+)?\\b(?i:of)\\b\\s+((\\s+)?(\\b(?!(?i:report)|(?i:row)|(?i:on)|(?i:of))(.+?)\\b))+";
    private static final String ON = "(?i:(?:on|by|across))";
    private static final String REPORT_ELEMENT = "((\\s+)?\\b(?:(?i:report)|(?i:row)|(?!(?i:report)|(?i:row)|(?i:on))[\\p{Graph}]+)\\b)";
    private static final String REPORT_EXPR = "((?i:(?:on|by|across))\\s+((\\s+)?\\b(?:(?i:report)|(?i:row)|(?!(?i:report)|(?i:row)|(?i:on))[\\p{Graph}]+)\\b)+)";
    private static final String CMD = "\\b(?i:comp(?:|u|ut|ute))\\b\\s+(\\b(?i:avg|cou(?:|nt)|min(?:|i|im|imu|imum)|max(?:|i|im|imu|imum)|num(?:|b|be|ber)|sum|std|var(?:|i|ia|ian|ianc|iance))\\b(\\s+)?(\\b(?i:lab(?:|e|el))\\b\\s+(?:([\\p{Alnum}&&['\"]]{1,500})|[\\p{Graph}]{1,166}([\\p{Space}]{1,166})?[\\p{Graph}]{1,166})(\\s+(\\-(\\s+)?)?)?)?)+(\\s+)?\\b(?i:of)\\b\\s+((\\s+)?(\\b(?!(?i:report)|(?i:row)|(?i:on)|(?i:of))(.+?)\\b))+\\s+((?i:(?:on|by|across))\\s+((\\s+)?\\b(?:(?i:report)|(?i:row)|(?!(?i:report)|(?i:row)|(?i:on))[\\p{Graph}]+)\\b)+)";
    TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> m_storedComputecmds = null;
    private static final HashMap<String, String> m_orafunc_to_compfunc = new HashMap();

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim();
        ArrayList arrayList = new ArrayList();
        TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> treeMap = scriptRunnerContext.getStoredComputeCmds();
        this.m_storedComputecmds = treeMap;
        if (string.matches(COMPUTE)) {
            if (treeMap.size() > 0) {
                for (String string2 : treeMap.keySet()) {
                    String string3 = "COMPUTE ";
                    String string4 = " ON " + string2;
                    String string5 = "";
                    ArrayList<TreeMap<String, HashMap<String, String>>> arrayList2 = treeMap.get(string2);
                    for (TreeMap<String, HashMap<String, String>> treeMap2 : arrayList2) {
                        String string6;
                        Iterator<String> iterator = treeMap2.keySet().iterator();
                        while (iterator.hasNext()) {
                            string5 = "";
                            string6 = iterator.next();
                            String string7 = " OF " + string6;
                            HashMap<String, String> hashMap = treeMap2.get(string6);
                            Iterator<String> iterator2 = hashMap.keySet().iterator();
                            while (iterator2.hasNext()) {
                                String string8 = iterator2.next();
                                String string9 = hashMap.get(string8);
                                string5 = string5 + string8 + " LABEL " + string9 + (iterator2.hasNext() ? " " : "");
                                if (iterator2.hasNext()) continue;
                                string5 = string5 + string7;
                            }
                        }
                        string6 = string3 + string5 + string4 + m_lineSeparator;
                        scriptRunnerContext.write(string6);
                    }
                }
            } else {
                scriptRunnerContext.write(Messages.getString("NOCOMPUTES") + m_lineSeparator);
            }
        } else {
            Pattern pattern = Pattern.compile(CMD);
            Matcher matcher = pattern.matcher(string);
            m_orafunc_to_compfunc.put("AVG", "AVG");
            m_orafunc_to_compfunc.put("COUNT", "COUNT");
            m_orafunc_to_compfunc.put("MIN", "MINIMUM");
            m_orafunc_to_compfunc.put("MAX", "MAXIMUM");
            m_orafunc_to_compfunc.put("NUMBER", "NUMBER");
            m_orafunc_to_compfunc.put("SUM", "SUM");
            m_orafunc_to_compfunc.put("STDDEV", "STD");
            m_orafunc_to_compfunc.put("VARIANCE", "VARIANCE");
            boolean bl = matcher.matches();
            if (bl) {
                string = string.replaceFirst("\\b(?i:comp(?:|u|ut|ute))\\b\\s+", "");
                String string10 = string.replaceFirst(CMPT_EXPR, "").trim().replaceFirst(ON, "").trim();
                Pattern pattern2 = Pattern.compile(REPORT_ELEMENT);
                Matcher matcher2 = pattern2.matcher(string10);
                Pattern pattern3 = Pattern.compile(CMPT_ELEMENT);
                String string11 = string.replaceAll(FUNC_EXPR, "").trim().replaceFirst(REPORT_EXPR, "").trim().replaceFirst(OF, "").trim();
                String string12 = string.replaceFirst("\\b(?i:of)\\b\\s+((\\s+)?(\\b(?!(?i:report)|(?i:row)|(?i:on)|(?i:of))(.+?)\\b))+", "").trim().replaceFirst(REPORT_EXPR, "").trim();
                String[] stringArray = string10.split("\\s+");
                String[] stringArray2 = string11.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string13 = stringArray[i];
                    TreeMap<String, HashMap<String, String>> treeMap3 = null;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string14 = stringArray2[j];
                        treeMap3 = this.processFunction(string12, string14);
                        this.storeCompute(string13, string14, treeMap3);
                    }
                }
            } else {
                String string15 = string;
                String[] stringArray = new String[]{COMPUTE, CMPT_EXPR, REPORT_EXPR};
                for (int i = 0; i < stringArray.length; ++i) {
                    Matcher matcher3;
                    Pattern pattern4;
                    Matcher matcher4;
                    Pattern pattern5;
                    Pattern pattern6 = Pattern.compile(stringArray[i]);
                    Matcher matcher5 = pattern6.matcher(string15);
                    if (matcher5.find()) {
                        string15 = string15.replaceAll(stringArray[i], "").trim();
                        continue;
                    }
                    if (stringArray[i].equals(CMPT_EXPR)) {
                        pattern5 = Pattern.compile(FUNC_EXPR);
                        matcher4 = pattern5.matcher(string15);
                        if (!matcher4.find()) {
                            scriptRunnerContext.write(MessageFormat.format(Messages.getString("CMPT_UNK"), string15.split("\\s+")[0]) + m_lineSeparator);
                        } else {
                            string15 = string15.replaceAll(FUNC_EXPR, "").trim();
                            pattern4 = Pattern.compile(OF);
                            matcher3 = pattern4.matcher(string15);
                            if (!matcher3.find()) {
                                if (string15.length() == 0) {
                                    scriptRunnerContext.write(Messages.getString("CMPT_MISSING") + m_lineSeparator);
                                } else {
                                    scriptRunnerContext.write(MessageFormat.format(Messages.getString("CMPT_UNK"), string15.split("\\s+")[0]) + m_lineSeparator);
                                }
                            } else {
                                string15 = string15.replaceAll(OF, "").trim();
                                Pattern pattern7 = Pattern.compile(CMPT_ELEMENT);
                                Matcher matcher6 = pattern7.matcher(string15);
                                if (matcher6.find()) {
                                    string15 = string15.replaceAll(CMPT_ELEMENT, "").trim();
                                    continue;
                                }
                                if (string15.length() == 0) {
                                    scriptRunnerContext.write(Messages.getString("CMPT_ON") + m_lineSeparator);
                                } else {
                                    scriptRunnerContext.write(Messages.getString("CMPT_COLS") + m_lineSeparator);
                                }
                            }
                        }
                    } else {
                        if (!stringArray[i].equals(REPORT_EXPR)) continue;
                        pattern5 = Pattern.compile(ON);
                        matcher4 = pattern5.matcher(string15);
                        if (!matcher4.find()) {
                            scriptRunnerContext.write(Messages.getString("CMPT_ON") + m_lineSeparator);
                        } else {
                            string15 = string15.replaceAll(ON, "").trim();
                            pattern4 = Pattern.compile(REPORT_ELEMENT);
                            matcher3 = pattern4.matcher(string15);
                            if (matcher3.find()) {
                                string15 = string15.replaceAll(REPORT_ELEMENT, "").trim();
                                continue;
                            }
                            scriptRunnerContext.write(Messages.getString("CMPT_COLS") + m_lineSeparator);
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }

    private void storeCompute(String string, String string2, TreeMap<String, HashMap<String, String>> treeMap) {
        ArrayList<TreeMap<String, HashMap<String, String>>> arrayList = this.m_storedComputecmds.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(treeMap);
            this.m_storedComputecmds.put(string, arrayList);
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                TreeMap<String, HashMap<String, String>> treeMap2 = arrayList.get(i);
                if (!treeMap2.containsKey(string2)) continue;
                arrayList.remove(treeMap2);
                break;
            }
            arrayList.add(treeMap);
        }
    }

    private TreeMap<String, HashMap<String, String>> processFunction(String string, String string2) {
        TreeMap<String, HashMap<String, String>> treeMap = new TreeMap<String, HashMap<String, String>>(String.CASE_INSENSITIVE_ORDER);
        HashMap<String, String> hashMap = null;
        String[] stringArray = string.split(FUNC_EXPR);
        Pattern pattern = Pattern.compile(FUNC_EXPR);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group().trim();
            String string4 = string3.replaceFirst("\\b(?i:lab(?:|e|el))\\b\\s+(?:([\\p{Alnum}&&['\"]]{1,500})|[\\p{Graph}]{1,166}([\\p{Space}]{1,166})?[\\p{Graph}]{1,166})(\\s+(\\-(\\s+)?)?)?", "").trim();
            String string5 = string3.replaceFirst(FUNCTION, "");
            String string6 = "";
            if (string4.matches(FUNCTION)) {
                if (string4.matches("\\b(?i:avg)\\b")) {
                    string6 = string4;
                    string4 = "avg";
                }
                if (string4.matches("\\b(?i:cou(?:|nt))\\b")) {
                    string6 = string4;
                    string4 = "count";
                } else if (string4.matches("\\b(?i:min(?:|i|im|imu|imum))\\b")) {
                    string6 = string4;
                    string4 = "min";
                } else if (string4.matches("\\b(?i:max(?:|i|im|imu|imum))\\b")) {
                    string6 = string4;
                    string4 = "max";
                } else if (string4.matches("\\b(?i:num(?:|b|be|ber))\\b")) {
                    string6 = "number";
                    string4 = "number";
                } else if (string4.matches("\\b(?i:sum)\\b")) {
                    string6 = string4;
                    string4 = "sum";
                } else if (string4.matches("\\b(?i:std)\\b")) {
                    string6 = string4;
                    string4 = "stddev";
                } else if (string4.matches("\\b(?i:var(?:|i|ia|ian|ianc|iance))\\b")) {
                    string6 = string4;
                    string4 = "variance";
                }
            }
            if (string5.isEmpty()) {
                string5 = string4.equals("max") ? "'maximum'" : (string4.equals("min") ? "'minimum'" : (string4.equals("stddev") ? "'std'" : (string4.equals("count") ? "'" + string6.toLowerCase() + "'" : "'" + string4.toLowerCase() + "'")));
            } else {
                string5 = string3.replaceFirst(FUNCTION, "").trim().replaceFirst("\\b(?i:lab(?:|e|el))\\b\\s+", "");
                int n = string5.lastIndexOf("-");
                if (n > -1) {
                    string5 = string5.substring(0, n - 1);
                }
                string5 = string5.startsWith("\"") ? string5.substring(1, string5.length()) : string5;
                n = (string5 = string5.endsWith("\"") ? string5.substring(0, string5.length() - 1) : string5).indexOf("'");
                if (n == -1) {
                    string5 = "'" + string5 + "'";
                }
            }
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            hashMap.put(string4, string5);
        }
        treeMap.put(string2, hashMap);
        return treeMap;
    }

    public static void sort(ArrayList<TreeMap<String, HashMap<String, String>>> arrayList) {
        Collections.sort(arrayList, new Comparator<TreeMap<String, HashMap<String, String>>>(){

            @Override
            public int compare(TreeMap<String, HashMap<String, String>> treeMap, TreeMap<String, HashMap<String, String>> treeMap2) {
                HashMap<String, String> hashMap = treeMap.get(treeMap.keySet().toArray()[0]);
                String string = (String)m_orafunc_to_compfunc.get(((String)hashMap.keySet().toArray()[0]).toUpperCase());
                HashMap<String, String> hashMap2 = treeMap2.get(treeMap2.keySet().toArray()[0]);
                String string2 = (String)m_orafunc_to_compfunc.get(((String)hashMap2.keySet().toArray()[0]).toUpperCase());
                return Integer.valueOf(m_cmptFuncSequence.indexOf(string)).compareTo(m_cmptFuncSequence.indexOf(string2));
            }
        });
    }

    public static void sortFunctions(ArrayList<TreeMap<String, HashMap<String, String>>> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            TreeMap<String, HashMap<String, String>> treeMap = arrayList.get(i);
            for (String string : treeMap.keySet()) {
                HashMap<String, String> hashMap = treeMap.get(string);
                HashMap<String, String> hashMap2 = Compute.sort(hashMap);
                treeMap.put(string, hashMap2);
            }
        }
    }

    public static HashMap<String, String> sort(HashMap<String, String> hashMap) {
        LinkedList<Map.Entry<String, String>> linkedList = new LinkedList<Map.Entry<String, String>>(hashMap.entrySet());
        Collections.sort(linkedList, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                String string = (String)m_orafunc_to_compfunc.get(((Map.Entry)object).getKey().toString().toUpperCase());
                String string2 = (String)m_orafunc_to_compfunc.get(((Map.Entry)object2).getKey().toString().toUpperCase());
                int n = m_cmptFuncSequence.indexOf(string);
                int n2 = m_cmptFuncSequence.indexOf(string2);
                return Integer.valueOf(n).compareTo(n2);
            }
        });
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return linkedHashMap;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

