/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class BridgeTableDef {
    public static final String BRIDGEREPLACEKEY = "BRIDGEREPLACEKEY";
    String _tableName = null;
    String _targetTableName = null;
    String _targetConnName = null;
    String _query = null;
    ArrayList<String> _queries = new ArrayList();
    String _sourceConnName = null;
    Connection _targetConn = null;
    Connection _sourceConn = null;
    Connection _defaultConn = null;
    String _error = "";
    String _report = "";
    boolean _isAppend = false;
    boolean _isReplace = false;
    boolean _ZeroLengthStringToSpace = false;
    ScriptRunnerContext m_ctx = null;
    boolean _db12cFeatures = false;
    int _BulkInsertNum = 0;

    public BridgeTableDef(String string, Connection connection, String string2, Connection connection2, boolean bl, boolean bl2) {
        this._tableName = string;
        this._query = this.substitute(string2);
        this._isAppend = bl;
        this._isReplace = bl2;
        this.setConfigZeroLengthStringToSpace();
        this._targetConn = connection;
        this._sourceConn = connection2;
    }

    private String substitute(String string) {
        return string;
    }

    public Connection getTargetConnection() {
        return this._targetConn;
    }

    public Connection getSourceConnection() {
        return this._sourceConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDynamicSQL() throws SQLException {
        int n = this.getQuerySQL().indexOf("({");
        int n2 = this.getQuerySQL().indexOf("}");
        if (n != -1) {
            String string = this.getQuerySQL().substring(n + 2, n2);
            ResultSet resultSet = null;
            DBUtil dBUtil = null;
            try {
                dBUtil = DBUtil.getInstance(this.getTargetConnection());
                DBUtil.getConnectionResolver().lock(this.getTargetConnection());
                resultSet = dBUtil.executeOracleQuery(string, null);
                int n3 = resultSet.getMetaData().getColumnType(1);
                StringBuffer stringBuffer = new StringBuffer();
                while (resultSet.next()) {
                    if (n3 == 12 || n3 == 1) {
                        stringBuffer.append("'" + resultSet.getString(1) + "',");
                        continue;
                    }
                    stringBuffer.append(resultSet.getString(1) + ",");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                String string2 = "{" + string + "}";
                int n4 = this.getQuerySQL().indexOf(string2);
                int n5 = n4 + string2.length();
                StringBuffer stringBuffer2 = new StringBuffer(this.getQuerySQL());
                stringBuffer2.delete(n4, n5);
                stringBuffer2.insert(n4, stringBuffer.toString());
                this.setQuerySQL(stringBuffer2.toString());
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                DBUtil.getConnectionResolver().unlock(this.getTargetConnection());
                throw throwable;
            }
            DBUtil.closeResultSet(resultSet);
            DBUtil.getConnectionResolver().unlock(this.getTargetConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() {
        if (this._error != null && !this._error.equals("")) {
            return false;
        }
        if (this._targetConn == null) {
            this._targetConn = this.getDefaultConn();
        }
        if (this._sourceConn == null) {
            this._sourceConn = this.getDefaultConn();
        }
        ResultSet resultSet = null;
        DBUtil dBUtil = null;
        try {
            if (DBUtil.getConnectionResolver().lock(this._targetConn)) {
                try {
                    if (!this._targetConn.getAutoCommit()) {
                        this._targetConn.commit();
                    }
                }
                catch (SQLException sQLException) {
                    this._error = this._error + MessageFormat.format(Messages.getString("BRIDGE_ERROR"), this._tableName, sQLException.getLocalizedMessage());
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("BRIDGE_ERROR_FOR_LOG"), sQLException);
                    boolean bl = false;
                    DBUtil.closeResultSet(resultSet);
                    if (this._sourceConn == null) return bl;
                    dBUtil.getConnectionResolver().unlock(this._sourceConn);
                    return bl;
                }
                finally {
                    DBUtil.getConnectionResolver().unlock(this._targetConn);
                }
            }
            this.processDynamicSQL();
            boolean bl = this.processLoopSQL();
            dBUtil = DBUtil.getInstance(this._sourceConn);
            DBUtil.getConnectionResolver().lock(this._sourceConn);
            boolean bl2 = this.isOracle(this._sourceConn);
            Iterator<String> iterator = this.getQueries().iterator();
            while (iterator.hasNext()) {
                ArrayList<String> arrayList;
                ArrayList<String> arrayList2;
                boolean bl3;
                block37: {
                    String string = iterator.next();
                    if (this.isInterupted()) {
                        bl3 = false;
                        return bl3;
                    }
                    resultSet = this.querySource(dBUtil, string);
                    if (resultSet == null) {
                        if (bl) continue;
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("BRIDGE_ERROR_FOR_LOG"));
                        bl3 = false;
                        DBUtil.closeResultSet(resultSet);
                        if (this._sourceConn == null) return bl3;
                        dBUtil.getConnectionResolver().unlock(this._sourceConn);
                        return bl3;
                    }
                    bl3 = false;
                    arrayList2 = new ArrayList();
                    arrayList = new ArrayList();
                    arrayList2 = this.createTableString(resultSet.getMetaData(), bl2);
                    try {
                        this.createTableAction(arrayList2);
                        bl3 = true;
                    }
                    catch (SQLException sQLException) {
                        if (this._isAppend) break block37;
                        throw sQLException;
                    }
                }
                if (bl3) {
                    arrayList = this.autoColumnsCalculate(arrayList2, resultSet);
                }
                this.insertData(arrayList2, resultSet);
                if (!this.isTempTable() && DBUtil.getConnectionResolver().lock(this._targetConn)) {
                    try {
                        this._targetConn.commit();
                    }
                    finally {
                        DBUtil.getConnectionResolver().unlock(this._targetConn);
                    }
                }
                resultSet.close();
                if (bl3) {
                    this.addAutonumber(arrayList2, arrayList);
                }
                this._report = this._report + MessageFormat.format(Messages.getString("BRIDGE_INSERT_SUCCESS"), this._tableName);
            }
            return true;
        }
        catch (Exception exception) {
            this._error = this._error + MessageFormat.format(Messages.getString("BRIDGE_ERROR"), this._tableName, exception.getLocalizedMessage());
            if (DBUtil.getConnectionResolver().lock(this._targetConn)) {
                try {
                    this._targetConn.rollback();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("BRIDGE_ERROR_FOR_LOG"), sQLException);
                }
                finally {
                    DBUtil.getConnectionResolver().unlock(this._targetConn);
                }
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("BRIDGE_ERROR_FOR_LOG"), exception);
            boolean bl = false;
            DBUtil.closeResultSet(resultSet);
            if (this._sourceConn == null) return bl;
            dBUtil.getConnectionResolver().unlock(this._sourceConn);
            return bl;
        }
        finally {
            DBUtil.closeResultSet(resultSet);
            if (this._sourceConn != null) {
                dBUtil.getConnectionResolver().unlock(this._sourceConn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> autoColumnsCalculate(ArrayList<String> arrayList, ResultSet resultSet) {
        Object var3_3 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (DBUtil.getConnectionResolver().lock(this._sourceConn)) {
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    if (!arrayList.get(i).startsWith("NUMBER") || !resultSetMetaData.isAutoIncrement(i + 1)) continue;
                    arrayList2.add(this.createValidIdentifier(resultSetMetaData.getColumnName(i + 1), "part"));
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("BRIDGE_ERROR_FOR_LOG"), sQLException);
            }
            finally {
                DBUtil.getConnectionResolver().unlock(this._sourceConn);
            }
        }
        return arrayList2;
    }

    private String createValidIdentifier(String string, String string2) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAutonumber(ArrayList<String> arrayList, ArrayList<String> arrayList2) throws SQLException {
        String string = this.getTargetTableName();
        if (DBUtil.getConnectionResolver().lock(this._targetConn)) {
            CallableStatement callableStatement = null;
            try {
                if (!this.isOracle(this._targetConn)) {
                    return;
                }
                for (String string2 : arrayList2) {
                    try {
                        callableStatement = this._targetConn.prepareCall("Declare \n  pragma autonomous_transaction; \n  e_already_exists EXCEPTION; \n  PRAGMA EXCEPTION_INIT (e_already_exists, -955); \n  e_trig_already_exists EXCEPTION; \n  PRAGMA EXCEPTION_INIT (e_trig_already_exists, -4081); \n  tablel varchar2(100):= :b1; \n  columnl varchar2(100) := :b2; \n  eimmediate varchar2(4000 byte) := NULL; \n  postfix varchar2(100) := NULL; \n  seqname varchar2(200) := NULL; \n  trigname varchar2(200) := NULL; \n  seqcreated boolean := false; \n  trigcreated boolean := false; \n  outputl varchar2(200) := 'OK'; \n  FUNCTION truncateStringByteSize(p_work VARCHAR2, p_bsize NUMBER) RETURN VARCHAR2 \n  IS \n    v_work VARCHAR2(4000); \n    v_bsize NUMBER(10); \n  BEGIN \n    IF LENGTHB(p_work) <= p_bsize THEN \n      return p_work; \n    END IF; \n    v_work := p_work; \n    v_work := SUBSTRB(v_work, 1, p_bsize); \n    WHILE INSTRC(p_work, v_work , 1, 1) <> 1 LOOP -- a character has been cut in half or in 2/3 or 3/4 by substrb (multibyte can have up to 4 bytes)  \n    --note each left over corrupt byte can be a single character \n      BEGIN \n        v_bsize := LENGTHB(v_work); \n        v_work := SUBSTRB(v_work, 1, v_bsize-1); \n      END; \n    END LOOP;  \n    return v_work; \n  END; \n  FUNCTION get_name(p_work VARCHAR2, p_suffix VARCHAR2) RETURN VARCHAR2 \n  IS \n    p_maxlen NUMBER(38,0) := 30; \n    v_suflen NUMBER := LENGTHB(p_suffix); \n    v_truncamount NUMBER; \n  BEGIN \n    IF LENGTHB(p_work) < p_maxlen - v_suflen THEN \n      RETURN p_work || p_suffix; \n    END IF; \n    v_truncamount := LENGTHB(p_work) + v_suflen - p_maxlen; \n    RETURN truncateStringByteSize(p_work, LENGTHB(p_work)-v_truncamount) || p_suffix; \n  END get_name; \nbegin \n  for n in 0 .. 100 \n  loop \n    begin \n      if (n=0)  \n      then \n        postfix:='_'||'SEQ'; \n      else \n        postfix:='_'||n||'SEQ'; \n      end if; \n      seqname:=get_name(tablel || '_' || columnl ,postfix); \n      eimmediate := 'CREATE SEQUENCE  ' || seqname || chr(10) ||  \n      '  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1  NOCYCLE'; \n      -- thesequencewithseqnamein; \n      execute immediate eimmediate; \n      seqcreated := true; \n      --just skip already exists 3exception  \n    Exception  \n      when  e_already_exists then \n      null; \n    end; \n    if (seqcreated = true)  \n    then \n      for t in 0 .. 100 \n        loop \n        begin \n        if (t=0)  \n        then \n          postfix:='_'||'TRIG'; \n        else \n          postfix:='_'||t||'TRIG'; \n        end if; \n        trigname:=get_name(tablel||'_'||columnl,postfix); \n        --execute immediate  \n        eimmediate := \n'CREATE TRIGGER '||trigname||' BEFORE INSERT OR UPDATE ON ' || tablel || chr(10) || \n'FOR EACH ROW' || chr(10) || \n'DECLARE ' || chr(10) || \n'v_newVal NUMBER(12) := 0;' || chr(10) || \n'v_incval NUMBER(12) := 0;' || chr(10) || \n'BEGIN' || chr(10) || \n'  IF INSERTING AND :new.'|| columnl ||' IS NULL THEN' || chr(10) || \n'    SELECT  '||seqname||'.NEXTVAL INTO v_newVal FROM DUAL;' || chr(10) || \n'    -- If this is the first time this table have been inserted into (sequence == 1)' || chr(10) || \n'    IF v_newVal = 1 THEN ' || chr(10) || \n'      --get the max indentity value from the table' || chr(10) || \n'      SELECT NVL(max('||columnl||'),0) INTO v_newVal FROM '||tablel||';' || chr(10) || \n'      v_newVal := v_newVal + 1;' || chr(10) || \n'      --set the sequence to that value' || chr(10) || \n'      LOOP' || chr(10) || \n'           EXIT WHEN v_incval>=v_newVal;' || chr(10) || \n'           SELECT '||seqname||'.nextval INTO v_incval FROM dual;' || chr(10) || \n'      END LOOP;' || chr(10) || \n'    END IF;' || chr(10) || \n'   -- assign the value from the sequence to emulate the identity column' || chr(10) || \n'   :new.'||columnl||' := v_newVal;' || chr(10) || \n'  END IF;' || chr(10) || \n'END;'; \n        execute immediate eimmediate; \n        trigcreated := true; \n        exit; \n        --just skip already exists 3exception  \n        Exception  \n          when  e_already_exists then \n          null; \n          when e_trig_already_exists then \n            null; \n        end; \n      END LOOP;   \n      exit; \n    end if; \n  end loop; \n  if (seqcreated = false) \n  then  \n    outputl:= 'create sequence '||seqname||' failed:'; \n  end if; \n  if (trigcreated = false) \n  then \n    if (outputl = 'OK') \n    then \n      outputl := null; \n    end if; \n    outputl:= outputl || 'create trigger '||trigname||' failed'; \n  end if; \n  :op := outputl; \nend; ");
                        callableStatement.setString(1, string);
                        callableStatement.setString(2, string2);
                        callableStatement.registerOutParameter(3, 12);
                        callableStatement.executeUpdate();
                        String string3 = callableStatement.getString(3);
                        if (string3 != null && string3.equals("OK")) continue;
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string3 == null ? "null" : string3);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("BRIDGE_ERROR_FOR_LOG"), sQLException);
                    }
                    finally {
                        if (callableStatement == null) continue;
                        try {
                            callableStatement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            finally {
                DBUtil.getConnectionResolver().unlock(this._targetConn);
            }
        }
    }

    private boolean isOracle(Connection connection) {
        try {
            return connection != null && connection.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") != -1;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processLoopSQL() throws SQLException {
        boolean bl;
        block4: {
            String string;
            block3: {
                bl = false;
                string = this.getQuerySQL();
                int n = this.getQuerySQL().toLowerCase().indexOf("{");
                int n2 = this.getQuerySQL().indexOf("}");
                if (n == -1) break block3;
                bl = true;
                String string2 = this.getQuerySQL().substring(n + 1, n2);
                ResultSet resultSet = null;
                DBUtil dBUtil = null;
                try {
                    dBUtil = DBUtil.getInstance(this.getTargetConnection());
                    DBUtil.getConnectionResolver().lock(this.getTargetConnection());
                    resultSet = dBUtil.executeOracleQuery(string2, null);
                    int n3 = resultSet.getMetaData().getColumnType(1);
                    StringBuffer stringBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        if (n3 != 12) continue;
                        String string3 = "{" + string2 + "}";
                        int n4 = this.getQuerySQL().indexOf(string3);
                        int n5 = n4 + string3.length();
                        StringBuffer stringBuffer2 = new StringBuffer(this.getQuerySQL());
                        stringBuffer2.delete(n4, n5);
                        stringBuffer2.insert(n4, resultSet.getString(1));
                        String string4 = stringBuffer2.toString();
                        string4 = this.processBinds(resultSet, string4);
                        this._queries.add(string4);
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    DBUtil.getConnectionResolver().unlock(this.getTargetConnection());
                    throw throwable;
                }
                DBUtil.closeResultSet(resultSet);
                DBUtil.getConnectionResolver().unlock(this.getTargetConnection());
                break block4;
            }
            this._queries.add(string);
        }
        return bl;
    }

    private String processBinds(ResultSet resultSet, String string) {
        try {
            int n = resultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string2 = resultSet.getMetaData().getColumnLabel(i);
                if (!string2.toLowerCase().startsWith("sqldev")) continue;
                string = BridgeTableDef.replace(string, ":" + string2, resultSet.getString(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        if (string2.equals("")) {
            throw new IllegalArgumentException("Old pattern must have content.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private ArrayList<String> getQueries() {
        return this._queries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertData(ArrayList<String> arrayList, ResultSet resultSet) throws SQLException {
        int n = 2048;
        boolean bl = false;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String string = this.getInsertSQL(resultSetMetaData);
        boolean bl2 = false;
        if (DBUtil.getConnectionResolver().lock(this._targetConn)) {
            CallableStatement callableStatement = null;
            try {
                callableStatement = this._targetConn.prepareCall(string);
                if (callableStatement instanceof OraclePreparedStatement) {
                    bl = this._targetConn.getAutoCommit();
                    this._targetConn.setAutoCommit(false);
                    ((OraclePreparedStatement)callableStatement).setExecuteBatch(this._BulkInsertNum);
                }
                while (resultSet.next()) {
                    ArrayList<Blob> arrayList2 = new ArrayList<Blob>();
                    ArrayList<Clob> arrayList3 = new ArrayList<Clob>();
                    ArrayList<Object> arrayList4 = this.getNextBinds(resultSet, arrayList, arrayList2, arrayList3, n);
                    DBUtil.bind((PreparedStatement)callableStatement, arrayList4);
                    callableStatement.execute();
                    for (Blob blob : arrayList2) {
                        try {
                            ((BLOB)blob).freeTemporary();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    for (Clob clob : arrayList3) {
                        try {
                            ((CLOB)clob).freeTemporary();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                }
            }
            finally {
                if (callableStatement instanceof OraclePreparedStatement) {
                    try {
                        ((OraclePreparedStatement)callableStatement).sendBatch();
                        this._targetConn.commit();
                    }
                    finally {
                        this._targetConn.setAutoCommit(bl);
                    }
                }
                DBUtil.getConnectionResolver().unlock(this._targetConn);
                if (callableStatement != null) {
                    try {
                        callableStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private String getInsertSQL(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n];
        String[] stringArray = new String[n + 1];
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO " + this.getTargetTableName() + " VALUES (");
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append(":bindname" + i + ",");
            nArray[i - 1] = resultSetMetaData.getColumnType(i);
            stringArray[i - 1] = resultSetMetaData.getColumnTypeName(i);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private ArrayList<Object> getNextBinds(ResultSet resultSet, ArrayList<String> arrayList, ArrayList<Blob> arrayList2, ArrayList<Clob> arrayList3, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2 + 1];
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            Object object = resultSet.getObject(i);
            if (object == null) {
                arrayList4.add(object);
                continue;
            }
            if (this.isOracle(this._targetConn)) {
                int n3;
                Object[] objectArray;
                Closeable closeable;
                Closeable closeable2;
                Closeable closeable3;
                NUMBER nUMBER;
                if (object instanceof BigInteger) {
                    nUMBER = new NUMBER((BigInteger)object);
                    arrayList4.add(nUMBER);
                    continue;
                }
                if ((nArray[i - 1] == -4 || arrayList.get(i - 1).startsWith("BLOB")) && object instanceof byte[]) {
                    nUMBER = null;
                    closeable3 = null;
                    closeable2 = null;
                    try {
                        nUMBER = BLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
                        arrayList2.add((Blob)nUMBER);
                        ((BLOB)nUMBER).open(1);
                        byte[] byArray = (byte[])object;
                        closeable2 = nUMBER.setBinaryStream(1L);
                        closeable3 = new BufferedOutputStream((OutputStream)closeable2);
                        ((BufferedOutputStream)closeable3).write(byArray, 0, byArray.length);
                        ((BufferedOutputStream)closeable3).flush();
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException);
                    }
                    finally {
                        if (closeable2 != null) {
                            try {
                                ((OutputStream)closeable2).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable3 != null) {
                            try {
                                ((FilterOutputStream)closeable3).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    arrayList4.add(nUMBER);
                    continue;
                }
                if (object instanceof Blob) {
                    nUMBER = null;
                    closeable3 = null;
                    closeable2 = null;
                    InputStream inputStream = null;
                    closeable = null;
                    try {
                        nUMBER = BLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
                        arrayList2.add((Blob)nUMBER);
                        ((BLOB)nUMBER).open(1);
                        inputStream = ((Blob)object).getBinaryStream();
                        closeable3 = new BufferedInputStream(inputStream);
                        objectArray = new byte[n];
                        closeable = nUMBER.setBinaryStream(1L);
                        n3 = 0;
                        closeable2 = new BufferedOutputStream((OutputStream)closeable);
                        while ((n3 = ((BufferedInputStream)closeable3).read((byte[])objectArray, 0, objectArray.length)) != -1) {
                            ((BufferedOutputStream)closeable2).write((byte[])objectArray, 0, n3);
                        }
                        ((BufferedOutputStream)closeable2).flush();
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable != null) {
                            try {
                                ((OutputStream)closeable).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable3 != null) {
                            try {
                                ((BufferedInputStream)closeable3).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable2 != null) {
                            try {
                                ((FilterOutputStream)closeable2).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    arrayList4.add(nUMBER);
                    continue;
                }
                if ((nArray[i - 1] == -1 || arrayList.get(i - 1).startsWith("CLOB")) && object instanceof String) {
                    nUMBER = null;
                    closeable3 = null;
                    closeable2 = null;
                    try {
                        nUMBER = CLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
                        arrayList3.add((Clob)nUMBER);
                        ((CLOB)nUMBER).open(1);
                        closeable2 = nUMBER.setCharacterStream(1L);
                        boolean bl = false;
                        closeable3 = new BufferedWriter((Writer)closeable2);
                        ((Writer)closeable3).write((String)object);
                        ((BufferedWriter)closeable3).flush();
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException);
                    }
                    finally {
                        if (closeable2 != null) {
                            try {
                                ((Writer)closeable2).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable3 != null) {
                            try {
                                ((BufferedWriter)closeable3).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    arrayList4.add(nUMBER);
                    continue;
                }
                if (object instanceof Clob) {
                    nUMBER = null;
                    closeable3 = null;
                    closeable2 = null;
                    Reader reader = null;
                    closeable = null;
                    try {
                        nUMBER = CLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
                        arrayList3.add((Clob)nUMBER);
                        ((CLOB)nUMBER).open(1);
                        reader = ((Clob)object).getCharacterStream();
                        closeable3 = new BufferedReader(reader);
                        objectArray = new char[n];
                        closeable = nUMBER.setCharacterStream(1L);
                        n3 = 0;
                        closeable2 = new BufferedWriter((Writer)closeable);
                        while ((n3 = ((BufferedReader)closeable3).read((char[])objectArray, 0, objectArray.length)) != -1) {
                            ((BufferedWriter)closeable2).write((char[])objectArray, 0, n3);
                        }
                        ((BufferedWriter)closeable2).flush();
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable != null) {
                            try {
                                ((Writer)closeable).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable3 != null) {
                            try {
                                ((BufferedReader)closeable3).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable2 != null) {
                            try {
                                ((BufferedWriter)closeable2).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    arrayList4.add(nUMBER);
                    continue;
                }
                if (nArray[i - 1] == -9) {
                    arrayList4.add(this.maybeSpace(object.toString()));
                    continue;
                }
                if (nArray[i - 1] == -15) {
                    arrayList4.add(this.maybeSpace(this.rtrim(object.toString())));
                    continue;
                }
                if (nArray[i - 1] == 1) {
                    arrayList4.add(this.maybeSpace(this.rtrim(object.toString())));
                    continue;
                }
                if (nArray[i - 1] == 12) {
                    arrayList4.add(this.maybeSpace(object.toString()));
                    continue;
                }
                arrayList4.add(object);
                continue;
            }
            arrayList4.add(object);
        }
        return arrayList4;
    }

    private void setConfigZeroLengthStringToSpace() {
    }

    private String maybeSpace(String string) {
        if (!this._ZeroLengthStringToSpace) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.equals("")) {
            return " ";
        }
        return string;
    }

    private String rtrim(String string) {
        String string2 = null;
        if (string == null || string.equals("")) {
            string2 = string;
        } else {
            boolean bl = false;
            int n = 0;
            for (n = string.length() - 1; n > 0 && string.charAt(n) == ' '; --n) {
            }
            string2 = string.substring(0, n + 1);
        }
        return string2;
    }

    private String getTableName() {
        return this._tableName;
    }

    private ArrayList<String> createTableString(ResultSetMetaData resultSetMetaData, boolean bl) throws SQLException {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isTempTable()) {
            string2 = "CREATE GLOBAL TEMPORARY TABLE ";
            string = " on commit delete rows ";
        } else {
            string2 = "CREATE TABLE ";
            string = " ";
        }
        StringBuffer stringBuffer = new StringBuffer(string2 + this.getTargetTableName() + "(");
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n;
            int n2;
            String string3 = resultSetMetaData.getColumnName(i);
            string3 = this.createValidIdentifier(string3, "part");
            int n3 = resultSetMetaData.getColumnType(i);
            int n4 = resultSetMetaData.getPrecision(i);
            if (n4 > (n2 = (n = resultSetMetaData.getColumnDisplaySize(i)))) {
                n2 = n4;
            }
            String string4 = this.JDBCToOracle(bl, n2, n3);
            arrayList.add(string4.toUpperCase());
            String string5 = " NULL ";
            if (resultSetMetaData.isNullable(i) == 0) {
                string5 = " NOT NULL ";
            }
            stringBuffer.append(string3 + " " + string4 + string5 + ",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(")");
        stringBuffer.append(string);
        String string6 = stringBuffer.toString();
        arrayList.add(string6);
        return arrayList;
    }

    private void createTableAction(ArrayList<String> arrayList) throws SQLException {
        Object object;
        String string = arrayList.get(arrayList.size() - 1);
        if (this._isReplace) {
            object = "DROP TABLE " + this.getTargetTableName();
            DBUtil.getConnectionResolver().lock(this.getTargetConnection());
            try {
                DBUtil.getInstance(this._targetConn).execute((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DBUtil.getConnectionResolver().unlock(this.getTargetConnection());
        }
        DBUtil.getConnectionResolver().lock(this.getTargetConnection());
        object = DBUtil.getInstance(this._targetConn).getLastException();
        DBUtil.getInstance(this._targetConn).execute(string);
        object = DBUtil.getInstance(this._targetConn).getLastException();
        DBUtil.getConnectionResolver().unlock(this.getTargetConnection());
        if (object != null) {
            throw object;
        }
    }

    private String getTargetTableName() {
        if (this._targetTableName == null) {
            this._targetTableName = this.createValidIdentifier(this.getTableName(), "object");
        }
        if (this._targetTableName != null && this._targetTableName.startsWith("#")) {
            return this._targetTableName.substring(1);
        }
        return this._targetTableName;
    }

    private boolean isTempTable() {
        this.getTargetTableName();
        return this._targetTableName != null && this._targetTableName.startsWith("#");
    }

    private ResultSet querySource(DBUtil dBUtil, String string) {
        ResultSet resultSet = null;
        resultSet = dBUtil.executeQuery(string, new HashMap());
        return resultSet;
    }

    private String getQuerySQL() {
        return this._query;
    }

    private void setQuerySQL(String string) {
        this._query = string;
    }

    private Connection getDefaultConn() {
        return this._defaultConn;
    }

    public void setDefaultConn(Connection connection) {
        this._defaultConn = connection;
    }

    public String JDBCToOracle(boolean bl, int n, int n2) {
        String string = "OTHER";
        switch (n2) {
            case -7: {
                string = "NUMBER(10)";
                break;
            }
            case -6: {
                string = "NUMBER(10)";
                break;
            }
            case 5: {
                string = "NUMBER(10)";
                break;
            }
            case 4: {
                string = "NUMBER(10)";
                break;
            }
            case -5: {
                string = "NUMBER(38)";
                break;
            }
            case 6: {
                string = "NUMBER";
                break;
            }
            case 7: {
                string = "NUMBER";
                break;
            }
            case 8: {
                string = "NUMBER";
                break;
            }
            case 2: {
                string = "NUMBER(38,2)";
                break;
            }
            case 3: {
                string = "NUMBER(38,2)";
                break;
            }
            case -15: 
            case 1: {
                if (this.getDb12cFeatures()) {
                    if (bl) {
                        if (n == 0) {
                            string = "CHAR(32767 BYTE)";
                            break;
                        }
                        if (n <= Short.MAX_VALUE) {
                            string = "CHAR(" + n + " BYTE)";
                            break;
                        }
                        string = "CLOB";
                        break;
                    }
                    if (n == 0) {
                        string = "CHAR(200 CHAR)";
                        break;
                    }
                    if (n <= 8191) {
                        string = "CHAR(" + n + " CHAR)";
                        break;
                    }
                    string = "CLOB";
                    break;
                }
                if (bl) {
                    if (n == 0) {
                        string = "CHAR(2000 BYTE)";
                        break;
                    }
                    if (n <= 2000) {
                        string = "CHAR(" + n + " BYTE)";
                        break;
                    }
                    string = "CLOB";
                    break;
                }
                if (n == 0) {
                    string = "CHAR(200 CHAR)";
                    break;
                }
                if (n <= 500) {
                    string = "CHAR(" + n + " CHAR)";
                    break;
                }
                string = "CLOB";
                break;
            }
            case -9: 
            case 12: {
                if (bl) {
                    if (n == 0) {
                        if (this.getDb12cFeatures()) {
                            string = "VARCHAR2(32767 BYTE)";
                            break;
                        }
                        string = "VARCHAR2(4000 BYTE)";
                        break;
                    }
                    if (n <= Short.MAX_VALUE && this.getDb12cFeatures()) {
                        string = "VARCHAR2(" + n + " BYTE)";
                        break;
                    }
                    if (n <= 4000) {
                        string = "VARCHAR2(" + n + " BYTE)";
                        break;
                    }
                    string = "CLOB";
                    break;
                }
                if (!this.getDb12cFeatures()) {
                    if (n == 0) {
                        string = "VARCHAR2(4000 BYTE)";
                        break;
                    }
                    if (n <= 1000) {
                        string = "VARCHAR2(" + n + "CHAR)";
                        break;
                    }
                    string = "CLOB";
                    break;
                }
                if (n == 0) {
                    string = "VARCHAR2(32767 BYTE)";
                    break;
                }
                if (n <= 8191) {
                    string = "VARCHAR2(" + n + "CHAR)";
                    break;
                }
                string = "CLOB";
                break;
            }
            case -1: {
                string = "CLOB";
                break;
            }
            case 91: {
                string = "DATE";
                break;
            }
            case 92: {
                string = "DATE";
                break;
            }
            case 93: {
                string = "DATE";
                break;
            }
            case -2: {
                if (this.getDb12cFeatures()) {
                    if (n == 0) {
                        string = "RAW(32767)";
                        break;
                    }
                    if (n <= Short.MAX_VALUE) {
                        string = "RAW(" + n + ")";
                        break;
                    }
                    if (n > Short.MAX_VALUE) {
                        string = "BLOB";
                        break;
                    }
                    string = "RAW(32767)";
                    break;
                }
                if (n == 0) {
                    string = "RAW(2000)";
                    break;
                }
                if (n <= 2000) {
                    string = "RAW(" + n + ")";
                    break;
                }
                if (n > 2000) {
                    string = "BLOB";
                    break;
                }
                string = "RAW(2000)";
                break;
            }
            case -3: {
                if (this.getDb12cFeatures()) {
                    if (n == 0) {
                        string = "RAW(32767)";
                        break;
                    }
                    if (n <= Short.MAX_VALUE) {
                        string = "RAW(" + n + ")";
                        break;
                    }
                    if (n > Short.MAX_VALUE) {
                        string = "BLOB";
                        break;
                    }
                    string = "RAW(32767)";
                    break;
                }
                if (n == 0) {
                    string = "RAW(2000)";
                    break;
                }
                if (n <= 2000) {
                    string = "RAW(" + n + ")";
                    break;
                }
                if (n > 2000) {
                    string = "BLOB";
                    break;
                }
                string = "RAW(2000)";
                break;
            }
            case 2004: {
                string = "BLOB";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            case 16: {
                string = "NUMBER(10)";
                break;
            }
            case -4: {
                string = "BLOB";
                break;
            }
            case 2011: {
                string = "CLOB";
                break;
            }
            case 1111: {
                if (this.getDb12cFeatures()) {
                    string = "VARCHAR2(32767)";
                    break;
                }
                string = "VARCHAR2(4000)";
                break;
            }
            default: {
                string = this.getDb12cFeatures() ? "VARCHAR2(32767)" : "VARCHAR2(4000)";
            }
        }
        return string;
    }

    public void drop() {
        DBUtil.getInstance(this._targetConn).execute("DROP TABLE " + this.getTargetTableName());
    }

    public String getError() {
        return this._error;
    }

    public String getReport() {
        return this._report;
    }

    public void setDb12cFeatures(boolean bl) {
        this._db12cFeatures = bl;
    }

    public boolean getDb12cFeatures() {
        return this._db12cFeatures;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.m_ctx = scriptRunnerContext;
    }

    private boolean isInterupted() {
        if (this.m_ctx != null) {
            return this.m_ctx.getExited();
        }
        return false;
    }
}

