/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.AnsiColorListPrinter;
import oracle.jdbc.OracleConnection;

public class ApexCmd
extends CommandListener
implements IHelp {
    private static final String PADDING = "                                                                                                                    ";
    static QueryXMLSupport s_xml = null;

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(ApexCmd.class.getClassLoader(), "oracle/dbtools/raptor/newscriptrunner/commands/describe.xml"));
        }
        return s_xml;
    }

    @Override
    public String getCommand() {
        return "APEX";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSql().toLowerCase().startsWith("apex")) {
            String string;
            String[] stringArray = iSQLCommand.getSql().split(" ");
            String string2 = stringArray[0];
            String string3 = stringArray.length > 1 && stringArray[1] != null ? stringArray[1] : "list";
            String string4 = string = stringArray.length > 2 && stringArray[2] != null ? stringArray[2] : null;
            if (string3.trim().equalsIgnoreCase("")) {
                string3 = "list";
            }
            if (connection == null) {
                scriptRunnerContext.write("SP2-0640: Not connected\n");
                return true;
            }
            String string5 = null;
            if (string3.equalsIgnoreCase("list")) {
                string5 = "apex.list";
                this.printList(connection, scriptRunnerContext, string5);
            } else if (string3.equalsIgnoreCase("log")) {
                string5 = "apex.log";
                this.printList(connection, scriptRunnerContext, string5);
            } else if (string3.equalsIgnoreCase("export") && string != null) {
                scriptRunnerContext.write(this.getDDL(connection, string));
            }
            return true;
        }
        return false;
    }

    private void printList(Connection connection, ScriptRunnerContext scriptRunnerContext, String string) {
        Properties properties = ((OracleConnection)connection).getProperties();
        Query query = ApexCmd.getXMLQueries().getQuery(string, connection);
        DBUtil dBUtil = DBUtil.getInstance(connection);
        HashMap hashMap = new HashMap();
        List<List<?>> list = dBUtil.executeReturnListofList(query.getSql(), hashMap);
        AnsiColorListPrinter.printListofList(scriptRunnerContext, list);
    }

    public String getDDL(Connection connection, String string) {
        DBUtil dBUtil = DBUtil.getInstance(connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("APPLICATION_ID", string);
        String string2 = dBUtil.executeReturnOneCol("select workspace_id from apex_applications where application_id = :APPLICATION_ID", hashMap);
        hashMap.put("WORKSPACE_ID", string2);
        String string3 = "declare  nm     owa.vc_arr;    vl     owa.vc_arr;    begin   nm(1) := 'WEB_AUTHENT_PREFIX';  vl(1) := 'WEB$';  owa.init_cgi_env( 1, nm, vl );  sys.htp.htbuf_len := 84;  end;";
        dBUtil.execute(string3);
        dBUtil.execute("begin apex_util.export_application(p_application_id=>:APPLICATION_ID,p_workspace_id=>:WORKSPACE_ID); end; ", hashMap);
        String string4 = this.getOWA(connection);
        string4 = string4.substring(string4.indexOf("\n\n"));
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOWA(Connection connection) {
        CallableStatement callableStatement = null;
        String string = null;
        try {
            String string2 = "declare    l_buf  varchar2(32767);    l_clob CLOB;    l_lines htp.htbuf_arr;    l_num   number := 999999;  begin    dbms_lob.createtemporary(l_clob, TRUE);    OWA.GET_PAGE(l_lines, l_num);    for i in 1..l_num loop      dbms_lob.append(l_clob,l_lines(i));    end loop;    ? := l_clob; end;";
            callableStatement = connection.prepareCall(string2);
            callableStatement.registerOutParameter(1, 2005);
            callableStatement.execute();
            Clob clob = callableStatement.getClob(1);
            string = clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }
}

