/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Clob;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class HTMLFormatter
extends ResultsFormatter {
    public static final String TYPE = "HTML";
    public static final String EXT = "htm";
    public static final String KEY_REC_TERM = "EXPORT_HTM_REC_TERM";
    private boolean _result = true;
    private static final String HEADER = "<!DOCTYPE html>\n<html>\n\n<head>\n  <meta charset='@@ENCODING@@'>\n  \n  <title>Responsive Table</title>\n  \n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n\n  \n  <style>\n  * { \n    margin: 0; \n    padding: 0; \n  }\n  body { \n    font: 14px/1.4 Georgia, Serif; \n  }\n  \n  /* \n  Generic Styling, for Desktops/Laptops \n  */\n  table { \n    width: 100%; \n    border-collapse: collapse; \n  }\n  /* Zebra striping */\n  tr:nth-of-type(odd) { \n    background: #eee; \n  }\n  th { \n    background: #333; \n    color: white; \n    font-weight: bold; \n  }\n  td, th { \n    padding: 6px; \n    border: 1px solid #9B9B9B; \n    text-align: left; \n  }\n  @media \n  only screen and (max-width: 760px),\n  (min-device-width: 768px) and (max-device-width: 1024px)  {\n    table, thead, tbody, th, td, tr { display: block; }\n    thead tr { position: absolute;top: -9999px;left: -9999px;}\n    tr { border: 1px solid #9B9B9B; }\n    td { border: none;border-bottom: 1px solid #9B9B9B; position: relative;padding-left: 50%; }\n    \n    td:before { position: absolute;top: 6px;left: 6px;width: 45%; padding-right: 10px; white-space: nowrap;}\n    \n    /*\n    Label the data\n    */";
    private static final String HEADER_PART2 = "  }\n  \n  /* Smartphones (portrait and landscape) ----------- */\n  @media only screen\n  and (min-device-width : 320px)\n  and (max-device-width : 480px) {\n    body { \n      padding: 0; \n      margin: 0; \n      width: 320px; }\n    }\n  \n  /* iPads (portrait and landscape) ----------- */\n  @media only screen and (min-device-width: 768px) and (max-device-width: 1024px) {\n    body { \n      width: 495px; \n    }\n  }\n  \n  </style>\n  <!--<![endif]-->\n<script type=\"text/javascript\">\n\nlsearch = function(){\n  //this.term = document.getElementById('S').value.toUpperCase();\n  var s = document.getElementById('search').value.toLowerCase();\n  rows = document.getElementById('data').getElementsByTagName('TR');\n  for(var i=0;i<rows.length;i++){\n    if (s ==\"\" ){\n      rows[i].style.display ='';\n    } else if ( rows[i].innerText.toLowerCase().indexOf(s) != -1 ) {\n      rows[i].style.display ='';\n    } else {\n      rows[i].style.display ='none';\n    }\n  }\n  this.time = false;\n}\n\n</script>\n</head>\n\n<body>\n<div><input type=\"text\" size=\"30\" maxlength=\"1000\" value=\"\" id=\"search\" onkeyup=\"lsearch();\" /><input type=\"button\" value=\"Go\" onclick=\"lsearch();\"/> </div>";

    public HTMLFormatter() {
        super(TYPE, "HTML File", EXT);
    }

    @Override
    public boolean isTextEditorReadable() {
        return false;
    }

    @Override
    public void start() throws IOException {
        String string;
        int n;
        this.write(HEADER.replace("@@ENCODING@@", this.getEncode()) + this.getLineTerminator());
        int n2 = this.getColumnCount();
        for (n = 0; n < n2; ++n) {
            string = this.getColumnName(n);
            this.write("td:nth-of-type(" + n + "):before { content: \"" + string + "\"; }" + this.getLineTerminator());
        }
        this.write(HEADER_PART2 + this.getLineTerminator());
        this.write("<table><thead><tr>");
        for (n = 0; n < n2; ++n) {
            string = this.getColumnName(n);
            this.write("\t<th>" + string + "</th>" + this.getLineTerminator());
        }
        this.write("</tr></thead>\n<tbody id=\"data\">\n" + this.getLineTerminator());
    }

    @Override
    public void startRow() throws IOException {
        this.write("\t<tr>" + this.getLineTerminator());
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        if (super.getDataType(n) == 2) {
            this.write("<td align=\"right\">");
        } else {
            this.write("<td>");
        }
        if (object instanceof List) {
            String string = "<table><tr>";
            List list = (List)object;
            List list2 = (List)list.get(0);
            int n3 = 0;
            for (Object object2 : list2) {
                string = string + "<th>" + list2.get(n3) + "</th>";
                ++n3;
            }
            string = string + "</tr>";
            int n4 = 0;
            for (Object e : list) {
                if (n4 > 0) {
                    string = string + "<tr>";
                    int n5 = 0;
                    for (Object e2 : (List)e) {
                        string = string + "<td>" + this.escape(this.getValue(e2).toString()) + "</td>";
                        ++n5;
                    }
                    string = string + "</tr>";
                }
                ++n4;
            }
            string = string + "</table>";
            this.write(string);
        } else {
            this.write(this.escape(this.getValue(object)));
        }
        this.write("</td>" + this.getLineTerminator());
    }

    private String escape(String string) {
        if (string != null) {
            return string.replace("<", "&lt;").replace(">", "&gt;");
        }
        return "&nbsp;";
    }

    @Override
    public void endRow() throws IOException {
        this.write("\t</tr>" + this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
        this.write("</tbody></table><!-- SQL:\n" + this.getWrapper().getSQL() + "--></body></html>\n");
    }

    public void setResult(boolean bl) {
        this._result = bl;
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    protected String getValue(Object object) {
        Object object2 = null;
        try {
            if (object instanceof Clob) {
                Integer n = null;
                if (this.getScriptContext() != null) {
                    n = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
                }
                object2 = n != null ? DataTypesUtil.stringValue(object, this.getConnection(), n) : DataTypesUtil.stringValue(object, this.getConnection());
            } else {
                object2 = super.getValue(object);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return object2 != null ? object2.toString() : null;
    }
}

