/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import oracle.dbtools.raptor.extendedtype.AbstractExtendedType;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;

public class XMLExtendeType
extends AbstractExtendedType {
    protected XMLExtendeType(int n, OPAQUE oPAQUE) {
        super(n, oPAQUE);
    }

    public XMLExtendeType(OPAQUE oPAQUE) {
        this(2009, oPAQUE);
    }

    public void setValue(OPAQUE oPAQUE) {
        this.setOrigValue(oPAQUE);
    }

    public OPAQUE getObjectValue() {
        return this.getOrigValue();
    }

    @Override
    public OPAQUE getOrigValue() {
        return (OPAQUE)super.getOrigValue();
    }

    public String toString() {
        try {
            URL uRL = this.getLoadFromURL();
            if (uRL != null) {
                return "[" + uRL != null ? uRL.toString() : "]";
            }
            if (this.getOrigValue() != null) {
                return DataTypesUtil.stringValue(this.getOrigValue(), (Connection)this.getOrigValue().getOracleConnection());
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return "";
    }

    @Override
    public void duplicate() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(Boolean bl) throws Exception {
        if (bl == null && this.getLoadFromURL() != null || bl != null && !bl.booleanValue()) {
            return super.getBinaryStream(bl);
        }
        if (this.getOrigValue() != null) {
            XMLType xMLType = XMLType.createXML((OPAQUE)this.getOrigValue());
            CLOB cLOB = xMLType.getClobVal();
            try {
                return DataTypesUtil.getXMLAsBytes(cLOB.getCharacterStream());
            }
            catch (Exception exception) {
                return cLOB.getAsciiStream();
            }
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    @Override
    public Reader getReader(Boolean bl, String string) throws Exception {
        URL uRL = this.getLoadFromURL();
        if (bl == null && uRL != null || bl != null && !bl.booleanValue()) {
            FileInputStream fileInputStream;
            if (uRL != null && (fileInputStream = new FileInputStream(new File(uRL.toURI()))) != null) {
                if (string == null) {
                    string = "UTF-8";
                }
                return DataTypesUtil.getXMLAsReader(fileInputStream, string);
            }
        } else {
            CLOB cLOB;
            OPAQUE oPAQUE = this.getOrigValue();
            Object object = oPAQUE instanceof XMLType ? (XMLType)oPAQUE : (oPAQUE != null ? XMLType.createXML((OPAQUE)oPAQUE) : null);
            if (object != null && (cLOB = object.getClobVal()) != null) {
                return new TemporaryClobReader(cLOB);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDb(Connection connection, String string, String string2, String string3, String string4, boolean bl, List<String> list) throws SQLException, IOException {
        try (Statement statement = null;){
            Object object;
            XMLType xMLType = null;
            URL uRL = this.getLoadFromURL();
            if (uRL != null) {
                object = null;
                try {
                    object = new FileInputStream(new File(uRL.toURI()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    Logger.getLogger(XMLExtendeType.class.getName()).log(Level.SEVERE, uRISyntaxException.getMessage());
                }
                CLOB cLOB = DataTypesUtil.getTemporaryCLOB(connection);
                try {
                    Writer writer = cLOB.setCharacterStream(1L);
                    try {
                        DataTypesUtil.getXMLAsCharacters((InputStream)object, writer);
                        writer.flush();
                        xMLType = XMLType.createXML((Connection)connection, (CLOB)cLOB);
                    }
                    catch (XMLStreamException xMLStreamException) {
                        try {
                            xMLType = XMLType.createXML((Connection)connection, (InputStream)new FileInputStream(new File(uRL.toURI())));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Logger.getLogger(XMLExtendeType.class.getName()).log(Level.SEVERE, uRISyntaxException.getMessage());
                        }
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        cLOB.close();
                    }
                    catch (SQLException sQLException) {}
                }
            } else if (this.getOrigValue() != null) {
                xMLType = XMLType.createXML((OPAQUE)this.getOrigValue());
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("UPDATE ").append(string).append(" SET ").append(string2).append("=? WHERE ROWID=:sqldevrowid");
            if (bl && string4 != null) {
                ((StringBuffer)object).append(" AND ORA_ROWSCN=:sqldevrowscn");
            }
            list.add(((StringBuffer)object).toString());
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            statement.setObject(1, xMLType);
            statement.setString(2, string3);
            if (bl && string4 != null) {
                statement.setString(3, string4);
            }
            int n = statement.executeUpdate();
            uRL = null;
            boolean bl2 = n == 1;
            return bl2;
        }
    }

    @Override
    public boolean saveToDisk(String string, String string2, String string3, String string4, boolean bl) throws SQLException, IOException {
        return false;
    }

    @Override
    public void setToDiskStream(OutputStream outputStream) {
    }

    protected static class TemporaryClobReader
    extends BufferedReader {
        private CLOB clob;

        public TemporaryClobReader(CLOB cLOB) throws SQLException {
            super(cLOB.getCharacterStream());
            this.clob = cLOB;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                if (this.clob != null && this.clob.isTemporary()) {
                    this.clob.freeTemporary();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

