/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import oracle.dbtools.raptor.extendedtype.AbstractExtendedType;

public class GenericBlobType
extends AbstractExtendedType
implements Blob {
    protected InputStream in = null;
    protected OutputStream out = null;

    protected GenericBlobType(int n, Blob blob) {
        super(n, blob);
    }

    public GenericBlobType() {
        this(null);
    }

    public GenericBlobType(Blob blob) {
        this(2004, blob);
    }

    @Override
    public Blob getOrigValue() {
        return (Blob)super.getOrigValue();
    }

    public Blob getOrigBlob() {
        return this.getOrigValue();
    }

    @Override
    public void duplicate() throws SQLException {
        if (this.getOrigValue() != null) {
            this.in = this.getOrigValue().getBinaryStream();
        }
    }

    @Override
    public InputStream getBinaryStream(Boolean bl) throws Exception {
        if (bl == null && this.getLoadFromURL() != null || bl != null && !bl.booleanValue()) {
            return super.getBinaryStream(bl);
        }
        if (this.getOrigValue() != null) {
            return this.getOrigValue().getBinaryStream();
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    @Override
    public boolean saveToDb(Connection connection, String string, String string2, String string3, String string4, boolean bl, List<String> list) throws SQLException, IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDisk(String string, String string2, String string3, String string4, boolean bl) throws SQLException, IOException {
        Blob blob = this.getOrigValue();
        if (blob != null && this.out != null) {
            InputStream inputStream = null;
            try {
                inputStream = blob.getBinaryStream();
                if (inputStream != null) {
                    byte[] byArray = new byte[10];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) != -1) {
                        this.out.write(byArray, 0, n);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.out.close();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return false;
    }

    @Override
    public void setLoadFromURL(URL uRL) {
        if (uRL == null) {
            this.setSuperLoadFromURL(null);
        }
    }

    protected void setSuperLoadFromURL(URL uRL) {
        super.setLoadFromURL(uRL);
    }

    @Override
    public void setToDiskStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        return this.getOrigValue().getBytes(l, n);
    }

    @Override
    public long length() throws SQLException {
        return this.getOrigValue().length();
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        return this.getOrigValue().position(byArray, l);
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        return this.getOrigValue().position(blob, l);
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        return this.getOrigValue().setBinaryStream(l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.getOrigValue().setBytes(l, byArray);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        return this.getOrigValue().setBytes(l, byArray, n, n2);
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.getOrigValue().truncate(l);
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return this.getOrigValue().hashCode();
    }

    public String toString() {
        return "(Blob)";
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        return null;
    }
}

