/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatumAtName;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingLONGBINARY<P extends DataBinding>
extends CallableBindingDatumAtName<P> {
    public CallableBindingLONGBINARY(BindContext bindContext, P p) {
        super(bindContext, p);
    }

    @Override
    protected void customBindIN(DataValue dataValue, int n) throws SQLException {
        this.inputValue = dataValue;
        LongBinary longBinary = (LongBinary)dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                this.getCallableStatement().setBinaryStream(n, longBinary.getInputStream(), (int)longBinary.getLength());
            }
            catch (IOException iOException) {
                throw new DataTypeIOException(iOException);
            }
        } else {
            this.getCallableStatement().setNull(n, this.dataType.getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected void customBindIN(DataValue dataValue, String string) throws SQLException {
        this.inputValue = dataValue;
        LongBinary longBinary = (LongBinary)dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                this.getCallableStatement().setBinaryStreamAtName(string, longBinary.getInputStream(), (int)longBinary.getLength());
            }
            catch (IOException iOException) {
                throw new DataTypeIOException(iOException);
            }
        } else {
            this.getCallableStatement().setNull(string, this.dataType.getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected DataValue customOutputByPosition(OracleCallableStatement oracleCallableStatement, int n) throws SQLException {
        InputStream inputStream = oracleCallableStatement.getBinaryStream(n);
        return this.dataType.getDataValue(inputStream);
    }
}

