/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;
import oracle.sql.Datum;

public class OraDATE
extends OraTemporalDatum {
    public static OraDATE getInstance() {
        OraDATE oraDATE = OraDATE.getInstance(Calendar.getInstance());
        if (oraDATE != null) {
            oraDATE.setNow();
        }
        return oraDATE;
    }

    public static OraDATE getInstance(Calendar calendar) {
        return calendar != null ? new OraDATE(new OraDATEImpl(UTC, calendar, null)) : null;
    }

    public static OraDATE getInstance(DATE dATE) {
        return dATE != null ? new OraDATE(new OraDATEImpl(UTC, (Datum)dATE)) : null;
    }

    public static OraDATE getInstance(Date date) {
        return date != null ? new OraDATE(new OraDATEImpl(UTC, date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime()))) : null;
    }

    protected OraDATE(OraDATEImpl oraDATEImpl) {
        super(oraDATEImpl);
    }

    @Override
    public boolean nanosSupported() {
        return false;
    }

    @Override
    public boolean timeZoneOverlayed() {
        return true;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.datumImpl.overlayTimeZone(timeZone);
    }

    @Override
    public void setSessionTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            this.setTimeZone(UTC);
            this.sessionTimeZoneAdjusted = false;
        } else {
            this.setTimeZone(timeZone);
            this.sessionTimeZoneAdjusted = true;
        }
    }

    public DATE getDatum() {
        byte[] byArray = new byte[7];
        this.datumImpl.packDatumBytes(byArray);
        return new DATE(byArray);
    }

    public String toString() {
        try {
            OraDATEFormat oraDATEFormat = new OraDATEFormat(new OracleNLSProvider(null).getDateFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraDATEFormat.format(this.getDatum());
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    protected static class OraDATEImpl
    extends OraTemporalDatum.OraTemporalDatumImpl {
        protected OraDATEImpl(TimeZone timeZone, Calendar calendar, Integer n) {
            super(timeZone, calendar, n);
            this.setFractionalPrecision(0);
        }

        protected OraDATEImpl(TimeZone timeZone, Datum datum) {
            super(timeZone, datum);
            this.setFractionalPrecision(0);
        }

        protected OraDATEImpl(TimeZone timeZone, Timestamp timestamp) {
            super(timeZone, timestamp);
            this.setFractionalPrecision(0);
        }

        @Override
        protected int getDatumLength(int n) {
            return 7;
        }

        @Override
        protected boolean isDatumLengthValid(int n) {
            return n == 7;
        }
    }
}

