/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallWriter;
import oracle.dbtools.raptor.datatypes.objects.LargeDatum;
import oracle.dbtools.raptor.datatypes.util.CappedFilterWriter;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import org.xml.sax.SAXException;

public abstract class LargeVarchar
extends LargeDatum {
    public LargeVarchar() {
    }

    protected LargeVarchar(Object object) {
        super(object);
    }

    protected LargeVarchar(LargeVarchar largeVarchar) {
        super(largeVarchar);
    }

    public Writer exportTo(Writer writer) throws IOException, SQLException {
        LargeVarchar.copyCharacters(this.getReader(), writer);
        writer.flush();
        return writer;
    }

    public StringBuffer exportTo(StringBuffer stringBuffer) throws IOException, SQLException {
        LargeVarchar.copyCharacters(this.getReader(), stringBuffer);
        return stringBuffer;
    }

    public StringBuilder exportTo(StringBuilder stringBuilder) throws IOException, SQLException {
        LargeVarchar.copyCharacters(this.getReader(), stringBuilder);
        return stringBuilder;
    }

    public Clob exportTo(Clob clob) throws IOException, SQLException {
        Writer writer = clob.setCharacterStream(1L);
        this.exportTo(writer);
        writer.close();
        return clob;
    }

    public File exportTo(File file) throws IOException, SQLException {
        this.exportToObject(file);
        return file;
    }

    public Object exportTo(Object object) throws IOException, SQLException {
        return this.exportToObject(object);
    }

    protected Object exportToObject(Object object) throws IOException, SQLException {
        if (object instanceof Writer) {
            return this.exportTo((Writer)object);
        }
        if (object instanceof Clob) {
            return this.exportTo((Clob)object);
        }
        if (object instanceof File) {
            return this.exportTo(new FileWriter((File)object));
        }
        if (object instanceof StringBuilder) {
            return this.exportTo((StringBuilder)object);
        }
        if (object instanceof StringBuffer) {
            return this.exportTo((StringBuffer)object);
        }
        throw new IllegalArgumentException();
    }

    public abstract Reader getReader() throws IOException, SQLException;

    public boolean equals(Object object) {
        boolean bl = this == object;
        try {
            if (!bl && object instanceof LargeVarchar) {
                LargeVarchar largeVarchar = (LargeVarchar)object;
                bl = this.getLength() == largeVarchar.getLength() && (this.getValue() == null && largeVarchar.getValue() == null || this.getValue() != null && largeVarchar.getValue() != null && LargeVarchar.compareData(this.getReader(), largeVarchar.getReader()));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected StringValue customStringValue(StringType stringType, int n) {
        switch (stringType) {
            case DEFAULT: {
                StringValue stringValue = null;
                try {
                    StringWriter stringWriter = new StringWriter();
                    BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                    CappedFilterWriter cappedFilterWriter = new CappedFilterWriter(bufferedWriter, n);
                    Reader reader = this.getReader();
                    try {
                        LargeVarchar.copyCharacters(reader, cappedFilterWriter, 256);
                        return stringValue;
                    }
                    finally {
                        try {
                            ((Writer)cappedFilterWriter).close();
                            stringValue = new StringValue(stringWriter.toString(), this.getLength());
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    if (stringValue != null && n >= 0 && stringValue.toString().length() >= n) return stringValue;
                    throw new DataTypeSQLException(sQLException);
                }
                catch (IOException iOException) {
                    if (stringValue != null && n >= 0 && stringValue.toString().length() >= n) return stringValue;
                    throw new DataTypeIOException(iOException);
                }
            }
        }
        return super.customStringValue(stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        switch (valueType) {
            case TARGET: {
                return this.exportTo(object);
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, valueType, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshallToXml(DataType dataType, DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new DataValueMarshallWriter(dataType, dataValueMarshallHandler, string), 2400);
            Reader reader = this.getReader();
            try {
                LargeVarchar.copyCharacters(reader, bufferedWriter);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                }
            }
            bufferedWriter.flush();
        }
        catch (SQLException sQLException) {
            throw new DataTypeSQLException(sQLException);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
    }

    public static void copyCharacters(Reader reader, Writer writer) throws IOException {
        LargeVarchar.copyCharacters(reader, writer, 2400);
    }

    public static void copyCharacters(Reader reader, Writer writer, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = reader.read(cArray);
        while (n2 != -1) {
            writer.write(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
    }

    public static void copyCharacters(Reader reader, StringBuffer stringBuffer) throws IOException {
        LargeVarchar.copyCharacters(reader, stringBuffer, 2400);
    }

    public static void copyCharacters(Reader reader, StringBuffer stringBuffer, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = reader.read(cArray);
        while (n2 != -1) {
            stringBuffer.append(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
    }

    public static void copyCharacters(Reader reader, StringBuilder stringBuilder) throws IOException {
        LargeVarchar.copyCharacters(reader, stringBuilder, 2400);
    }

    public static void copyCharacters(Reader reader, StringBuilder stringBuilder, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = reader.read(cArray);
        while (n2 != -1) {
            stringBuilder.append(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
    }

    public static boolean compareData(Reader reader, Reader reader2) throws IOException {
        char[] cArray = new char[2400];
        char[] cArray2 = new char[2400];
        Arrays.fill(cArray, ' ');
        Arrays.fill(cArray2, ' ');
        int n = reader.read(cArray);
        int n2 = reader2.read(cArray2);
        while (n != -1 && n2 != -1 && n == n2) {
            if (!Arrays.equals(cArray, cArray2)) {
                return false;
            }
            n = reader.read(cArray);
            n2 = reader2.read(cArray2);
        }
        return n == n2;
    }

    public abstract class LargeVarcharBuilder
    extends LargeDatum.LargeDatumBuilder {
        protected Writer writer;

        protected LargeVarcharBuilder(Writer writer, int n) {
            super(n);
            this.writer = writer;
        }

        public LargeVarcharBuilder write(char[] cArray, int n, int n2) throws IOException {
            this.checkForCutOver(n2);
            this.writer.write(cArray, n, n2);
            this.length += (long)n2;
            return this;
        }

        public LargeVarcharBuilder write(Reader reader) throws IOException {
            char[] cArray = new char[2400];
            int n = reader.read(cArray);
            while (n != -1) {
                this.write(cArray, 0, n);
                n = reader.read(cArray);
            }
            return this;
        }
    }
}

