/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.UnsupportedDataTypeImpl;

public abstract class AbstractDataTypeFactoryImpl
implements DataTypeProvider {
    private DataTypeProvider next;
    private final Map<Integer, TypeMetadata> typeCodeMetadataMap;
    private final Map<String, TypeMetadata> typeNameMetadataMap;

    protected AbstractDataTypeFactoryImpl(DataTypeProvider dataTypeProvider, Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> map) {
        TypeMetadata typeMetadata;
        Map<TypeMetadata.Attribute, Object> map2;
        NamedValue<Map<TypeMetadata.Attribute, Object>> namedValue;
        String string;
        this.next = dataTypeProvider;
        this.typeCodeMetadataMap = new HashMap<Integer, TypeMetadata>();
        this.typeNameMetadataMap = new HashMap<String, TypeMetadata>();
        for (Map.Entry<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> entry : map.entrySet()) {
            string = entry.getKey();
            namedValue = entry.getValue();
            map2 = new HashMap<TypeMetadata.Attribute, Object>();
            AbstractDataTypeFactoryImpl.getTypePropertyMap(dataTypeProvider, map2, map, string, namedValue);
            boolean bl = namedValue != null && namedValue.getValue() == null && namedValue.getName() != null && !namedValue.getName().contains("(");
            typeMetadata = DataTypeFactory.getTypeMetadata(map2, bl);
            if (typeMetadata == null) continue;
            this.typeNameMetadataMap.put(string, typeMetadata);
        }
        for (Map.Entry<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> entry : map.entrySet()) {
            Integer n;
            string = entry.getKey();
            namedValue = entry.getValue();
            map2 = namedValue.getValue();
            if (map2 == null || (n = (Integer)map2.get((Object)TypeMetadata.Attribute.TYPE_CODE)) == null || (typeMetadata = this.typeNameMetadataMap.get(string)) == null) continue;
            this.typeCodeMetadataMap.put(n, typeMetadata);
        }
    }

    private static void getTypePropertyMap(DataTypeProvider dataTypeProvider, Map<TypeMetadata.Attribute, Object> map, Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> map2, String string, NamedValue<Map<TypeMetadata.Attribute, Object>> namedValue) {
        if (namedValue != null) {
            String string2 = namedValue.getName();
            Map<TypeMetadata.Attribute, Object> map3 = namedValue.getValue();
            if (string2 != null) {
                NamedValue<Map<TypeMetadata.Attribute, Object>> namedValue2 = map2.get(string2);
                AbstractDataTypeFactoryImpl.getTypePropertyMap(dataTypeProvider, map, map2, string2, namedValue2);
            }
            if (map3 != null) {
                map.putAll(map3);
            }
            if (!map.containsKey((Object)TypeMetadata.Attribute.BASE_TYPE)) {
                map.put(TypeMetadata.Attribute.BASE_TYPE, string);
            }
        } else {
            TypeMetadata typeMetadata;
            TypeMetadata typeMetadata2 = typeMetadata = dataTypeProvider != null ? dataTypeProvider.getTypeMetadata(string) : null;
            if (typeMetadata != null) {
                typeMetadata.export(map);
            }
        }
        map.put(TypeMetadata.Attribute.DATA_TYPE, string);
    }

    @Override
    public DataType getDataType(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        DataType dataType = null;
        TypeMetadata typeMetadata2 = this.expandTypeMetadata(typeMetadata);
        if (typeMetadata2 == null) {
            if (this.next != null) {
                return this.next.getDataType(dataTypeContext, typeMetadata);
            }
        } else {
            Class<? extends DataType> clazz = this.getDataTypeClass(typeMetadata2);
            if (clazz != null) {
                try {
                    Constructor<? extends DataType> constructor = clazz.getDeclaredConstructor(DataTypeContext.class, TypeMetadata.class);
                    constructor.setAccessible(true);
                    dataType = constructor.newInstance(dataTypeContext, typeMetadata2);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return dataType == null ? new UnsupportedDataTypeImpl(dataTypeContext, typeMetadata) : dataType;
    }

    protected TypeMetadata filterExpandedTypeMetadata(TypeMetadata typeMetadata, TypeMetadata typeMetadata2) {
        return this.customFilterExpandedTypeMetadata(typeMetadata, typeMetadata2);
    }

    protected TypeMetadata customFilterExpandedTypeMetadata(TypeMetadata typeMetadata, TypeMetadata typeMetadata2) {
        if (typeMetadata != null) {
            String string;
            String string2 = typeMetadata.get_impl_data_type();
            if (!(typeMetadata2 == null || (string = typeMetadata2.get_impl_data_type()) == null || string2 != null && string2.equals(string))) {
                return null;
            }
            if (!this.customSupportedType(typeMetadata)) {
                return null;
            }
        }
        return typeMetadata;
    }

    protected Class<? extends DataType> getDataTypeClass(TypeMetadata typeMetadata) {
        return typeMetadata.get_impl_class();
    }

    protected String getDataTypeName(TypeMetadata typeMetadata) {
        return typeMetadata.get_data_type();
    }

    protected boolean customSupportedType(TypeMetadata typeMetadata) {
        return this.customImplementedType(typeMetadata);
    }

    protected boolean customImplementedType(TypeMetadata typeMetadata) {
        return this.getDataTypeClass(typeMetadata) != null;
    }

    @Override
    public final Set<String> getSupportedTypes() {
        TreeSet<String> treeSet = this.next != null ? this.next.getSupportedTypes() : new TreeSet();
        for (Map.Entry<String, TypeMetadata> entry : this.typeNameMetadataMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getKey().contains("(") || !this.customImplementedType(entry.getValue())) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet;
    }

    @Override
    public final Set<Integer> getSupportedSQLTypes() {
        TreeSet<Integer> treeSet = this.next != null ? this.next.getSupportedSQLTypes() : new TreeSet();
        for (Map.Entry<Integer, TypeMetadata> entry : this.typeCodeMetadataMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || this.customImplementedType(entry.getValue())) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet;
    }

    @Override
    public final Map<String, TypeMetadata> getSupportedTypeMetadata() {
        HashMap<String, TypeMetadata> hashMap = this.next != null ? this.next.getSupportedTypeMetadata() : new HashMap();
        for (Map.Entry<String, TypeMetadata> entry : this.typeNameMetadataMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getKey().contains("(") || !this.customImplementedType(entry.getValue())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    protected TypeMetadata expandTypeMetadata(TypeMetadata typeMetadata) {
        TypeMetadata typeMetadata2 = null;
        TypeMetadata typeMetadata3 = null;
        if (typeMetadata.get_data_type() != null) {
            typeMetadata3 = this.typeNameMetadataMap.get(typeMetadata.get_data_type());
        }
        if (typeMetadata3 == null && typeMetadata.get_base_type() != null) {
            typeMetadata3 = this.typeNameMetadataMap.get(typeMetadata.get_base_type());
        }
        if (typeMetadata3 != null) {
            typeMetadata2 = this.filterExpandedTypeMetadata(DataTypeFactory.getTypeMetadata(typeMetadata3, typeMetadata), typeMetadata);
        }
        return typeMetadata2;
    }

    @Override
    public final TypeMetadata getTypeMetadata(String string) {
        TypeMetadata typeMetadata = this.typeNameMetadataMap.get(string);
        return typeMetadata == null && this.next != null ? this.next.getTypeMetadata(string) : typeMetadata;
    }

    @Override
    public final TypeMetadata getTypeMetadata(Integer n) {
        TypeMetadata typeMetadata = this.typeCodeMetadataMap.get(n);
        return typeMetadata == null && this.next != null ? this.next.getTypeMetadata(n) : typeMetadata;
    }

    @Override
    public final TypeMetadata getTypeMetadata(DataTypeContext dataTypeContext, Integer n, Object object) {
        TypeMetadata typeMetadata = this.typeCodeMetadataMap.get(n);
        return typeMetadata == null && this.next != null ? this.next.getTypeMetadata(dataTypeContext, n, object) : typeMetadata;
    }
}

