/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.raptor.datatypes.blob.BlobMimeType;
import oracle.dbtools.raptor.datatypes.blob.IBlobMimeXmlParser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BlobMimeXmlParser
extends DefaultHandler
implements IBlobMimeXmlParser {
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int NO_OF_BYTES = 520;
    private String m_hexMimeString = null;
    ArrayList<BlobMimeType> mimeType;
    private String tempVal;
    private BlobMimeType tempBlobMime;
    private String m_magicNumber = null;
    private String m_mimeType = null;
    private String m_applicationType = null;
    private String m_extension = null;
    private String m_description = null;
    private static final int NO_OF_OLE_BYTES = 20400;
    private boolean m_isMimeTypeSupported = false;

    public BlobMimeXmlParser() {
    }

    public BlobMimeXmlParser(InputStream inputStream) throws IOException {
        this.initializeBlobParser(inputStream);
    }

    @Override
    public void initializeBlobParser(InputStream inputStream) throws IOException {
        this.mimeType = new ArrayList();
        this.m_isMimeTypeSupported = this.getHexStream(inputStream);
        if (this.m_isMimeTypeSupported) {
            this.parseBlobXML(this.getHexMimeString());
            this.getMimeAndApplicationType();
        }
    }

    private boolean parseBlobXML(String string) {
        this.setMagicNumber(string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.getMimeMagicNumberXmlFile().openStream(), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
            ExceptionHandler.handleException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, parserConfigurationException.getStackTrace()[0].toString(), parserConfigurationException);
            ExceptionHandler.handleException(parserConfigurationException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            ExceptionHandler.handleException(iOException);
        }
        return true;
    }

    private boolean getMimeAndApplicationType() {
        for (BlobMimeType blobMimeType : this.mimeType) {
            if (!this.compareMagicNumber(blobMimeType.getMagicNumber(), blobMimeType.getMagicNumberLength())) continue;
            if (blobMimeType.getOffset() != 0) {
                if (!this.compareOffsetNumber(blobMimeType.getOffset(), blobMimeType.getOffsetNumber(), blobMimeType.getOffsetNumberLength())) continue;
                this.setMimeType(blobMimeType.getMimeType());
                this.setApplicationType(blobMimeType.getApplicationType());
                this.setExtension(blobMimeType.getExtension());
                this.setDescription(blobMimeType.getDescription());
                break;
            }
            this.setMimeType(blobMimeType.getMimeType());
            this.setApplicationType(blobMimeType.getApplicationType());
            this.setExtension(blobMimeType.getExtension());
            this.setDescription(blobMimeType.getDescription());
            break;
        }
        return false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.tempVal = "";
        if (string3.equalsIgnoreCase("match")) {
            this.tempBlobMime = new BlobMimeType();
        } else if (string3.equalsIgnoreCase("MagicNumber") && attributes.getLength() > 0) {
            this.tempBlobMime.setOffset(Integer.parseInt(attributes.getValue("offset")));
            this.tempBlobMime.setMagicNumberLength(Integer.parseInt(attributes.getValue("length")));
        } else if (string3.equalsIgnoreCase("OffsetNumber") && attributes.getLength() > 0) {
            this.tempBlobMime.setOffsetNumberLength(Integer.parseInt(attributes.getValue("length")));
            this.tempBlobMime.setOffsetNumber(attributes.getValue("OffsetNumber"));
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.tempVal = new String(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("match")) {
            this.mimeType.add(this.tempBlobMime);
        } else if (!string3.equalsIgnoreCase("datatype")) {
            if (string3.equalsIgnoreCase("offset")) {
                this.tempBlobMime.setOffset(Integer.parseInt(this.tempVal));
            } else if (string3.equalsIgnoreCase("OffsetNumber")) {
                this.tempBlobMime.setOffsetNumber(this.tempVal);
            } else if (string3.equalsIgnoreCase("length")) {
                this.tempBlobMime.setMagicNumberLength(Integer.parseInt(this.tempVal));
            } else if (string3.equalsIgnoreCase("MagicNumber")) {
                this.tempBlobMime.setMagicNumber(this.tempVal);
            } else if (string3.equalsIgnoreCase("Mimetype")) {
                this.tempBlobMime.setMimeType(this.tempVal);
            } else if (string3.equalsIgnoreCase("Extension")) {
                this.tempBlobMime.setExtension(this.tempVal);
            } else if (string3.equalsIgnoreCase("Application")) {
                this.tempBlobMime.setApplicationType(this.tempVal);
            } else if (string3.equalsIgnoreCase("Description")) {
                this.tempBlobMime.setDescription(this.tempVal);
            }
        }
    }

    private boolean compareMagicNumber(String string, int n) {
        String string2 = this.getMagicNumber();
        String string3 = string2.substring(0, n);
        return string2.substring(0, n).equals(string);
    }

    private boolean compareOffsetNumber(int n, String string, int n2) {
        String string2 = this.getMagicNumber();
        String string3 = string2.substring(n * 2, n * 2 + n2);
        return string2.substring(n * 2, n * 2 + n2).equals(string);
    }

    @Override
    public String getMagicNumber() {
        return this.m_magicNumber;
    }

    private void setMagicNumber(String string) {
        this.m_magicNumber = string;
    }

    @Override
    public String getExtension() {
        return this.m_extension;
    }

    private void setExtension(String string) {
        this.m_extension = string;
    }

    @Override
    public String getMimeType() {
        return this.m_mimeType;
    }

    private void setMimeType(String string) {
        this.m_mimeType = string;
    }

    @Override
    public String getApplicationType() {
        return this.m_applicationType;
    }

    private void setApplicationType(String string) {
        this.m_applicationType = string;
    }

    private void setDescription(String string) {
        this.m_description = string;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public boolean isMimeTypeSupported() {
        return this.m_isMimeTypeSupported;
    }

    private URL getMimeMagicNumberXmlFile() {
        String string = "/oracle/dbtools/raptor/datatypes/blob/MimeMagicNumber.xml";
        return this.getClass().getResource(string);
    }

    private boolean getHexStream(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[520];
            inputStream.mark(521);
            inputStream.read(byArray);
            this.setHexMimeString(this.getHexString(byArray));
            inputStream.reset();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public String getOleHexStream(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[20400];
            inputStream.mark(20401);
            inputStream.read(byArray);
            inputStream.reset();
            return this.getHexString(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getHexString(byte[] byArray) throws UnsupportedEncodingException {
        byte[] byArray2 = new byte[2 * byArray.length];
        int n = 0;
        for (byte by : byArray) {
            int n2 = by & 0xFF;
            byArray2[n++] = HEX_CHAR_TABLE[n2 >> 4];
            byArray2[n++] = HEX_CHAR_TABLE[n2 & 0xF];
        }
        return new String(byArray2, "ASCII");
    }

    public void setHexMimeString(String string) {
        this.m_hexMimeString = string;
    }

    public String getHexMimeString() {
        return this.m_hexMimeString;
    }
}

