/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;

public class RecognizedRule
extends RuleTuple {
    public int pos;

    public RecognizedRule(String string, String[] stringArray, int n) {
        super(string, (String[])null);
        this.pos = n;
        int n2 = stringArray.length;
        if (n + 2 <= n2) {
            n2 = n + 2;
            this.rhs = new String[n2];
            for (int i = 0; i < n + 1; ++i) {
                this.rhs[i] = stringArray[i];
            }
            this.rhs[n + 1] = "...";
        } else {
            this.rhs = stringArray;
        }
    }

    public RecognizedRule(RecognizedRule recognizedRule, int n, int[] nArray) {
        super(recognizedRule.head, (String[])null);
        int n2;
        this.pos = n < recognizedRule.pos ? recognizedRule.pos + nArray.length - 1 : recognizedRule.pos;
        int n3 = recognizedRule.rhs.length + nArray.length - 1;
        if (this.pos + 2 <= n3) {
            n3 = this.pos + 2;
        }
        this.rhs = new String[n3];
        for (n2 = 0; n2 < n; ++n2) {
            this.rhs[n2] = recognizedRule.rhs[n2];
        }
        for (n2 = 0; n2 < nArray.length && n + n2 < n3; ++n2) {
            this.rhs[n + n2] = SqlEarley.getInstance().allSymbols[nArray[n2]];
        }
        for (n2 = n + 1; n2 < recognizedRule.rhs.length && n2 + nArray.length - 1 < n3; ++n2) {
            this.rhs[n2 + nArray.length - 1] = recognizedRule.rhs[n2];
        }
        if (n3 == this.pos + 2) {
            this.rhs[n3 - 1] = "...";
        }
    }

    public boolean isTruncated() {
        return this.pos == this.rhs.length - 2 && "...".equals(this.rhs[this.rhs.length - 1]);
    }

    public boolean isPresentable() {
        for (int i = 0; i < this.rhs.length; ++i) {
            if ("...".equals(this.rhs[i])) continue;
            int n = (Integer)SqlEarley.getInstance().symbolIndexes.get(this.rhs[i]);
            Map<Integer, DocURL> map = HarvestDoc.getRailroads();
            DocURL docURL = map.get(n);
            if (docURL != null || this.rhs[i].charAt(0) == '\'' || "identifier".equals(this.rhs[i])) continue;
            Earley.Tuple[] tupleArray = SqlEarley.getInstance().rules;
            for (int j = 0; j < tupleArray.length; ++j) {
                Earley.Tuple tuple = tupleArray[j];
                if (tuple.head != n) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRedundant(List<RecognizedRule> list) {
        boolean bl = false;
        for (RecognizedRule recognizedRule : list) {
            if (!this.head.equals(recognizedRule.head) || this.pos != recognizedRule.pos || !recognizedRule.isTruncated() || this.rhs.length + 1 != recognizedRule.rhs.length) continue;
            bl = true;
            for (int i = 0; i < this.rhs.length; ++i) {
                if (this.rhs[i].equals(recognizedRule.rhs[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    public static void merge(List<RecognizedRule> list, List<RecognizedRule> list2) {
        for (RecognizedRule recognizedRule : list2) {
            boolean bl = false;
            for (RecognizedRule recognizedRule2 : list) {
                if (!recognizedRule2.equals(recognizedRule)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.add(recognizedRule);
        }
    }

    @Override
    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n != 0) {
            return n;
        }
        return this.pos - ((RecognizedRule)object).pos;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.head != null) {
            stringBuffer.append(this.head + ":");
        }
        int n = -1;
        for (String string : this.rhs) {
            if (++n == this.pos) {
                stringBuffer.append(" >!<");
            }
            stringBuffer.append(" " + string);
        }
        return stringBuffer.toString();
    }
}

