/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class Parsed {
    private final String input;
    protected List<LexerToken> src;
    protected ParseNode root;
    protected Earley earley;
    private String rootSyntax;
    private SyntaxError err = null;
    protected boolean debug = false;
    protected Matrix matrix = null;

    public Parsed(String string, Earley earley, String string2) {
        this.input = string;
        this.earley = earley;
        this.rootSyntax = string2;
    }

    public Parsed(String string, List<LexerToken> list, Earley earley, String string2) {
        this.input = string;
        this.earley = earley;
        this.src = list;
        this.rootSyntax = string2;
    }

    public Parsed(String string, List<LexerToken> list, ParseNode parseNode) {
        this.input = string;
        this.src = list;
        this.root = parseNode;
    }

    public String getInput() {
        return this.input;
    }

    public synchronized List<LexerToken> getSrc() {
        if (this.src == null) {
            this.src = LexerToken.parse(this.input);
        }
        return this.src;
    }

    public Matrix getMatrix() {
        this.getRoot();
        return this.matrix;
    }

    public synchronized ParseNode getRoot() {
        this.getSrc();
        if (this.root == null) {
            Visual visual = null;
            if (this.debug) {
                visual = new Visual(this.src, this.earley);
            }
            this.matrix = new Matrix(this.earley);
            this.earley.parse(this.src, this.matrix);
            if (this.debug) {
                visual.draw(this.matrix);
            }
            if (this.rootSyntax != null) {
                this.err = SyntaxError.checkSyntax(this.input, new String[]{this.rootSyntax}, this.src, this.earley, this.matrix);
                if (this.err != null) {
                    throw this.err;
                }
            }
            this.root = this.earley.forest(this.src, this.matrix);
        }
        return this.root;
    }

    public SyntaxError getSyntaxError() {
        if (this.err != null) {
            return this.err;
        }
        this.getRoot();
        return this.err;
    }

    public static void main(String[] stringArray) throws Exception {
        Parsed parsed = new Parsed(Service.readFile(Parsed.class, "xml.grammar"), Grammar.bnfParser(), "grammar");
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar(parsed.getRoot(), parsed.getSrc(), treeSet);
        String string = Service.readFile(Parsed.class, "test.html");
        Earley earley = new Earley(treeSet){

            @Override
            protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                LexerToken lexerToken = list.get(n);
                return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
            }
        };
        Parsed parsed2 = new Parsed(string, earley, "nodes");
        Parsed parsed3 = new Parsed(Service.readFile(Parsed.class, "htmltable.prg"), Program.getArboriParser(), "program");
        Program program = new Program(earley){};
        program.program(parsed3.getRoot(), parsed3.getSrc(), parsed3.getInput());
        parsed2.getRoot();
        long l = System.currentTimeMillis();
        Map<String, MaterializedPredicate> map = program.eval(parsed2);
        for (String string2 : map.keySet()) {
            System.out.println(string2 + "=" + map.get(string2).toString(string2.length() + 1));
        }
        System.out.println("\n *********** eval time =" + (System.currentTimeMillis() - l) + "\n");
    }
}

