/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.common.TranslatableMessage;
import oracle.dbtools.data.loadservice.DataLoadException;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.loadservice.LoadResources;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.Table;
import oracle.dbtools.data.readservice.ReadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.data.readservice.ReadService;
import oracle.dbtools.data.readservice.ReadServiceDelimited;
import oracle.dbtools.db.DBUtil;

public abstract class LoadService {
    protected final String ENCODING = "UTF-8";
    protected final String LINE_TERM = "\n";
    private final String INFO_PREFIX_SQL = "--";
    private final String ERROR_PREFIX_SQL = "--";
    private String INFO_PREFIX_RAW;
    private String ERROR_PREFIX_RAW;
    private Connection _conn;
    private String _schemaName;
    private String _tableName;
    private OutputStreamWriter _responseWriter;
    private LoadParmsAPI _loadParms;
    private ReadParmsAPI _readerParms;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private boolean CANCELLED;
    private boolean _connLocked = false;
    private boolean _isConnAutoCommit;
    private boolean _isDoCommit;
    private ReadService _reader;
    private Table _table;
    private int _errorRowsCount;
    private int _processedRowsCount;
    private ExitCode _exitCode = ExitCode.EXIT_SUCCESS;
    private static final long START_TIME = System.nanoTime();

    private static String formatInterval(long l) {
        long l2 = TimeUnit.NANOSECONDS.toHours(l);
        long l3 = TimeUnit.NANOSECONDS.toMinutes(l - TimeUnit.HOURS.toNanos(l2));
        long l4 = TimeUnit.NANOSECONDS.toSeconds(l - TimeUnit.HOURS.toNanos(l2) - TimeUnit.MINUTES.toNanos(l3));
        long l5 = TimeUnit.NANOSECONDS.toMillis(l - TimeUnit.HOURS.toNanos(l2) - TimeUnit.MINUTES.toNanos(l3) - TimeUnit.SECONDS.toNanos(l4));
        return String.format("%02d:%02d:%02d.%03d", l2, l3, l4, l5);
    }

    ExitCode start(Connection connection, String string, String string2, InputStream inputStream, OutputStream outputStream, LoadParmsAPI loadParmsAPI, ReadParmsAPI readParmsAPI, Logger logger) {
        this._conn = connection;
        this._schemaName = string;
        this._tableName = string2;
        this._loadParms = loadParmsAPI;
        this._readerParms = readParmsAPI;
        this.LOGGER = logger;
        this.INFO_PREFIX_RAW = "#" + this.translate("INFO") + " ";
        this.ERROR_PREFIX_RAW = "#" + this.translate("ERROR") + " ";
        this.LOGGER.log(Level.INFO, LoadResources.getString("LOAD_START"));
        this._isDoCommit = this.getLoadParms().isDoCommit();
        try {
            this._responseWriter = new OutputStreamWriter(outputStream, this._loadParms.getResponseEncoding());
            if (readParmsAPI == null || !(readParmsAPI instanceof ReadParmsDelimitedAPI)) {
                String string3 = this.translate("READER_START_ERR", new Object[]{readParmsAPI.getServiceType().toString()});
                throw new DataLoadException(string3, ExitCode.EXIT_SEVERE);
            }
            this._reader = new ReadServiceDelimited(inputStream, (ReadParmsDelimitedAPI)readParmsAPI, loadParmsAPI.getResponseLocales());
            this.initConnection();
            GenericTable genericTable = new GenericTable(this.getConnection(), this.getSchemaName(), this.getTableName());
            this._table = genericTable.getTable();
            if (this._table == null) {
                String string4 = this._schemaName == null || this._schemaName.length() == 0 ? this._tableName : this._schemaName + "." + this._tableName;
                String string5 = this.translate("TABLE_NOT_EXIST", new Object[]{string4});
                throw new DataLoadException(string5, ExitCode.EXIT_SEVERE);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string6 = this.translate("RESPONSE_START_ERR");
            this.responseErrorMsg(new String[]{string6, unsupportedEncodingException.getMessage()});
            this.LOGGER.log(Level.SEVERE, LoadResources.getString("RESPONSE_START_ERR") + " " + unsupportedEncodingException.getMessage());
            this._exitCode = ExitCode.EXIT_SEVERE;
        }
        catch (SQLException sQLException) {
            String string7 = this.translate("CONNECTION_ERR");
            this.responseErrorMsg(new String[]{string7, sQLException.getMessage()});
            this.LOGGER.log(Level.SEVERE, string7 + " " + sQLException.getMessage());
            this._exitCode = ExitCode.EXIT_SEVERE;
        }
        catch (DataLoadException dataLoadException) {
            this.responseErrorMsg(new String[]{dataLoadException.getMessage()});
            this.LOGGER.log(Level.SEVERE, dataLoadException.getMessage());
            this._exitCode = dataLoadException.getExitCode();
        }
        if (this._exitCode.equals((Object)ExitCode.EXIT_SEVERE)) {
            this.signalCancel();
            this.finish();
        }
        return this._exitCode;
    }

    abstract String getType();

    ExitCode load() {
        this.doLoad();
        String[] stringArray = new String[]{this.translate("STAT_ROWS_PROCESSED", new Object[]{this._processedRowsCount}), this.translate("STAT_ROWS_ERROR", new Object[]{this._errorRowsCount})};
        this.responseInfoMsg(stringArray);
        this.finish();
        return this._exitCode;
    }

    protected abstract void doLoad();

    protected final Connection getConnection() {
        return this._conn;
    }

    protected final String translate(String string, Object[] objectArray) {
        if (this._loadParms.getResponseLocales() == null) {
            return LoadResources.format(string, objectArray);
        }
        return new TranslatableMessage(LoadResources.class, string, LoadResources.format(string, objectArray), objectArray).toString(this._loadParms.getResponseLocales());
    }

    protected final String translate(String string) {
        if (this._loadParms.getResponseLocales() == null) {
            return LoadResources.getString(string);
        }
        return new TranslatableMessage(LoadResources.class, string, LoadResources.getString(string), new Object[0]).toString(this._loadParms.getResponseLocales());
    }

    protected final Logger getLogger() {
        return this.LOGGER;
    }

    protected final String getSchemaName() {
        return this._schemaName;
    }

    protected final String getTableName() {
        return this._tableName;
    }

    protected final Table getTable() {
        return this._table;
    }

    protected final ReadService getReader() {
        return this._reader;
    }

    protected final ReadParmsAPI getReaderParms() {
        return this._readerParms;
    }

    protected final LoadParmsAPI getLoadParms() {
        return this._loadParms;
    }

    protected String getColumnName(String string) {
        if (this._loadParms.getAliasToColumnMap() == null || this._loadParms.getAliasToColumnMap().size() == 0) {
            return string;
        }
        String string2 = this._loadParms.getAliasToColumnMap().get(string);
        return string2 == null || string2.length() == 0 ? string : string2;
    }

    protected long getElapsedTime() {
        return (System.nanoTime() - START_TIME) / 1000000L;
    }

    protected final void responseWrite(String string) {
        try {
            if (this._responseWriter != null) {
                this._responseWriter.write(string + "\n");
            }
        }
        catch (IOException iOException) {
            this.LOGGER.log(Level.SEVERE, iOException.getMessage());
        }
    }

    protected final void addRowsProcessed() {
        ++this._processedRowsCount;
    }

    protected final void addRowsError() {
        ++this._errorRowsCount;
    }

    protected void responseInfoMsg(String[] stringArray) {
        String string = this.getLoadParms().isResponseFormatRaw() ? this.INFO_PREFIX_RAW : "--";
        for (int i = 0; i < stringArray.length; ++i) {
            this.responseWrite(string + stringArray[i]);
        }
    }

    protected void responseErrorMsg(String[] stringArray) {
        String string = this.getLoadParms().isResponseFormatRaw() ? this.ERROR_PREFIX_RAW : "--";
        for (int i = 0; i < stringArray.length; ++i) {
            this.responseWrite(string + stringArray[i]);
        }
    }

    protected final boolean checkCanProceed() {
        if (this._loadParms.isErrorsLimited() && this._errorRowsCount > this._loadParms.getErrorsLimit()) {
            this.CANCELLED = true;
            this._exitCode = ExitCode.EXIT_ERROR;
        }
        return !this.CANCELLED;
    }

    protected final void setExitCodeHighest(ExitCode exitCode) {
        if (exitCode.getSeverity() > this._exitCode.getSeverity()) {
            this._exitCode = exitCode;
        }
    }

    protected final boolean isCancelled() {
        return this.CANCELLED;
    }

    public void signalCancel() {
        this.CANCELLED = true;
    }

    private void initConnection() throws SQLException {
        this._isConnAutoCommit = this._conn.getAutoCommit();
        this._connLocked = DBUtil.getConnectionResolver().lock(this._conn);
        if (!this._connLocked) {
            this._exitCode = ExitCode.EXIT_SEVERE;
            this.signalCancel();
        } else if (this._isConnAutoCommit) {
            this._conn.setAutoCommit(false);
        }
    }

    protected void finish() {
        this.responseWrite(this._exitCode.toStringTranslated(this._loadParms.getResponseLocales()));
        if (this.CANCELLED) {
            this.rollbackConn();
        } else {
            this.commitConn();
        }
        this.resetConn();
        if (this._reader != null) {
            this._reader.close();
        }
        try {
            if (this._responseWriter != null) {
                this._responseWriter.close();
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void rollbackConn() {
        try {
            if (!this._conn.isClosed() && this._connLocked) {
                this._conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            this.LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            this._exitCode = ExitCode.EXIT_SEVERE;
        }
        this.signalCancel();
    }

    protected void commitConn() {
        try {
            if (this._connLocked && this._isDoCommit) {
                this._conn.commit();
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this.signalCancel();
        }
    }

    private void resetConn() {
        try {
            if (this._isConnAutoCommit && this._connLocked) {
                this._conn.setAutoCommit(this._isConnAutoCommit);
                this._connLocked = false;
                DBUtil.getConnectionResolver().unlock(this._conn);
            } else if (this._connLocked) {
                DBUtil.getConnectionResolver().unlock(this._conn);
            }
        }
        catch (SQLException sQLException) {
            this.LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this.signalCancel();
        }
    }
}

