/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class Version
implements Comparable<Version> {
    private static final Map<String, int[]> _convertCache = new HashMap<String, int[]>(100);
    private final int[] _numbers;
    private final String _versionLabel;

    public Version(String string) throws NumberFormatException {
        this._versionLabel = string;
        this._numbers = this.convert(string);
    }

    public Version(int[] nArray) {
        this._numbers = nArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(String.valueOf(nArray[i]));
        }
        this._versionLabel = stringBuffer.toString();
    }

    public int[] toIntArray() {
        int[] nArray = new int[this._numbers.length];
        System.arraycopy(this._numbers, 0, nArray, 0, this._numbers.length);
        return nArray;
    }

    @Override
    public int compareTo(Version version) {
        if (this == version) {
            return 0;
        }
        int[] nArray = version._numbers;
        int n = this._numbers.length;
        int n2 = nArray.length;
        int n3 = Math.max(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = i < n ? this._numbers[i] : 0;
            int n6 = n4 = i < n2 ? nArray[i] : 0;
            if (n5 == n4) continue;
            return n5 - n4;
        }
        return 0;
    }

    public String toString() {
        return this._versionLabel;
    }

    public String toCanonicalString() {
        int n = this._numbers.length;
        StringBuffer stringBuffer = new StringBuffer(n * 3).append(this._numbers[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append('.');
            stringBuffer.append(this._numbers[i]);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        int n = this._numbers.length;
        if (n != version._numbers.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this._numbers[i] == version._numbers[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 925295;
        int n2 = this._numbers.length;
        for (int i = 0; i < n2; ++i) {
            n = 37 * n + i;
        }
        return n;
    }

    private int[] convert(String string) throws NumberFormatException {
        int[] nArray = _convertCache.get(string);
        if (nArray != null) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        int n = stringTokenizer.countTokens() + 1;
        if (n % 2 != 0) {
            throw new NumberFormatException(" Malformed version specification: `" + string + "`.");
        }
        nArray = new int[n / 2];
        boolean bl = true;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
                int n3 = Integer.parseInt(string2);
                if (n3 < 0) {
                    throw new NumberFormatException("Malformed version specification: `" + n3 + "`." + "Version number must be > 0.");
                }
                nArray[n2++] = n3;
                continue;
            }
            bl = true;
        }
        return nArray;
    }
}

