/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

class PredRef
implements Predicate {
    String name;
    Program program;

    public PredRef(String string, Program program) {
        this.name = string;
        this.program = program;
    }

    @Override
    public boolean eval(Map<String, ParseNode> map, List<LexerToken> list) {
        Predicate predicate = this.program.namedPredicates.get(this.name);
        if (predicate == null) {
            throw new AssertionError((Object)("Unreferenced predicate variable " + this.name));
        }
        if (!(predicate instanceof MaterializedPredicate)) {
            throw new AssertionError((Object)("Unevaluated predicate variable " + this.name));
        }
        return predicate.eval(map, list);
    }

    @Override
    public String toString(int n) {
        return "->" + this.name;
    }

    @Override
    public void variables(Set<String> set, boolean bl) {
        Predicate predicate = this.program.namedPredicates.get(this.name);
        predicate.variables(set, bl);
    }

    @Override
    public MaterializedPredicate eval(Parsed parsed) {
        Predicate predicate = this.program.namedPredicates.get(this.name);
        if (predicate == null) {
            throw new AssertionError((Object)("Unreferenced predicate variable " + this.name));
        }
        if (!(predicate instanceof MaterializedPredicate)) {
            throw new AssertionError((Object)("Unevaluated predicate variable " + this.name));
        }
        return predicate.eval(parsed);
    }

    @Override
    public Predicate isRelated(String string, String string2, Map<String, Attribute> map) {
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put(this.name, true);
        return hashMap;
    }
}

