/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import oracle.dbtools.app.Rewrite;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;

public class SqlId
extends Rewrite {
    private String prefix = " ";
    private int sqlCnt = 0;
    private int changeCnt = 0;

    public SqlId(String string, Set<String> set) {
        super(set);
        this.prefix = string;
    }

    private static List<Integer> getInsertionsPoints(LazyNode lazyNode, List<LexerToken> list) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if ("insert".equalsIgnoreCase(lazyNode.startToken) || "update".equalsIgnoreCase(lazyNode.startToken) || "delete".equalsIgnoreCase(lazyNode.startToken) || "select".equalsIgnoreCase(lazyNode.startToken) || "with".equalsIgnoreCase(lazyNode.startToken) || "merge".equalsIgnoreCase(lazyNode.startToken)) {
            linkedList.add(lazyNode.from);
        } else if ("cursor".equalsIgnoreCase(lazyNode.startToken) || "for".equalsIgnoreCase(lazyNode.startToken)) {
            int n = -1;
            int n2 = lazyNode.from;
            int n3 = lazyNode.to;
            if ("for".equalsIgnoreCase(lazyNode.startToken)) {
                int n4 = -1;
                for (LazyNode lazyNode2 : lazyNode.shallowChildren()) {
                    if (++n4 == 0) {
                        n2 = lazyNode2.from;
                        n3 = lazyNode2.to;
                        continue;
                    }
                    linkedList.addAll(SqlId.getInsertionsPoints(lazyNode2, list));
                }
            }
            for (LexerToken lexerToken : list) {
                if (++n >= n3) break;
                if (n < n2 || !"select".equalsIgnoreCase(lexerToken.content)) continue;
                linkedList.add(n);
                break;
            }
        } else {
            for (LazyNode lazyNode3 : lazyNode.shallowChildren()) {
                linkedList.addAll(SqlId.getInsertionsPoints(lazyNode3, list));
            }
        }
        return linkedList;
    }

    @Override
    public String transform(String string, List<LexerToken> list, LazyNode lazyNode) {
        String string2 = " /* " + this.prefix;
        List<Integer> list2 = SqlId.getInsertionsPoints(lazyNode, list);
        int n = -1;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (LexerToken lexerToken : list) {
            if (!list2.contains(++n)) continue;
            ++this.sqlCnt;
            if (string2.equals(string.substring(lexerToken.end, lexerToken.end + string2.length()))) continue;
            stringBuilder.append(string.substring(n2, lexerToken.end));
            n2 = lexerToken.end;
            stringBuilder.append(string2 + UUID.randomUUID().toString().substring(0, 6) + " */ ");
            ++this.changeCnt;
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    @Override
    protected String found() {
        return "found " + this.sqlCnt + " statements, ";
    }

    @Override
    protected String changed() {
        return "stamped " + this.changeCnt + " of them";
    }
}

