/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.util.Filter;

public final class CollectionUtils {
    public static final int ASSUME_UNMODIFIABLE = 0;
    public static final int ASSUME_MODIFIABLE = 1;
    public static final int RETURN_EXACT_RESULT = 2;
    private static final Object _COLLECTION_CONTENT = new Object();
    private static final Map _SINGLETON_MAP = Collections.singletonMap(_COLLECTION_CONTENT, _COLLECTION_CONTENT);
    private static final Set _SINGLETON_SET = Collections.singleton(_COLLECTION_CONTENT);
    private static final Class _SINGLETON_LIST_CLASS = Collections.singletonList(_COLLECTION_CONTENT).getClass();
    private static final Class _SINGLETON_MAP_CLASS = _SINGLETON_MAP.getClass();
    private static final Class _SINGLETON_SET_CLASS = _SINGLETON_SET.getClass();
    private static final Class _UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(new LinkedList()).getClass();
    private static final Class _UNMODIFIABLE_MAP_CLASS = Collections.unmodifiableMap(_SINGLETON_MAP).getClass();
    private static final Class _UNMODIFIABLE_SET_CLASS = Collections.unmodifiableSet(_SINGLETON_SET).getClass();
    private static final Class _ARRAY_LIST_CLASS = new ArrayList(0).getClass();
    private static final Class _LINKED_LIST_CLASS = new LinkedList().getClass();
    private static final Class _HASH_MAP_CLASS = new HashMap(0).getClass();
    private static final Class _IDENTITY_HASH_MAP_CLASS = new IdentityHashMap(0).getClass();
    private static final Class _LINKED_HASH_MAP_CLASS = new LinkedHashMap(0).getClass();
    private static final Class _TREE_MAP_CLASS = new TreeMap().getClass();
    private static final Class _HASH_SET_CLASS = new HashSet(0).getClass();
    private static final Class _LINKED_HASH_SET_CLASS = new LinkedHashSet(0).getClass();
    private static final Class _TREE_SET_CLASS = new TreeSet().getClass();

    public static List makeListOfLists(List inList) {
        int itemCount = inList.size();
        for (int i = 0; i < itemCount; ++i) {
            inList.set(i, Collections.singletonList(inList.get(i)));
        }
        return inList;
    }

    public static List makeListOfLists(List inList, List prependList) {
        if (prependList == null || prependList.size() == 0) {
            return CollectionUtils.makeListOfLists(inList);
        }
        int newlistSize = prependList.size() + 1;
        int itemCount = inList.size();
        for (int i = 0; i < itemCount; ++i) {
            ArrayList newList = new ArrayList(newlistSize);
            newList.addAll(prependList);
            newList.add(inList.get(i));
            inList.set(i, newList);
        }
        return inList;
    }

    public static boolean isUnmodifiableList(List list, int defaultAnswer) {
        if (list == null) {
            return false;
        }
        Class<?> listClass = list.getClass();
        if (listClass == _ARRAY_LIST_CLASS || listClass == _LINKED_LIST_CLASS) {
            return false;
        }
        if (listClass == Collections.EMPTY_LIST.getClass() || _SINGLETON_LIST_CLASS.isInstance(list) || _UNMODIFIABLE_LIST_CLASS.isInstance(list)) {
            return true;
        }
        switch (defaultAnswer) {
            default: {
                try {
                    list.add(_COLLECTION_CONTENT);
                    list.remove(list.size() - 1);
                    return false;
                }
                catch (UnsupportedOperationException e) {
                    return true;
                }
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    public static boolean isUnmodifiableMap(Map map, int defaultAnswer) {
        if (map == null) {
            return false;
        }
        Class<?> mapClass = map.getClass();
        if (mapClass == _HASH_MAP_CLASS || mapClass == _TREE_MAP_CLASS || mapClass == _LINKED_HASH_MAP_CLASS || mapClass == _IDENTITY_HASH_MAP_CLASS) {
            return false;
        }
        if (mapClass == Collections.EMPTY_MAP.getClass() || _SINGLETON_MAP_CLASS.isInstance(map) || _UNMODIFIABLE_MAP_CLASS.isInstance(map)) {
            return true;
        }
        switch (defaultAnswer) {
            default: {
                try {
                    map.put(_COLLECTION_CONTENT, _COLLECTION_CONTENT);
                    map.remove(_COLLECTION_CONTENT);
                    return false;
                }
                catch (UnsupportedOperationException e) {
                    return true;
                }
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    public static boolean isUnmodifiableSet(Set set, int defaultAnswer) {
        if (set == null) {
            return false;
        }
        Class<?> setClass = set.getClass();
        if (setClass == _HASH_SET_CLASS || setClass == _LINKED_HASH_SET_CLASS || setClass == _TREE_SET_CLASS) {
            return false;
        }
        if (setClass == Collections.EMPTY_SET.getClass() || _SINGLETON_SET_CLASS.isInstance(set) || _UNMODIFIABLE_SET_CLASS.isInstance(set)) {
            return true;
        }
        switch (defaultAnswer) {
            default: {
                try {
                    set.add(_COLLECTION_CONTENT);
                    set.remove(_COLLECTION_CONTENT);
                    return false;
                }
                catch (UnsupportedOperationException e) {
                    return true;
                }
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    public static <T> List<T> createUnmodifiableList(List<T> list) {
        if (list == null) {
            return null;
        }
        int listSize = list.size();
        if (listSize > 1) {
            if (CollectionUtils.isUnmodifiableList(list, 1)) {
                return list;
            }
            return Collections.unmodifiableList(list);
        }
        if (listSize == 1) {
            return Collections.singletonList(list.get(0));
        }
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> createUnmodifiableMap(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        int mapSize = map.size();
        if (mapSize >= 1) {
            if (CollectionUtils.isUnmodifiableMap(map, 1)) {
                return map;
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    public static <T> Set<T> createUnmodifiableSet(Set<T> set) {
        if (set == null) {
            return null;
        }
        int setSize = set.size();
        if (setSize > 1) {
            if (CollectionUtils.isUnmodifiableSet(set, 1)) {
                return set;
            }
            return Collections.unmodifiableSet(set);
        }
        if (setSize == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.emptySet();
    }

    public static <T> Set<T> mergeAddRemoveSets(Set<T> baseSet, Set<T> addSet, Set<T> removeSet) {
        boolean hasBaseSet;
        boolean bl = hasBaseSet = baseSet != null && !baseSet.isEmpty();
        if (removeSet == null || removeSet.isEmpty()) {
            if (hasBaseSet) {
                baseSet.addAll(addSet);
            } else {
                baseSet = addSet;
            }
        } else {
            if (!hasBaseSet) {
                baseSet = new HashSet<T>((int)((double)addSet.size() * 1.5));
            }
            for (T currNode : addSet) {
                if (removeSet.remove(currNode)) continue;
                baseSet.add(currNode);
            }
        }
        return baseSet;
    }

    public static <T> void computeAddRemoveSets(Collection<T> oldSet, Collection<T> newSet, Set<T> outAddedSet, Set<T> outRemovedSet) {
        outAddedSet.addAll(newSet);
        outAddedSet.removeAll(oldSet);
        outRemovedSet.addAll(oldSet);
        outRemovedSet.removeAll(newSet);
    }

    public static <T> T[] toArray(Class<T> clazz, Collection<? extends T> collection, Filter<? super T> predicate) {
        T[] ret = CollectionUtils.createArray(clazz, collection.size());
        if (predicate == null) {
            return collection.toArray(ret);
        }
        int origSize = collection.size();
        int i = 0;
        for (T item : collection) {
            if (!predicate.matches(item)) continue;
            ret[i] = item;
            ++i;
        }
        if (i == origSize) {
            return ret;
        }
        assert (i < origSize);
        T[] smaller = CollectionUtils.createArray(clazz, i);
        System.arraycopy(ret, 0, smaller, 0, i);
        return smaller;
    }

    public static Object[] createArray(Object[] prototype, int size) {
        return (Object[])Array.newInstance(prototype.getClass().getComponentType(), size);
    }

    public static <T> T[] createArray(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    private CollectionUtils() {
    }
}

