/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import oracle.maps.core.MapUndoManager;
import oracle.maps.geoobject.AbstractFeature;
import oracle.mapviewer.share.Field;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.EditChangeEvent;

public class EditChangeManager {
    private AbstractDataSet dataSet = null;
    private Hashtable<String, AbstractFeature> cachedFeatures = null;
    private Hashtable<String, String> newFeatures = new Hashtable();
    private Hashtable<String, String> removedFeatures = new Hashtable();
    private Hashtable<String, String> modifiedFeatures = new Hashtable();
    private Hashtable<String, Vector<EditChangeEvent>> updateChanges = new Hashtable();
    private Hashtable<String, Integer> changeBlocks = new Hashtable();
    private int changeStart = -1;
    private boolean holdLayerUpdate = false;

    public EditChangeManager(Hashtable<String, AbstractFeature> features, AbstractDataSet dataSet) {
        this.cachedFeatures = features;
        this.dataSet = dataSet;
    }

    public void setFeatures(Hashtable<String, AbstractFeature> features) {
        this.clearChanges();
        this.cachedFeatures = features;
    }

    public void clearChanges() {
        this.newFeatures.clear();
        this.removedFeatures.clear();
        this.modifiedFeatures.clear();
        this.updateChanges.clear();
        this.changeBlocks.clear();
    }

    public AbstractFeature getFeature(String key) {
        if (key == null || this.cachedFeatures == null) {
            return null;
        }
        return this.cachedFeatures.get(key);
    }

    public boolean removeFeature(String key) throws Exception {
        if (key == null) {
            throw new Exception("key is null");
        }
        AbstractFeature old = this.cachedFeatures.remove(key);
        if (old == null) {
            throw new Exception("feature was not in cache");
        }
        boolean isNew = false;
        boolean isModified = false;
        if (this.isNewFeature(key)) {
            isNew = true;
            this.newFeatures.remove(key);
        } else {
            this.removedFeatures.put(key, key);
            if (this.isModifiedFeature(key)) {
                this.modifiedFeatures.remove(key);
                isModified = true;
            }
        }
        EditChangeEvent change = new EditChangeEvent(EditChangeEvent.REMOVE_EVENT, EditChangeEvent.NO_UPDATE, key, null, old, isNew, isModified);
        AbstractDataSetLayer layer = this.dataSet.getIndexedSet().getDataSetLayer();
        MapUndoManager um = layer.getCanvas().getUndoManager();
        um.undoableEditHappened(new UndoableEditEvent(this, new DataSetUndoableEdit(layer, change)));
        if (!this.holdLayerUpdate) {
            layer.setToUpdate();
        }
        return true;
    }

    public boolean addFeature(String key, AbstractFeature feature) throws Exception {
        if (key == null || feature == null) {
            throw new Exception("The key or the feature is null");
        }
        this.newFeatures.put(key, key);
        this.cachedFeatures.put(key, feature);
        EditChangeEvent change = new EditChangeEvent(EditChangeEvent.NEW_EVENT, EditChangeEvent.NO_UPDATE, key, feature, null, true, false);
        AbstractDataSetLayer layer = this.dataSet.getIndexedSet().getDataSetLayer();
        MapUndoManager um = layer.getCanvas().getUndoManager();
        um.undoableEditHappened(new UndoableEditEvent(this, new DataSetUndoableEdit(layer, change)));
        if (!this.holdLayerUpdate) {
            layer.setToUpdate();
        }
        return true;
    }

    public boolean updateFeature(String key, Object newObject, int updateType) throws Exception {
        if (key == null || newObject == null) {
            throw new Exception("key or newobject is null");
        }
        AbstractFeature currentFeature = this.cachedFeatures.get(key);
        if (currentFeature == null) {
            throw new Exception("current feature is null");
        }
        Field[] currentObject = null;
        if (updateType == EditChangeEvent.SPATIAL_UPDATE) {
            currentObject = currentFeature.getSpatialAttribute();
            currentFeature.setSpatialAttribute(newObject);
        } else if (updateType == EditChangeEvent.ATTRIBUTE_UPDATE) {
            Field[] fields = (Field[])newObject;
            String[] names = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                names[i] = fields[i].getName();
            }
            currentObject = currentFeature.getAttributes(names);
            currentFeature.setAttributes(fields);
        } else {
            throw new Exception("Unknown edit update type");
        }
        boolean isNew = false;
        boolean isModified = false;
        if (!this.isNewFeature(key)) {
            if (this.isModifiedFeature(key)) {
                isModified = true;
            }
            this.modifiedFeatures.put(key, key);
        } else {
            isNew = true;
            this.newFeatures.put(key, key);
        }
        EditChangeEvent change = new EditChangeEvent(EditChangeEvent.UPDATE_EVENT, updateType, key, newObject, currentObject, isNew, isModified);
        AbstractDataSetLayer layer = this.dataSet.getIndexedSet().getDataSetLayer();
        MapUndoManager um = layer.getCanvas().getUndoManager();
        um.undoableEditHappened(new UndoableEditEvent(this, new DataSetUndoableEdit(layer, change)));
        if (!isNew) {
            Vector<EditChangeEvent> upv = this.updateChanges.get(key);
            if (upv == null) {
                upv = new Vector();
                this.updateChanges.put(key, upv);
            }
            upv.add(change);
        }
        if (!this.holdLayerUpdate) {
            layer.setToUpdate();
        }
        return true;
    }

    public boolean isNewFeature(String key) {
        if (key == null) {
            return false;
        }
        return this.newFeatures.get(key) != null;
    }

    public String[] getNewFeatures() {
        if (this.newFeatures.size() == 0) {
            return null;
        }
        ArrayList<String> feats = new ArrayList<String>();
        Enumeration<String> e = this.newFeatures.keys();
        while (e.hasMoreElements()) {
            feats.add(e.nextElement());
        }
        if (feats.size() == 0) {
            return null;
        }
        return feats.toArray(new String[feats.size()]);
    }

    public boolean isRemovedFeature(String key) {
        if (key == null) {
            return false;
        }
        return this.removedFeatures.get(key) != null;
    }

    public String[] getRemovedFeatures() {
        if (this.removedFeatures.size() == 0) {
            return null;
        }
        ArrayList<String> feats = new ArrayList<String>();
        Enumeration<String> e = this.removedFeatures.keys();
        while (e.hasMoreElements()) {
            feats.add(e.nextElement());
        }
        return feats.toArray(new String[feats.size()]);
    }

    public String[] getModifiedFeatures() {
        if (this.modifiedFeatures.size() == 0) {
            return null;
        }
        ArrayList<String> feats = new ArrayList<String>();
        Enumeration<String> e = this.modifiedFeatures.keys();
        while (e.hasMoreElements()) {
            feats.add(e.nextElement());
        }
        return feats.toArray(new String[feats.size()]);
    }

    public boolean isModifiedFeature(String key) {
        if (key == null) {
            return false;
        }
        return this.modifiedFeatures.get(key) != null;
    }

    public boolean hasChanges() {
        return this.modifiedFeatures.size() > 0 || this.newFeatures.size() > 0 || this.removedFeatures.size() > 0;
    }

    public void undo(EditChangeEvent change) {
        if (change == null) {
            return;
        }
        String key = change.getKey();
        int eventType = change.getEventType();
        if (eventType == EditChangeEvent.NEW_EVENT) {
            this.cachedFeatures.remove(key);
            this.newFeatures.remove(key);
        } else if (eventType == EditChangeEvent.UPDATE_EVENT) {
            AbstractFeature feature = this.cachedFeatures.get(key);
            if (feature == null) {
                return;
            }
            int updateType = change.getUpdateType();
            if (updateType == EditChangeEvent.SPATIAL_UPDATE) {
                feature.setSpatialAttribute(change.getOldObject());
            } else if (updateType == EditChangeEvent.ATTRIBUTE_UPDATE) {
                Field[] fields = (Field[])change.getOldObject();
                feature.setAttributes(fields);
            }
            if (!change.isNewFeature()) {
                Vector<EditChangeEvent> upv = this.updateChanges.get(key);
                if (upv != null && upv.size() > 0) {
                    upv.remove(upv.size() - 1);
                    if (upv.size() == 0) {
                        this.updateChanges.remove(key);
                    }
                }
                if (!change.isModifiedFeature()) {
                    this.modifiedFeatures.remove(key);
                }
            }
        } else if (eventType == EditChangeEvent.REMOVE_EVENT) {
            AbstractFeature feat = (AbstractFeature)change.getOldObject();
            this.cachedFeatures.put(key, feat);
            if (!change.isNewFeature()) {
                this.removedFeatures.remove(key);
                if (change.isModifiedFeature()) {
                    this.modifiedFeatures.put(key, key);
                }
            } else {
                this.newFeatures.put(key, key);
            }
        }
    }

    public void redo(EditChangeEvent change) {
        if (change == null) {
            return;
        }
        String key = change.getKey();
        int eventType = change.getEventType();
        if (eventType == EditChangeEvent.NEW_EVENT) {
            this.newFeatures.put(key, key);
            this.cachedFeatures.put(key, (AbstractFeature)change.getCurrentObject());
        } else if (eventType == EditChangeEvent.UPDATE_EVENT) {
            AbstractFeature feature = this.cachedFeatures.get(key);
            if (feature == null) {
                return;
            }
            int updateType = change.getUpdateType();
            if (updateType == EditChangeEvent.SPATIAL_UPDATE) {
                feature.setSpatialAttribute(change.getCurrentObject());
            } else if (updateType == EditChangeEvent.ATTRIBUTE_UPDATE) {
                Field[] fields = (Field[])change.getCurrentObject();
                feature.setAttributes(fields);
            }
            if (!change.isNewFeature()) {
                Vector<EditChangeEvent> upv = this.updateChanges.get(key);
                if (upv == null) {
                    upv = new Vector();
                    this.updateChanges.put(key, upv);
                }
                upv.add(change);
                if (!change.isModifiedFeature()) {
                    this.modifiedFeatures.put(key, key);
                }
            } else {
                this.newFeatures.put(key, key);
            }
        } else if (eventType == EditChangeEvent.REMOVE_EVENT) {
            AbstractFeature feat = (AbstractFeature)change.getOldObject();
            this.cachedFeatures.put(key, feat);
            if (!change.isNewFeature()) {
                this.removedFeatures.put(key, key);
                if (change.isModifiedFeature()) {
                    this.modifiedFeatures.remove(key);
                }
            } else {
                this.newFeatures.remove(key);
            }
        }
    }

    public boolean hasSpatialAttributeChanged(String key) {
        if (key == null) {
            return false;
        }
        if (!this.isModifiedFeature(key)) {
            return false;
        }
        Vector<EditChangeEvent> upv = this.updateChanges.get(key);
        if (upv == null || upv.size() == 0) {
            return false;
        }
        for (int i = 0; i < upv.size(); ++i) {
            EditChangeEvent edv = upv.get(i);
            if (edv.getUpdateType() != EditChangeEvent.SPATIAL_UPDATE) continue;
            return true;
        }
        return false;
    }

    public String[] getChangedAttributesOfModifiedFeature(String key) {
        if (key == null) {
            return null;
        }
        if (!this.isModifiedFeature(key)) {
            return null;
        }
        Vector<EditChangeEvent> upv = this.updateChanges.get(key);
        if (upv == null || upv.size() == 0) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < upv.size(); ++i) {
            Field[] fields;
            EditChangeEvent edv = upv.get(i);
            if (edv.getUpdateType() != EditChangeEvent.ATTRIBUTE_UPDATE || (fields = (Field[])edv.getCurrentObject()) == null || fields.length <= 0) continue;
            for (int k = 0; k < fields.length; ++k) {
                Field field = fields[k];
                if (field == null || names.contains(field.getName())) continue;
                names.add(field.getName());
            }
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public void setHoldLayerUpdate(boolean holdLayerUpdate) {
        this.holdLayerUpdate = holdLayerUpdate;
    }

    public boolean isHoldLayerUpdate() {
        return this.holdLayerUpdate;
    }

    private class DataSetUndoableEdit
    extends AbstractUndoableEdit {
        private AbstractDataSetLayer layer = null;
        private EditChangeEvent change = null;

        public DataSetUndoableEdit(AbstractDataSetLayer layer, EditChangeEvent change) {
            this.layer = layer;
            this.change = change;
        }

        @Override
        public String getPresentationName() {
            if (this.change != null) {
                return this.change.getDescriptionString();
            }
            return "DataSet change";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.layer.undo(this.change);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                this.layer.redo(this.change);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CannotRedoException();
            }
        }
    }
}

