/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.layer;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.GeoObject;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SnappableLayer;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.graphics.ShadowRenderer;
import oracle.maps.util.RenderUtils;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.geometry.GeometrySet;
import oracle.spatial.edit.producer.GeometrySetProducer;
import oracle.spatial.edit.ui.GeometryLayerPropertyPanel;
import oracle.spatial.geometry.JGeometry;
import org.w3c.dom.Element;

public class GeometrySetLayer
extends AbstractDataSetLayer
implements SnappableLayer,
ConfigurableLayer {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    public static final String PROPERTY_SHAREBOUNDARY = "oracle.spatial.edit.layer.GeometrySetLayer.shareboundary";
    public static final String PROPERTY_POLYGON_OUTER_RING_ORIENTATION = "oracle.spatial.edit.layer.GeometrySetLayer.polygonOuterRingOrientation";

    public GeometrySetLayer(MapCanvas canvas, IndexedGeometrySet set) {
        super(canvas);
        this.setIndexedDataSet(set);
        this.properties.setDefaultProperty(PROPERTY_SHAREBOUNDARY, Boolean.toString(false));
        this.properties.setDefaultProperty(PROPERTY_POLYGON_OUTER_RING_ORIENTATION, "counterclockwise");
    }

    public GeometrySetLayer(MapCanvas canvas) {
        this(canvas, null);
    }

    public GeometrySetLayer() {
        this(null, null);
    }

    @Override
    public Point2D snapTo(Point2D point, double tolerance, int granularity) {
        JGeometrySegmentPoint segPt;
        Point2D r = null;
        if (this.indexedSet instanceof IndexedGeometrySet && (segPt = ((IndexedGeometrySet)this.indexedSet).getSegmentPoint(point, tolerance, true, true, true, true)) != null) {
            r = segPt.getPoint();
        }
        return r;
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("ora_geomThemeItem.png");
    }

    @Override
    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
    }

    @Override
    public void added(Object src) {
        super.added(src);
        if (src instanceof EditSession) {
            this.buildDataSet();
        }
    }

    public void buildDataSet() {
        this.myNewObjects.clear();
        this.myDeleteObjects.clear();
        this.selectionManager.clear();
        this.hoverManager.clear();
        this.liveImg = null;
        this.mvImg = null;
        this.lastViewXFM = null;
        this.lastDataWindow = null;
        this.nonComplexAttrs = null;
        GeometrySet geomSet = new GeometrySet();
        geomSet.setName(this.getName());
        this.indexedSet = new IndexedGeometrySet(geomSet);
        this.indexedSet.setDataSetLayer(this);
        if (!this.updateDataSetSpatialInfo()) {
            log.warning("Unable to update spatial information for layer [" + this.getName() + "]. Build data set not completed.");
            this.liveProducer = null;
            return;
        }
        this.loadMetadata();
        this.liveProducer = new GeometrySetProducer(this);
        this.mapRegionChanged(null);
    }

    @Override
    public ThemeDescriptor getThemeDescriptor() {
        ThemeDescriptor td = new ThemeDescriptor();
        td.name = this.getName();
        td.type = 2;
        td.featureTableName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        td.spatialColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        td.renderStyleName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle");
        td.labelColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn");
        td.labelStyleName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle");
        try {
            td.workspaceName = this.getWorkspace().getName();
        }
        catch (Exception ex) {
            log.warning("Unable to get workspace name: " + ex.getMessage() + ". LIVE is used as default.");
            td.workspaceName = "LIVE";
        }
        td.SRID = this.getSRID();
        String query = "select " + td.spatialColumn;
        if (td.labelColumn != null && td.labelColumn.trim().length() > 0) {
            query = query + "," + td.labelColumn.trim();
        }
        query = query + " from " + td.featureTableName;
        td.WFS_queryCondition = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition");
        if (td.WFS_queryCondition != null && td.WFS_queryCondition.trim().length() > 0) {
            query = query + " where " + td.WFS_queryCondition.trim();
        }
        td.query = query;
        return td;
    }

    @Override
    protected void renderFeature(Graphics2D g, AbstractFeature feat, AffineTransform at, Style style) {
        if (this.isSelected(feat)) {
            return;
        }
        RenderUtils.renderGeometryObject(g, at, (GeometryFeature)feat, style);
        this.labelFeature(g, at, (GeometryFeature)feat);
    }

    @Override
    protected void doRealRendering() {
        String renderStyle = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle");
        if (renderStyle == null) {
            return;
        }
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        BufferedImage tmpImg = new BufferedImage(w, h, 2);
        StyleModel styModel = StyleModelUtils.getStyleModel(renderStyle);
        Style style = StyleFactory.createStyleFromXML((String)styModel.toXMLString());
        long t1 = System.currentTimeMillis();
        Graphics2D g = tmpImg.createGraphics();
        AffineTransform xfm = this.canvas.getViewportTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        List<GeoObject> data = this.indexedSet.getFeatures(this.canvas.getMapRegion().getDataWindow());
        for (GeoObject o : data) {
            if (this.myDeleteObjects.size() > 0 && this.myDeleteObjects.get(o.getKey().toString()) != null || this.isSelected(o)) continue;
            RenderUtils.renderGeometryObject(g, xfm, (GeometryFeature)o, style);
            this.labelFeature(g, xfm, (GeometryFeature)o);
        }
        Enumeration enumer = this.myNewObjects.elements();
        while (enumer.hasMoreElements()) {
            GeoObject o;
            o = (GeoObject)enumer.nextElement();
            if (this.isSelected(o)) continue;
            RenderUtils.renderGeometryObject(g, xfm, (GeometryFeature)o, style);
            this.labelFeature(g, xfm, (GeometryFeature)o);
        }
        g.dispose();
        this.liveImg = tmpImg;
        long t2 = System.currentTimeMillis();
        System.out.println(this.getName() + "(" + this.getClass().getSimpleName() + "): Time spent on actual rendering: " + (t2 - t1) + "ms.");
        log.info(this.getName() + "(" + this.getClass().getSimpleName() + "): Time spent on actual rendering: " + (t2 - t1) + "ms.");
    }

    public boolean featuresShareBoundary() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_SHAREBOUNDARY));
    }

    public void setFeaturesShareBoundary(boolean share) {
        this.setProperty(PROPERTY_SHAREBOUNDARY, Boolean.toString(share));
    }

    public void addVertexes(String key, JGeometrySegmentPoint[] linkSeg) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || key == null || linkSeg == null || linkSeg.length == 0) {
            return;
        }
        String changeName = MessagesBundle.getMessage("Change_add_vertexes");
        Icon changeIcon = null;
        int processed = 0;
        this.startChangeBlock(changeName, changeIcon);
        try {
            for (int i = 0; i < linkSeg.length; ++i) {
                String id;
                if (linkSeg[i].getPointLocation() != 2 || (id = linkSeg[i].getId()) == null || !id.equalsIgnoreCase(key) && !this.featuresShareBoundary()) continue;
                ((IndexedGeometrySet)this.indexedSet).addVertex(id, linkSeg[i]);
                ++processed;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
            if (processed > 0) {
                this.fireStateChanged();
            }
        }
    }

    public void removeVertex(String key, JGeometrySegmentPoint[] linkSeg) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || key == null || linkSeg == null || linkSeg.length == 0) {
            return;
        }
        String changeName = MessagesBundle.getMessage("Change_remove_vertex");
        Icon changeIcon = null;
        int processed = 0;
        this.startChangeBlock(changeName, changeIcon);
        try {
            for (int i = 0; i < linkSeg.length; ++i) {
                String id;
                if (linkSeg[i].getPointLocation() == 2 || (id = linkSeg[i].getId()) == null || !id.equalsIgnoreCase(key) && !this.featuresShareBoundary()) continue;
                ((IndexedGeometrySet)this.indexedSet).removeVertex(id, linkSeg[i]);
                ++processed;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
            if (processed > 0) {
                this.fireStateChanged();
            }
        }
    }

    public void removeVertexes(String key, Hashtable<String, JGeometrySegmentPoint[]> featSegs) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || key == null || featSegs == null || featSegs.size() == 0) {
            return;
        }
        int processed = 0;
        String changeName = MessagesBundle.getMessage("Change_remove_vertexes");
        Icon changeIcon = null;
        this.startChangeBlock(changeName, changeIcon);
        try {
            Enumeration<String> enumer = featSegs.keys();
            while (enumer.hasMoreElements()) {
                String id = enumer.nextElement();
                if (id == null || !id.equalsIgnoreCase(key) && !this.featuresShareBoundary() || !((IndexedGeometrySet)this.indexedSet).removeVertexes(id, featSegs.get(id))) continue;
                ++processed;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
            if (processed > 0) {
                this.fireStateChanged();
            }
        }
    }

    public void moveVertexes(String key, JGeometrySegmentPoint[] featSegs, Point2D newVertex) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || key == null || featSegs == null || featSegs.length == 0 || newVertex == null) {
            return;
        }
        int processed = 0;
        String changeName = MessagesBundle.getMessage("Change_move_vertexes");
        Icon changeIcon = null;
        this.startChangeBlock(changeName, changeIcon);
        try {
            for (int i = 0; i < featSegs.length; ++i) {
                String id = featSegs[i].getId();
                if (id == null || !id.equalsIgnoreCase(key) && !this.featuresShareBoundary() || !((IndexedGeometrySet)this.indexedSet).moveVertex(id, featSegs[i], newVertex)) continue;
                ++processed;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
            if (processed > 0) {
                this.fireStateChanged();
            }
        }
    }

    public boolean addPointElement(String key, JGeometry point) throws Exception {
        if (key == null || point == null || point.getType() != 1) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).addPoint(key, point);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean removePointElement(String key, int elementIndex) throws Exception {
        if (key == null || elementIndex < 0) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).removePoint(key, elementIndex);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean addLineElement(String key, JGeometry line) throws Exception {
        if (key == null || line == null || line.getType() != 2) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).addLine(key, line);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean removeLineElement(String key, int elementIndex) throws Exception {
        if (key == null || elementIndex < 0) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).removeLine(key, elementIndex);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean addPolygonElement(String key, JGeometry polygon) throws Exception {
        if (key == null || polygon == null || polygon.getType() != 3) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).addPolygon(key, polygon);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean removePolygonElement(String key, int elementIndex) throws Exception {
        if (key == null || elementIndex < 0) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).removePolygon(key, elementIndex);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean addVoidPolygonElement(String key, int polygonIndex, JGeometry polygon) throws Exception {
        if (key == null || polygon == null || polygonIndex < 0 || polygon.getType() != 3) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).addVoidPolygon(key, polygonIndex, polygon);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean removeVoidPolygonElement(String key, int elementIndex, int voidIndex) throws Exception {
        if (key == null || elementIndex < 0 || voidIndex < 0) {
            return false;
        }
        boolean status = ((IndexedGeometrySet)this.indexedSet).removeVoidPolygon(key, elementIndex, voidIndex);
        if (status) {
            this.fireStateChanged();
        }
        return status;
    }

    public boolean breakLine(String key, JGeometry updateGeometry, JGeometry newGeometry, Field[] newAttributes) throws Exception {
        if (key == null || updateGeometry == null || newGeometry == null || newAttributes == null) {
            throw new Exception("null");
        }
        GeometryFeature feature = (GeometryFeature)this.indexedSet.getDataSet().getFeature(key);
        if (feature == null) {
            throw new Exception("null");
        }
        String keyColumn = this.indexedSet.getDataSet().getKeyColumn();
        JGeometry geom = feature.getSpatialAttribute();
        if (geom == null || geom.getType() != 2 && geom.getType() != 6) {
            throw new Exception("null");
        }
        String changeName = MessagesBundle.getMessage("Change_break_line");
        Icon changeIcon = null;
        GeometryFeature gfeat = new GeometryFeature();
        gfeat.setSpatialAttribute(newGeometry);
        gfeat.setAttributes(newAttributes);
        Field newkey = gfeat.getAttribute(keyColumn);
        if (newkey == null || newkey.getValue() == null) {
            throw new Exception("Key value is null.");
        }
        this.startChangeBlock(changeName, changeIcon);
        try {
            this.indexedSet.addFeature(gfeat);
            gfeat.setKey(newkey);
            gfeat.setLayer(this);
            this.myNewObjects.put(newkey.toString(), gfeat);
            ((IndexedGeometrySet)this.indexedSet).updateSpatialAttribute(key, updateGeometry);
            this.fireStateChanged();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
        }
        return true;
    }

    public boolean splitPolygon(String key, int geomElemIndex, JGeometry firstPart, JGeometry secondPart, Field[] newAttributes) throws Exception {
        if (key == null || geomElemIndex < 0 || firstPart == null || secondPart == null || newAttributes == null) {
            throw new Exception("null");
        }
        GeometryFeature feature = (GeometryFeature)this.indexedSet.getDataSet().getFeature(key);
        if (feature == null) {
            throw new Exception("null");
        }
        String keyColumn = this.indexedSet.getDataSet().getKeyColumn();
        JGeometry geom = feature.getSpatialAttribute();
        if (geom == null || geom.getType() != 3 && geom.getType() != 7 && geom.getType() != 4) {
            throw new Exception("null");
        }
        JGeometry updateGeometry = firstPart;
        if (geom.getElements().length > 1) {
            JGeometry tempGeom = JGeometryUtil.removePolygon((JGeometry)geom, (int)geomElemIndex);
            if (tempGeom == null) {
                throw new Exception("null");
            }
            updateGeometry = JGeometryUtil.addPolygon((JGeometry)tempGeom, (JGeometry)firstPart);
            if (updateGeometry == null) {
                throw new Exception("null");
            }
        }
        String changeName = MessagesBundle.getMessage("Change_split_polygon");
        Icon changeIcon = null;
        GeometryFeature gfeat = new GeometryFeature();
        gfeat.setSpatialAttribute(secondPart);
        gfeat.setAttributes(newAttributes);
        Field newkey = gfeat.getAttribute(keyColumn);
        if (newkey == null || newkey.getValue() == null) {
            throw new Exception("Key value is null.");
        }
        this.startChangeBlock(changeName, changeIcon);
        try {
            this.indexedSet.addFeature(gfeat);
            gfeat.setKey(newkey);
            gfeat.setLayer(this);
            this.myNewObjects.put(newkey.toString(), gfeat);
            ((IndexedGeometrySet)this.indexedSet).updateSpatialAttribute(key, updateGeometry);
            this.fireStateChanged();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
        }
        return true;
    }

    public int scaleFeatures(String[] keys, Point2D center, double scaleFactor) throws Exception {
        if (keys == null || keys.length == 0 || center == null || scaleFactor <= 0.0) {
            return 0;
        }
        int processed = 0;
        String changeName = MessagesBundle.getMessage("Change_scale_features");
        Icon changeIcon = null;
        this.startChangeBlock(changeName, changeIcon);
        for (int i = 0; i < keys.length; ++i) {
            JGeometry geom;
            JGeometry scGeom;
            GeometryFeature feature = (GeometryFeature)this.indexedSet.getDataSet().getFeature(keys[i]);
            if (feature == null || (scGeom = Util.scaleGeometry((JGeometry)(geom = feature.getSpatialAttribute()), (double)center.getX(), (double)center.getY(), (double)scaleFactor, (double)scaleFactor, (double)0.0)) == null || scGeom.getMBR() == null || !((IndexedGeometrySet)this.indexedSet).updateSpatialAttribute(keys[i], scGeom)) continue;
            ++processed;
        }
        this.endChangeBlock(changeName, changeIcon);
        if (processed > 0) {
            this.fireStateChanged();
        }
        return processed;
    }

    public int rotateFeatures(String[] keys, Point2D center, double angle) throws Exception {
        if (keys == null || keys.length == 0 || center == null || angle < -360.0 || angle > 360.0) {
            return 0;
        }
        int processed = 0;
        String changeName = MessagesBundle.getMessage("Change_rotate_features");
        Icon changeIcon = null;
        this.startChangeBlock(changeName, changeIcon);
        try {
            for (int i = 0; i < keys.length; ++i) {
                JGeometry geom;
                JGeometry scGeom;
                GeometryFeature feature = (GeometryFeature)this.indexedSet.getDataSet().getFeature(keys[i]);
                if (feature == null || (scGeom = Util.rotateGeometry((JGeometry)(geom = feature.getSpatialAttribute()), (double)center.getX(), (double)center.getY(), (double)angle)) == null || scGeom.getMBR() == null || !((IndexedGeometrySet)this.indexedSet).updateSpatialAttribute(keys[i], scGeom)) continue;
                ++processed;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
            if (processed > 0) {
                this.fireStateChanged();
            }
        }
        return processed;
    }

    public int translateFeatures(String[] keys, double offsetX, double offsetY) throws Exception {
        if (keys == null || keys.length == 0 || Double.isNaN(offsetX) || Double.isNaN(offsetY)) {
            return 0;
        }
        int processed = 0;
        String changeName = MessagesBundle.getMessage("Change_translate_features");
        Icon changeIcon = null;
        this.startChangeBlock(changeName, changeIcon);
        try {
            for (int i = 0; i < keys.length; ++i) {
                JGeometry geom;
                JGeometry movegeom;
                GeometryFeature feature = (GeometryFeature)this.indexedSet.getDataSet().getFeature(keys[i]);
                if (feature == null || (movegeom = JGeometryUtil.moveGeometry((JGeometry)(geom = feature.getSpatialAttribute()), (double)offsetX, (double)offsetY)) == null || movegeom.getMBR() == null || !((IndexedGeometrySet)this.indexedSet).updateSpatialAttribute(keys[i], movegeom)) continue;
                ++processed;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
            if (processed > 0) {
                this.fireStateChanged();
            }
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int transformFeatures(GeoObject[] features, AffineTransform at) {
        if (features == null || features.length == 0) {
            return 0;
        }
        String keyColumn = this.indexedSet.getDataSet().getKeyColumn();
        String changeName = MessagesBundle.getMessage("Change_transform_features");
        Icon changeIcon = null;
        if (features.length > 1) {
            this.startChangeBlock(changeName, changeIcon);
        }
        int processed = 0;
        try {
            for (GeoObject f : features) {
                if (f == null) continue;
                GeometryFeature feature = (GeometryFeature)f;
                String key = feature.getAttribute(keyColumn).getValue().toString();
                JGeometry geom = feature.getSpatialAttribute();
                JGeometry newGeom = null;
                try {
                    newGeom = JGeometryUtil.transformGeometry((JGeometry)geom, (AffineTransform)at, (boolean)true, (features.length == 1 && JGeometryUtil.getElements((JGeometry)geom).length == 1 ? 1 : 0) != 0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                if (newGeom == null) continue;
                try {
                    ((IndexedGeometrySet)this.indexedSet).updateSpatialAttribute(key, newGeom);
                    ++processed;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
        }
        finally {
            if (features.length > 1) {
                this.endChangeBlock(changeName, changeIcon);
            }
            if (processed > 0) {
                this.fireStateChanged();
            }
        }
        return processed;
    }

    public static AbstractFeature[] sortGeometryFeaturesByAreaDesc(AbstractFeature[] feats) {
        ArrayList<AbstractFeature> features = new ArrayList<AbstractFeature>();
        if (feats == null || feats.length == 0) {
            return null;
        }
        for (int i = 0; i < feats.length; ++i) {
            JGeometry geom = ((GeometryFeature)feats[i]).getSpatialAttribute();
            int gtype = geom.getType();
            if (geom != null && (gtype == 3 || gtype == 7)) {
                Rectangle2D rect = feats[i].getMBR();
                double area = rect.getWidth() * rect.getHeight();
                if (features.size() == 0) {
                    features.add(feats[i]);
                    continue;
                }
                int index = -1;
                for (int j = 0; j < features.size(); ++j) {
                    Rectangle2D fr;
                    double fa;
                    GeometryFeature f = (GeometryFeature)features.get(j);
                    JGeometry g = f.getSpatialAttribute();
                    if (g.getType() != 3 && g.getType() != 7 || !(area > (fa = (fr = f.getMBR()).getWidth() * fr.getHeight()))) continue;
                    index = j;
                    break;
                }
                if (index == -1) {
                    features.add(feats[i]);
                    continue;
                }
                features.add(index, feats[i]);
                continue;
            }
            features.add(feats[i]);
        }
        return features.toArray(new AbstractFeature[features.size()]);
    }

    @Override
    protected void renderHoverShape(GeoObject object, Shape shape, Graphics2D dest, AffineTransform transf) {
        Rectangle2D mbr = shape.getBounds2D();
        int x = (int)mbr.getMinX();
        int y = (int)mbr.getMinY();
        int w = (int)mbr.getWidth() + 1;
        int h = (int)mbr.getHeight() + 1;
        JGeometry geom = ((GeometryFeature)object).getSpatialAttribute();
        int gType = geom.getType();
        int cvw_offset = 0;
        if (this.canvas.getWidth() < (int)mbr.getWidth()) {
            cvw_offset = (int)mbr.getWidth() - this.canvas.getWidth();
        }
        if (x + w > this.canvas.getWidth()) {
            cvw_offset -= x + w - this.canvas.getWidth();
        }
        int cvh_offset = 0;
        if (this.canvas.getHeight() < (int)mbr.getHeight()) {
            cvh_offset = (int)mbr.getHeight() - this.canvas.getHeight();
        }
        if (y + h > this.canvas.getHeight()) {
            cvh_offset -= y + h - this.canvas.getHeight();
        }
        int imgW = Math.min((int)mbr.getWidth(), this.canvas.getWidth());
        int imgH = Math.min((int)mbr.getHeight(), this.canvas.getHeight());
        if (imgW <= 0) {
            imgW = 1;
        }
        if (imgH <= 0) {
            imgH = 1;
        }
        BufferedImage image = new BufferedImage(imgW, imgH, 2);
        Graphics2D g = image.createGraphics();
        g.translate(-x - cvw_offset, -y - cvh_offset);
        if (gType == 3 || gType == 7) {
            g.setColor(this.hoverColor);
            g.fill(shape);
            g.setColor(this.hoverBorderColor);
            g.setStroke(this.hoverStroke);
            g.draw(shape);
        } else if (gType == 2 || gType == 6) {
            g.setColor(this.hoverBorderColor);
            g.setStroke(this.hoverStroke);
            g.draw(shape);
        } else if (gType == 4) {
            GeneralPath lines = new GeneralPath();
            GeneralPath rings = new GeneralPath();
            ShapeUtil.extractLinesAndRings((Shape)shape, (GeneralPath)lines, (GeneralPath)rings);
            g.setColor(this.hoverColor);
            g.fill(rings);
            g.setColor(this.hoverBorderColor);
            g.setStroke(this.hoverStroke);
            g.draw(rings);
            g.setColor(this.hoverBorderColor);
            g.setStroke(this.hoverStroke);
            g.draw(lines);
            JGeometry[] elems = geom.getElements();
            if (elems != null && elems.length > 0) {
                for (int i = 0; i < elems.length; ++i) {
                    if (elems[i].getType() != 1) continue;
                    Point2D p2 = elems[i].getJavaPoint();
                    Point2D p2new = (Point2D)p2.clone();
                    transf.transform(p2, p2new);
                    this.renderHoverPoint(p2new, g);
                }
            }
        } else if (gType == 5) {
            float[] segCoords = new float[6];
            PathIterator pi = shape.getPathIterator(null);
            int index = 0;
            while (!pi.isDone()) {
                int t = pi.currentSegment(segCoords);
                if (t == 0 || t == 1) {
                    Point2D.Double pt = new Point2D.Double(segCoords[0], segCoords[1]);
                    this.renderHoverPoint(pt, g);
                }
                pi.next();
                ++index;
            }
        }
        g.dispose();
        ShadowRenderer sr = new ShadowRenderer();
        BufferedImage shadow = sr.createShadow(image);
        dest.drawImage((Image)shadow, (int)mbr.getMinX() + cvw_offset, (int)mbr.getMinY() + cvh_offset, null);
        dest.drawImage((Image)image, (int)mbr.getMinX() + cvw_offset, (int)mbr.getMinY() + cvh_offset, null);
        shadow = null;
        image = null;
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        GeometryLayerPropertyPanel gpropPanel = new GeometryLayerPropertyPanel(this);
        gpropPanel.isEditingMode(false);
        return gpropPanel;
    }

    @Override
    public GeoObject newObject(Object spatialObject, Object[] params) throws Exception {
        Field[] fields = null;
        fields = this.getFieldsForFeature(null, false);
        if (fields == null || fields.length == 0) {
            return null;
        }
        String keyColumn = this.getIndexedDataSet().getDataSet().getKeyColumn();
        GeometryFeature gfeat = new GeometryFeature();
        gfeat.setSpatialAttribute(spatialObject);
        gfeat.setLayer(this);
        gfeat.setAttributes(fields);
        String fkey = gfeat.getAttribute(keyColumn).getValue().toString();
        gfeat.setKey(fkey);
        if (!this.insertObject(fkey, gfeat)) {
            gfeat = null;
        }
        return gfeat;
    }

    @Override
    public boolean appendToObject(Object key, Object spatialObject) throws Exception {
        return this.addPolygonElement(key.toString(), (JGeometry)spatialObject);
    }
}

