/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import oracle.maps.core.TileLayerConfig;
import oracle.mapviewer.share.OMSException;

public class TileLayerUtils {
    public static TileLayerConfig getTileLayerConfig(String mapViewerUrl, String dataSource, String tileLayer) throws Exception {
        String xml = TileLayerUtils.getTileLayerConfigXML(mapViewerUrl, dataSource, tileLayer);
        TileLayerConfig config = new TileLayerConfig(xml);
        return config;
    }

    public static String getTileLayerConfigXML(String mapViewerUrl, String dataSource, String tileLayer) throws Exception {
        String tileLayerFullName = dataSource + "." + tileLayer;
        String xmlReq = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<map_cache_admin_request>\n  <get_client_config map_cache_names=\"" + tileLayerFullName + "\" format=\"XML\" />\n" + "</map_cache_admin_request>\n";
        String mcsURL = mapViewerUrl.substring(0, mapViewerUrl.lastIndexOf("/mapviewer")) + "/mapviewer/mcserver";
        try {
            String line;
            URL url = new URL(mcsURL);
            String param = "xml_request=" + URLEncoder.encode(xmlReq, "UTF-8");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(param);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer result = new StringBuffer(2048);
            while ((line = rd.readLine()) != null) {
                result.append(line).append("\n");
            }
            wr.close();
            rd.close();
            System.out.println("Tile layer config info:\n" + result.toString());
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            System.err.println("cannot get tile layer config info from server." + e.getMessage());
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        String xml = TileLayerUtils.getTileLayerConfigXML("http://elocation.oracle.com/mapviewer", "elocation_mercator", "world_map");
        try {
            TileLayerConfig config = new TileLayerConfig(xml);
            System.out.println("name: " + config.getTileLayerName());
            System.out.println("data source: " + config.getDataSource());
            System.out.println("image format: " + config.getImageFormat());
            System.out.println("transparent: " + config.isTransparent());
            System.out.println("srid: " + config.getSrid());
            System.out.println("coord sys type: " + config.getCoordinateSystemType());
            System.out.println("distConvFactor: " + config.getDistanceConversionFactor());
            System.out.println("minX,minY,maxX,maxY: " + config.getCoordinateSystemBound()[0] + "," + config.getCoordinateSystemBound()[1] + "," + config.getCoordinateSystemBound()[2] + "," + config.getCoordinateSystemBound()[3]);
            System.out.println("zoom level #: " + config.getZoomLevelCount());
            for (int i = 0; i < config.getZoomLevelCount(); ++i) {
                System.out.print("zoom level " + i + ": ");
                System.out.print(" name-" + config.getZoomLevelName(i));
                System.out.print(" scale-" + config.getScale(i));
                System.out.print(" tileWidth-" + config.getTileWidth(i));
                System.out.print(" tileHeight-" + config.getTileHeight(i));
                System.out.print(" imageWidth-" + config.getTileImageWidth(i));
                System.out.print(" imageHeight-" + config.getTileImageHeight(i));
                System.out.println();
            }
        }
        catch (OMSException e) {
            e.printStackTrace();
        }
    }
}

