/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public final class CGAutorefreshPanel
extends DialogBase {
    private JTextField gui_ar_type;
    private JFormattedTextField gui_interval;
    private JComboBox gui_ar_unit;
    private JTextField gui_ar_state;

    @Override
    public boolean applicable(DBObject dBObject) {
        if (CGCPanel.isNonCacheConnection(dBObject)) {
            TTDialog.showError(Messages.getString("CGCPanel.creatingACacheGroupRequiresACacheConnection"));
            return false;
        }
        if (this._mode != "none" && this._model.get("AUTOREFRESH MODEv") == null) {
            TTDialog.showError(Messages.getString("CGAutorefreshPanel.thisOptionOnlyAppliesToAutorefreshedCacheGroups"));
            return false;
        }
        return true;
    }

    public CGAutorefreshPanel(DBObject dBObject, String string) {
        super(dBObject, string, "CGAutorefreshPanel", "cache");
    }

    public CGAutorefreshPanel(DBObject dBObject) {
        super(dBObject, null, "CGAutorefreshPanel", "cache");
    }

    public CGAutorefreshPanel(DBObject dBObject, List<JComponent> list) {
        super(dBObject, null, "CGAutorefreshPanel", "none", list);
    }

    @Override
    protected void initGUI() {
        Object object;
        if (this._model != null) {
            this.addOwnerAndName(this._dict);
        }
        int n = 0;
        Object object2 = "incremental";
        if (this._model != null && (object = (String)this._model.get("AUTOREFRESH MODEv")) != null && ((String)object).startsWith("F")) {
            n = 1;
            object2 = "full";
        }
        this.gui_ar_type = new JTextField((String)object2);
        this._textValues.add(this.gui_ar_type);
        object2 = TTDialog.createRadioButtonGroup(new String[]{Messages.getString("CGAutorefreshPanel.incremental"), Messages.getString("CGAutorefreshPanel.full")}, n, new ActionListener[]{new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGAutorefreshPanel.this.gui_ar_type.setText("incremental");
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGAutorefreshPanel.this.gui_ar_type.setText("full");
            }
        }});
        this.addRow(Messages.getString("CGAutorefreshPanel.mode"), (Component)object2);
        object = new JPanel(new GridLayout(1, 2, 1, 0));
        Object object3 = new DecimalFormat("#0");
        this.gui_interval = new JFormattedTextField(new NumberFormatter((NumberFormat)object3));
        String string = null;
        if (this._model != null) {
            string = (String)this._model.get("AUTOREFRESH INTERVAL");
        }
        if (string == null) {
            string = "5";
        }
        this.gui_interval.setValue(Integer.parseInt(string));
        ((Container)object).add(this.gui_interval);
        this._textValues.add(this.gui_interval);
        string = null;
        if (this._model != null) {
            string = (String)this._model.get("AUTOREFRESH UNIT");
        }
        if (string == null) {
            string = Messages.getString("TimesTen.common.minutes");
        }
        this.gui_ar_unit = TTDialog.createMenu(new String[]{Messages.getString("TimesTen.common.minutes"), Messages.getString("TimesTen.common.seconds"), Messages.getString("TimesTen.common.milliseconds")}, string);
        ((Container)object).add(this.gui_ar_unit);
        this._textValues.add(this.gui_ar_unit);
        this.addRow(Messages.getString("CGAutorefreshPanel.refreshInterval"), (Component)object);
        n = 0;
        object3 = "paused";
        if (this._model != null && (string = (String)this._model.get("AUTOREFRESH STATEv")) != null) {
            if (string.startsWith("On")) {
                n = 1;
                object3 = "on";
            } else if (string.startsWith("Of")) {
                n = 2;
                object3 = "off";
            }
        }
        this.gui_ar_state = new JTextField((String)object3);
        this._textValues.add(this.gui_ar_state);
        object2 = TTDialog.createRadioButtonGroup(new String[]{Messages.getString("TimesTen.common.paused"), Messages.getString("TimesTen.common.on"), Messages.getString("TimesTen.common.off")}, n, new ActionListener[]{new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGAutorefreshPanel.this.gui_ar_state.setText("paused");
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGAutorefreshPanel.this.gui_ar_state.setText("on");
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGAutorefreshPanel.this.gui_ar_state.setText("off");
            }
        }});
        this.addRow(Messages.getString("CGAutorefreshPanel.refreshState"), (Component)object2);
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public String getSql() {
        String[] stringArray = new String[]{"minutes", "seconds", "milliseconds"};
        String string = "";
        int n = this.gui_ar_unit.getSelectedIndex();
        string = stringArray[n];
        try {
            String string2 = CGAutorefreshPanel.getCaller();
            if (string2.contains("CGCCGPanel")) {
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append(" AUTOREFRESH MODE ");
                stringBuffer.append(this.gui_ar_type.getText().toUpperCase());
                stringBuffer.append(" INTERVAL ");
                stringBuffer.append(this.gui_interval.getText().trim());
                stringBuffer.append(" ");
                stringBuffer.append(string.toUpperCase());
                stringBuffer.append("\n");
                stringBuffer.append(" STATE ");
                stringBuffer.append(this.gui_ar_state.getText().toUpperCase());
                stringBuffer.append("\n");
                return stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "alter cache group \"" + this.getUserName() + "\".\"" + this.getObjectName() + "\"\n" + "    set autorefresh mode " + this.gui_ar_type.getText() + ";\n" + "alter cache group \"" + this.getUserName() + "\".\"" + this.getObjectName() + "\"\n" + "    set autorefresh interval " + this.gui_interval.getText() + " " + string + ";\n" + "alter cache group \"" + this.getUserName() + "\".\"" + this.getObjectName() + "\"\n" + "    set autorefresh state " + this.gui_ar_state.getText();
    }

    @Override
    public boolean validateValues() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.gui_ar_type.getText().trim().length() == 0) {
            stringBuffer.append(Messages.getString("CGAutorefreshPanel.refreshTypeMustBeSelected"));
        } else if (this.gui_interval.getText().trim().length() <= 0) {
            stringBuffer.append(Messages.getString("CGAutorefreshPanel.refreshIntervalCannotBeEmpty"));
        } else if (this.gui_ar_state.getText().trim().length() == 0) {
            stringBuffer.append(Messages.getString("CGAutorefreshPanel.refreshStateMustBeSelected"));
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }
}

