/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.advisor;

import java.awt.Frame;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.timesten.advisor.IndexAdvisorConfiguration;
import oracle.dbtools.raptor.timesten.advisor.IndexAdvisorTask;
import oracle.dbtools.raptor.timesten.advisor.WorksheetIndexAdvisorPanel;
import oracle.dbtools.raptor.timesten.dialogs.connection.TableStatistics;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;

public class IndexAdvisorProvider
implements ActionProvider<Boolean> {
    private int theCaptureMode;
    private int theCaptureLevel;
    private boolean theIncludeOlapOptimizerHintsFlag;
    private String hints;
    private static Logger LOGGER = Logger.getLogger(IndexAdvisorProvider.class.getPackage().getName());
    private final Connections _connections = Connections.getInstance();
    public static final String SQLTUNINGADVISOR_CMD_ID = "Worksheet.TimesTenIndexAdvisor";
    private WorksheetAction sqlTuningAdvisorAction = WorksheetAction.createWorksheetAction((String)"Worksheet.TimesTenIndexAdvisor", (WorksheetAction.ActionType)WorksheetAction.ActionType.BOTH, (int)3, (double)-10.0);

    public boolean isTheIncludeOlapOptimizerHintsFlag() {
        return this.theIncludeOlapOptimizerHintsFlag;
    }

    public void setTheIncludeOlapOptimizerHintsFlag(boolean bl) {
        this.theIncludeOlapOptimizerHintsFlag = bl;
    }

    public void setHints(String string) {
        this.hints = string;
    }

    public String getHins() {
        return this.hints;
    }

    public int getActionsCount() {
        return 1;
    }

    public WorksheetAction getActionAt(int n) {
        return this.sqlTuningAdvisorAction;
    }

    public int getPanelCount() {
        return 0;
    }

    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    public WorksheetTaskWrapper<Boolean> doAction(String string, WorksheetContext worksheetContext) {
        Object object;
        if (!SQLTUNINGADVISOR_CMD_ID.equals(string)) {
            return null;
        }
        try {
            object = Connections.getInstance().getConnection(worksheetContext.getConnectionName());
            TableStatistics tableStatistics = new TableStatistics((Connection)object, (Frame)Ide.getMainWindow());
            int n = tableStatistics.displayWarning();
            if (n != 1) {
                return null;
            }
        }
        catch (DBException dBException) {
            LOGGER.log(Level.SEVERE, "Error on database", dBException);
        }
        object = new IndexAdvisorConfiguration(this);
        boolean bl = ((IndexAdvisorConfiguration)object).launch();
        if (!bl) {
            return null;
        }
        WorksheetIndexAdvisorPanel worksheetIndexAdvisorPanel = new WorksheetIndexAdvisorPanel(string, worksheetContext);
        IndexAdvisorTask indexAdvisorTask = new IndexAdvisorTask(string, worksheetContext, this.theCaptureLevel, this.theCaptureMode, this.theIncludeOlapOptimizerHintsFlag, this.hints);
        indexAdvisorTask.setIndexAdvisorPanel(worksheetIndexAdvisorPanel);
        ArrayList<WorksheetIndexAdvisorPanel.IndexAdvisorTaskListner> arrayList = new ArrayList<WorksheetIndexAdvisorPanel.IndexAdvisorTaskListner>();
        arrayList.add(new WorksheetIndexAdvisorPanel.IndexAdvisorTaskListner(worksheetIndexAdvisorPanel));
        WorksheetTaskWrapper worksheetTaskWrapper = new WorksheetTaskWrapper((RaptorTask)indexAdvisorTask, arrayList, Collections.emptyList(), worksheetContext);
        return worksheetTaskWrapper;
    }

    public void setCaptureMode(int n) {
        this.theCaptureMode = n;
    }

    public void setCaptureLevel(int n) {
        this.theCaptureLevel = n;
    }

    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        if (worksheetContext.isBusy()) {
            return false;
        }
        BasicDocument basicDocument = (BasicDocument)worksheetContext.getEditor().getDocument();
        try {
            String string2;
            if (basicDocument.getLength() > 0 && (string2 = worksheetContext.getConnectionName()) != null && Connections.getInstance().isConnectionOpen(string2)) {
                return this._connections.isTimesTen(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

