/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.timesten.format.GenericResultsFormatter;

public class TimesTenNLSProvider
extends DefaultNLSProvider {
    private static final String TIMESTAMP_FORMAT = "SYYYY-MM-DD HH24:MI:SS.FFFFFFFFF";
    private static final String TIMESTEN_DATE_FORMAT = "YYYY-MM-DD HH:MI:SS";

    public TimesTenNLSProvider(Connection connection) {
        super(connection);
    }

    public Object getValue(Object object) {
        if (object instanceof Date) {
            GenericResultsFormatter.convertToOracleDate((Date)object);
        } else if (object instanceof Timestamp) {
            GenericResultsFormatter.convertToOracleTimestamp((Timestamp)object, true);
        }
        return super.getValue(object);
    }

    public String getTimeStampFormat() {
        return TIMESTAMP_FORMAT;
    }

    public String getDateFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return TIMESTEN_DATE_FORMAT;
            }
            case GENERIC: {
                String string = this.getDateFormatHelper("NLS_DATE_FORM");
                if (string != null) {
                    return string;
                }
                return TIMESTEN_DATE_FORMAT;
            }
        }
        return super.getDateFormat(formatType);
    }

    public String getTimeStampFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return TIMESTAMP_FORMAT;
            }
            case GENERIC: {
                String string = this.getDateFormatHelper("NLS_TS_FORM");
                if (string != null) {
                    return string;
                }
                return TIMESTAMP_FORMAT;
            }
        }
        return super.getTimeStampFormat(formatType);
    }

    private String getDateFormatHelper(String string) {
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig != null) {
            return dBConfig.getString(string);
        }
        return null;
    }
}

