/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.triggers.ButtonStateEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class ButtonStateTrigger
extends Trigger {
    public ButtonStateTrigger(TimingController timer, AbstractButton source, Trigger.TriggerAction action, ButtonStateEvent event) {
        this.setupListener(timer, source, action, event);
    }

    public ButtonStateTrigger(TimingController startTimer, AbstractButton source, ButtonStateEvent event, TimingController stopTimer) {
        super(startTimer, source, event, stopTimer);
    }

    protected void setupListener(TimingController timer, Object source, Trigger.TriggerAction action, TriggerEvent event) {
        try {
            ButtonModel model = ((AbstractButton)source).getModel();
            ButtonStateListener listener = new ButtonStateListener(timer, action, (ButtonStateEvent)event, model);
            this.setupListener(model, listener, "addChangeListener", ChangeListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating change listener for object " + source + ": " + e);
        }
    }

    class ButtonStateListener
    extends TriggerListener
    implements ChangeListener {
        boolean armed;
        boolean rollover;
        ButtonStateEvent event;

        protected ButtonStateListener(TimingController timer, Trigger.TriggerAction action, ButtonStateEvent event, ButtonModel model) {
            super(timer, action);
            this.event = event;
            this.armed = model.isArmed();
            this.rollover = model.isRollover();
        }

        public void stateChanged(ChangeEvent ae) {
            boolean rolloverChange;
            ButtonModel model = (ButtonModel)ae.getSource();
            boolean armedChange = this.armed != model.isArmed();
            boolean bl = rolloverChange = this.rollover != model.isRollover();
            if (armedChange) {
                if (this.event == ButtonStateEvent.ARMED && model.isArmed() || this.event == ButtonStateEvent.DISARMED && !model.isArmed()) {
                    this.pullTrigger();
                }
                this.armed = model.isArmed();
            }
            if (rolloverChange) {
                if (this.event == ButtonStateEvent.ROLLOVER && model.isRollover() || this.event == ButtonStateEvent.ROLLOFF && !model.isRollover()) {
                    this.pullTrigger();
                }
                this.rollover = model.isRollover();
            }
        }
    }
}

