/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.runner.DebuggerBreakpointDeclarator;
import oracle.ide.runner.DebuggerBreakpointGutterToggleHandler;
import oracle.ide.runner.DebuggerExtenderDeclarator;
import oracle.ide.runner.DebuggerInspectorExpressionProvider;
import oracle.ide.runner.DebuggerListener;
import oracle.ide.runner.DebuggerWindowProviderDeclarator;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ide.util.Assert;
import oracle.ideimpl.runner.DataValueToStringBehavior;
import oracle.ideimpl.runner.ExecutionListener;
import oracle.ideimpl.runner.RunnerUtils;
import oracle.javatools.data.HashStructure;

public final class DebuggerHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "debugger-hook");
    private static HashStructureHook hashStructureHook;
    private static Set<String> _emittedErrors;
    private static Map<String, DebuggerExtenderDescription> _debuggerExtenders;
    private static Map<String, ToolDescription<DebuggerWindowProviderDeclarator>> _debuggerWindowProviders;
    private static Map<String, String> _expansions;
    private static Map<String, Set<String>> _expansionSuggestions;
    private static Map<String, String> _expressions;
    private static Map<String, Set<String>> _expressionSuggestions;
    private static Set<String> _hideAllFields;
    private static Map<String, Set<String>> _hideFields;
    private static Map<String, DataValueToStringBehavior> _toStringBehavior;
    private static Map<String, ObjectPreferencesIcon> _icons;
    private static Map<String, CustomBreakpointType> _customBreakpointTypes;
    private static Map<String, ToolDescription<DebuggerListener>> _debuggerListeners;
    private static Map<String, ToolDescription<ExecutionListener>> _executionListeners;
    private static Map<String, ToolDescription<SmartDataProvider>> _smartDataProviders;
    private static Map<String, ToolDescription<ToolTipExpressionProvider>> _toolTipExpressionProviders;
    private static Map<String, ToolDescription<DebuggerInspectorExpressionProvider>> _inspectorExpressionProviders;
    private static Map<String, ToolDescription<DebuggerBreakpointGutterToggleHandler>> _gutterClickHandlers;

    public static synchronized List<String> getDebuggerExtenderIds(Project project) {
        DebuggerHook.primeHook();
        ArrayList<String> ids = new ArrayList<String>(_debuggerExtenders.size());
        for (Map.Entry<String, DebuggerExtenderDescription> entry : _debuggerExtenders.entrySet()) {
            if (!entry.getValue().areRulesSatisfied(project)) continue;
            ids.add(entry.getKey());
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<DebuggerExtenderDeclarator, List<String>> getDebuggerExtenderDeclarator(String id) {
        if (id == null) return null;
        Class<DebuggerHook> clazz = DebuggerHook.class;
        synchronized (DebuggerHook.class) {
            DebuggerHook.primeHook();
            DebuggerExtenderDescription desc = _debuggerExtenders.get(id);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (desc == null) return null;
            HashMap<DebuggerExtenderDeclarator, List<String>> extenderInfo = new HashMap<DebuggerExtenderDeclarator, List<String>>();
            extenderInfo.put((DebuggerExtenderDeclarator)desc.getTool(), desc.getHandledSourceExtensions());
            return extenderInfo;
        }
    }

    private static synchronized void updateDebuggerExtenders(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.DEBUGGER_EXTENDER, items);
        if (_debuggerExtenders == null) {
            _debuggerExtenders = new LinkedHashMap<String, DebuggerExtenderDescription>();
        }
        for (DebuggerExtenderDescription desc : items) {
            String id = desc.getId();
            String className = desc.getClassName();
            if (className == null || id == null) continue;
            if (!_debuggerExtenders.containsKey(id)) {
                if (!DebuggerHook.checkRule(desc.getRule(), Category.DEBUGGER_EXTENDER.toString(), hashStructure)) continue;
                _debuggerExtenders.put(id, desc);
                continue;
            }
            DebuggerHook.logError("Duplicate Debugger Extender ID: " + id, Category.DEBUGGER_EXTENDER.toString(), hashStructure);
        }
    }

    public static void duplicateSourceExtensionError(String extenderId, String previousRegistrant, String sourceExtension) {
        DebuggerExtenderDescription desc = _debuggerExtenders.get(extenderId);
        DebuggerHook.logError("DebuggerExtender " + extenderId + " attempted to register to handle source extension " + sourceExtension + "but that is already registered to " + previousRegistrant, desc.getCategoryString(), desc.getHash());
    }

    public static void notExtender2Error(String extenderId) {
        DebuggerExtenderDescription desc = _debuggerExtenders.get(extenderId);
        DebuggerHook.logError("DebuggerExtender " + extenderId + " has registered to handle source extensions but is not a DebuggerExtender2", desc.getCategoryString(), desc.getHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DebuggerWindowProviderDeclarator> getDebuggerWindowProviderDeclarators(Project project) {
        Class<DebuggerHook> clazz = DebuggerHook.class;
        synchronized (DebuggerHook.class) {
            DebuggerHook.primeHook();
            ArrayList<ToolDescription<DebuggerWindowProviderDeclarator>> copy = new ArrayList<ToolDescription<DebuggerWindowProviderDeclarator>>(_debuggerWindowProviders.values());
            // ** MonitorExit[clazz] (shouldn't be in output)
            ArrayList<DebuggerWindowProviderDeclarator> list = new ArrayList<DebuggerWindowProviderDeclarator>(copy.size());
            for (ToolDescription toolDescription : copy) {
                DebuggerWindowProviderDeclarator declarator;
                if (!toolDescription.areRulesSatisfied(project) || (declarator = (DebuggerWindowProviderDeclarator)toolDescription.getTool()) == null) continue;
                list.add(declarator);
            }
            return list;
        }
    }

    private static synchronized void updateDebuggerWindowProviders(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.DEBUGGER_WINDOW_PROVIDER, items);
        if (_debuggerWindowProviders == null) {
            _debuggerWindowProviders = new LinkedHashMap<String, ToolDescription<DebuggerWindowProviderDeclarator>>();
        }
        for (ToolDescription desc : items) {
            String key = desc.getClassName();
            if (key == null) continue;
            if (!_debuggerWindowProviders.containsKey(key)) {
                if (!DebuggerHook.checkRule(desc.getRule(), Category.DEBUGGER_WINDOW_PROVIDER.toString(), hashStructure)) continue;
                _debuggerWindowProviders.put(key, desc);
                continue;
            }
            DebuggerHook.logError("Duplicate DebuggerWindowProvider registration : " + key, Category.DEBUGGER_WINDOW_PROVIDER.toString(), hashStructure);
        }
    }

    public static synchronized List<String> getDebuggerExtenderCustomBreakpointTypes() {
        DebuggerHook.primeHook();
        return new ArrayList<String>(_customBreakpointTypes.keySet());
    }

    public static DebuggerBreakpointDeclarator getDebuggerExtenderCustomBreakpointDeclarator(String typeString) {
        CustomBreakpointType bpType;
        if (typeString != null && (bpType = DebuggerHook.getDebuggerExtenderCustomBreakpointType(typeString)) != null) {
            return (DebuggerBreakpointDeclarator)bpType.getTool();
        }
        return null;
    }

    public static String getDebuggerExtenderCustomBreakpointExtenderId(String typeString) {
        CustomBreakpointType customBreakpointType;
        if (typeString != null && (customBreakpointType = DebuggerHook.getDebuggerExtenderCustomBreakpointType(typeString)) != null) {
            return customBreakpointType.getDebuggerExtenderId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CustomBreakpointType getDebuggerExtenderCustomBreakpointType(String typeString) {
        if (typeString != null) {
            Class<DebuggerHook> clazz = DebuggerHook.class;
            synchronized (DebuggerHook.class) {
                DebuggerHook.primeHook();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return _customBreakpointTypes.get(typeString);
            }
        }
        return null;
    }

    private static synchronized void updateCustomBreakpointTypes(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.DEBUGGER_EXTENDER_CUSTOM_BREAKPOINT_TYPE, items);
        if (_customBreakpointTypes == null) {
            _customBreakpointTypes = new LinkedHashMap<String, CustomBreakpointType>();
        }
        for (CustomBreakpointType bpType : items) {
            String extenderId;
            String key = bpType.getTypeString();
            String className = bpType.getClassName();
            if (key == null || className == null) continue;
            if (!_customBreakpointTypes.containsKey(key)) {
                _customBreakpointTypes.put(key, bpType);
            } else {
                DebuggerHook.logError("Duplicate custom breakpoint type string: " + key, Category.DEBUGGER_EXTENDER_CUSTOM_BREAKPOINT_TYPE.toString(), hashStructure);
            }
            if ((extenderId = bpType.getDebuggerExtenderId()) != null) continue;
            DebuggerHook.logError("Custom breakpoint type " + key + "has no extender id", Category.DEBUGGER_EXTENDER_CUSTOM_BREAKPOINT_TYPE.toString(), hashStructure);
        }
    }

    private static synchronized void updateBreakpointGutterClickHandlers(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.DEBUGGER_EXTENDER_GUTTER_CLICK_HANDLER, items);
        if (_gutterClickHandlers == null) {
            _gutterClickHandlers = new LinkedHashMap<String, ToolDescription<DebuggerBreakpointGutterToggleHandler>>();
        }
        for (ToolDescription handler : items) {
            String extenderId;
            String key = handler.getValue("node-class");
            String className = handler.getClassName();
            if (key == null || className == null) continue;
            if (!_gutterClickHandlers.containsKey(key)) {
                _gutterClickHandlers.put(key, handler);
            } else {
                DebuggerHook.logError("Duplicate breakpoint gutter toggle handler registration for node class: " + key, Category.DEBUGGER_EXTENDER_GUTTER_CLICK_HANDLER.toString(), hashStructure);
            }
            if ((extenderId = handler.getValue("debugger-extender-id")) != null) continue;
            DebuggerHook.logError("Breakpoint gutter click handler " + className + "has no extender id", Category.DEBUGGER_EXTENDER_GUTTER_CLICK_HANDLER.toString(), hashStructure);
        }
    }

    public static synchronized void addExpression(String className, String expression, boolean selected) {
        Set<String> suggestions;
        if (className == null || expression == null) {
            return;
        }
        DebuggerHook.primeHook();
        if (selected) {
            if (_expressions.containsKey(className)) {
                DebuggerHook.logDuplicateExpression(className, expression, false, null);
            } else {
                _expressions.put(className, expression);
            }
        }
        if ((suggestions = _expressionSuggestions.get(className)) != null) {
            if (suggestions.contains(expression)) {
                DebuggerHook.logDuplicateExpression(className, expression, true, null);
            } else {
                suggestions.add(expression);
            }
        } else {
            suggestions = new HashSet<String>(3);
            suggestions.add(expression);
            _expressionSuggestions.put(className, suggestions);
        }
    }

    private static void logDuplicateExpression(String className, String expression, boolean isSuggestion, HashStructure hash) {
        DebuggerHook.logError("Duplicate expression" + (isSuggestion ? " suggestion" : "") + ", class name: " + className + " expression: " + expression, Category.OBJECT_EXPRESSION.toString(), hash);
    }

    private static synchronized void updateExpressions(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_EXPRESSION, items);
        if (_expressions == null) {
            _expressions = new HashMap<String, String>();
        }
        for (Expression item : items) {
            if (!item.isSelected()) continue;
            String className = item.getClassName();
            if (_expressions.containsKey(className)) {
                DebuggerHook.logDuplicateExpression(className, item.getExpression(), false, hashStructure);
                continue;
            }
            _expressions.put(className, item.getExpression());
        }
    }

    private static synchronized void updateExpressionSuggestions(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_EXPRESSION, items);
        if (_expressionSuggestions == null) {
            _expressionSuggestions = new HashMap<String, Set<String>>();
        }
        for (Expression item : items) {
            String className = item.getClassName();
            String expression = item.getExpression();
            Set<String> suggestions = _expressionSuggestions.get(className);
            if (suggestions == null) {
                suggestions = new HashSet<String>(3);
                suggestions.add(expression);
                _expressionSuggestions.put(className, suggestions);
                continue;
            }
            suggestions.add(expression);
        }
    }

    public static synchronized String getExpression(String className) {
        if (className == null) {
            return null;
        }
        DebuggerHook.primeHook();
        return _expressions.get(className);
    }

    public static synchronized Map<String, String> getExpressions() {
        DebuggerHook.primeHook();
        return new HashMap<String, String>(_expressions);
    }

    public static synchronized List<String> getExpressionSuggestions(String className) {
        if (className != null) {
            DebuggerHook.primeHook();
            Set<String> result = _expressionSuggestions.get(className);
            if (result != null) {
                return new ArrayList<String>(result);
            }
        }
        return Collections.emptyList();
    }

    public static synchronized Map<String, List<String>> getExpressionSuggestions() {
        DebuggerHook.primeHook();
        HashMap<String, List<String>> clone = new HashMap<String, List<String>>();
        for (Map.Entry<String, Set<String>> entry : _expressionSuggestions.entrySet()) {
            clone.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return clone;
    }

    public static synchronized void addExpansion(String className, String expressions, boolean selected) {
        Set<String> suggestions;
        if (className == null || expressions == null) {
            return;
        }
        DebuggerHook.primeHook();
        if (selected) {
            if (_expansions.containsKey(className)) {
                DebuggerHook.logDuplicateExpansion(className, expressions, false, null);
            } else {
                _expansions.put(className, expressions);
            }
        }
        if ((suggestions = _expansionSuggestions.get(className)) != null) {
            if (suggestions.contains(expressions)) {
                DebuggerHook.logDuplicateExpansion(className, expressions, true, null);
            } else {
                suggestions.add(expressions);
            }
        } else {
            suggestions = new HashSet<String>(3);
            suggestions.add(expressions);
            _expansionSuggestions.put(className, suggestions);
        }
    }

    private static void logDuplicateExpansion(String className, String expansion, boolean isSuggestion, HashStructure hash) {
        DebuggerHook.logError("Duplicate expansion" + (isSuggestion ? " suggestion" : "") + ", class name: " + className + " expansion: " + expansion, Category.OBJECT_EXPANSION.toString(), hash);
    }

    private static synchronized void updateExpansions(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_EXPANSION, items);
        if (_expansions == null) {
            _expansions = new HashMap<String, String>();
        }
        for (Expansion item : items) {
            if (!item.isSelected()) continue;
            String className = item.getClassName();
            if (_expansions.containsKey(className)) {
                DebuggerHook.logDuplicateExpansion(className, item.getExpressions(), false, hashStructure);
                continue;
            }
            _expansions.put(className, item.getExpressions());
        }
    }

    private static synchronized void updateExpansionSuggestions(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_EXPANSION, items);
        if (_expansionSuggestions == null) {
            _expansionSuggestions = new HashMap<String, Set<String>>();
        }
        for (Expansion item : items) {
            String className = item.getClassName();
            String expansion = item.getExpressions();
            Set<String> suggestions = _expansionSuggestions.get(className);
            if (suggestions == null) {
                suggestions = new HashSet<String>(3);
                suggestions.add(expansion);
                _expansionSuggestions.put(className, suggestions);
                continue;
            }
            suggestions.add(expansion);
        }
    }

    public static synchronized String getExpansion(String className) {
        if (className == null) {
            return null;
        }
        DebuggerHook.primeHook();
        return _expansions.get(className);
    }

    public static synchronized Map<String, String> getExpansions() {
        DebuggerHook.primeHook();
        return new HashMap<String, String>(_expansions);
    }

    public static synchronized List<String> getExpansionSuggestions(String className) {
        if (className != null) {
            DebuggerHook.primeHook();
            Set<String> result = _expansionSuggestions.get(className);
            if (result != null) {
                return new ArrayList<String>(result);
            }
        }
        return Collections.emptyList();
    }

    public static synchronized Map<String, List<String>> getExpansionSuggestions() {
        DebuggerHook.primeHook();
        HashMap<String, List<String>> clone = new HashMap<String, List<String>>();
        for (Map.Entry<String, Set<String>> entry : _expansionSuggestions.entrySet()) {
            clone.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return clone;
    }

    private static synchronized void updateHideAllFields(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_HIDE_ALL_FIELDS, items);
        if (_hideAllFields == null) {
            _hideAllFields = new HashSet<String>();
        }
        for (HideAllFields item : items) {
            String key = item.getClassName();
            if (_hideAllFields.contains(key)) {
                DebuggerHook.logDuplicateHideAllFields(key, hashStructure);
                continue;
            }
            _hideAllFields.add(key);
        }
    }

    private static void logDuplicateHideAllFields(String className, HashStructure hash) {
        DebuggerHook.logError("Duplicate hide all fields class name: " + className, Category.OBJECT_HIDE_ALL_FIELDS.toString(), hash);
    }

    public static synchronized boolean hasHideAllFields() {
        DebuggerHook.primeHook();
        return _hideAllFields.size() > 0;
    }

    public static synchronized void addHideAllFields(String className) {
        if (className != null) {
            DebuggerHook.primeHook();
            if (!_hideAllFields.contains(className)) {
                _hideAllFields.add(className);
            } else {
                DebuggerHook.logDuplicateHideAllFields(className, null);
            }
        }
    }

    public static synchronized boolean getHideAllFields(String className) {
        if (className == null) {
            return false;
        }
        DebuggerHook.primeHook();
        return _hideAllFields.contains(className);
    }

    public static synchronized List<String> getHideAllFields() {
        DebuggerHook.primeHook();
        return new ArrayList<String>(_hideAllFields);
    }

    private static synchronized void updateHideFields(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_HIDE_FIELD, items);
        if (_hideFields == null) {
            _hideFields = new HashMap<String, Set<String>>();
        }
        for (HideField hideField : items) {
            String className = hideField.getClassName();
            String fieldName = hideField.getFieldName();
            Set<String> fields = _hideFields.get(className);
            if (fields == null) {
                fields = new HashSet<String>(3);
                fields.add(fieldName);
                _hideFields.put(className, fields);
                continue;
            }
            fields.add(fieldName);
        }
    }

    public static synchronized boolean hasHideFields() {
        DebuggerHook.primeHook();
        return _hideFields.size() > 0;
    }

    private static void logDuplicateHideField(String className, String fieldName, HashStructure hash) {
        DebuggerHook.logError("Duplicate hide field, class name: " + className + " field: " + fieldName, Category.OBJECT_HIDE_FIELD.toString(), hash);
    }

    public static synchronized void addHideField(String className, String fieldName) {
        if (className == null || fieldName == null) {
            return;
        }
        DebuggerHook.primeHook();
        Set<String> fields = _hideFields.get(className);
        if (fields == null) {
            fields = new HashSet<String>(3);
            fields.add(fieldName);
            _hideFields.put(className, fields);
        } else if (fields.contains(fieldName)) {
            DebuggerHook.logDuplicateHideField(className, fieldName, null);
        } else {
            fields.add(fieldName);
        }
    }

    public static synchronized List<String> getHideFields(String className) {
        if (className != null) {
            DebuggerHook.primeHook();
            Set<String> result = _hideFields.get(className);
            if (result != null) {
                return new ArrayList<String>(result);
            }
        }
        return Collections.emptyList();
    }

    public static synchronized Map<String, List<String>> getHideFields() {
        DebuggerHook.primeHook();
        HashMap<String, List<String>> clone = new HashMap<String, List<String>>(_hideFields.size());
        for (Map.Entry<String, Set<String>> entry : _hideFields.entrySet()) {
            clone.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return clone;
    }

    private static synchronized void updateToStringBehavior(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_TOSTRING_BEHAVIOR, items);
        if (_toStringBehavior == null) {
            _toStringBehavior = new HashMap<String, DataValueToStringBehavior>();
        }
        for (BehaviorForClass item : items) {
            String key = item.getClassName();
            if (_toStringBehavior.containsKey(key)) {
                DebuggerHook.logDuplicateToStringBehavior(key, hashStructure);
                continue;
            }
            _toStringBehavior.put(key, item.getBehavior());
        }
    }

    private static void logDuplicateToStringBehavior(String className, HashStructure hash) {
        DebuggerHook.logError("Duplicate toString behavior for class or package name: " + className, Category.OBJECT_TOSTRING_BEHAVIOR.toString(), hash);
    }

    public static synchronized Map<String, DataValueToStringBehavior> getToStringBehavior() {
        DebuggerHook.primeHook();
        return new HashMap<String, DataValueToStringBehavior>(_toStringBehavior);
    }

    private static synchronized void updateIcons(HashStructure hashStructure) {
        ArrayList items = new ArrayList();
        DebuggerHook.getItems(hashStructure, Category.OBJECT_ICON, items);
        if (_icons == null) {
            _icons = new HashMap<String, ObjectPreferencesIcon>(items.size());
        }
        for (ObjectPreferencesIcon icon : items) {
            String key = icon.getClassName();
            if (key == null) continue;
            if (_icons.containsKey(key)) {
                DebuggerHook.logDuplicateIcon(key, hashStructure);
                continue;
            }
            _icons.put(key, icon);
        }
    }

    private static void logDuplicateIcon(String className, HashStructure hash) {
        DebuggerHook.logError("Duplicate icon class name: " + className, Category.OBJECT_ICON.toString(), hash);
    }

    public static synchronized void addIcon(String className, String iconPath) {
        if (className == null || iconPath == null) {
            return;
        }
        DebuggerHook.primeHook();
        if (_icons.containsKey(className)) {
            DebuggerHook.logDuplicateIcon(className, null);
        } else {
            ObjectPreferencesIcon icon = new ObjectPreferencesIcon(className, iconPath);
            _icons.put(className, icon);
        }
    }

    public static synchronized Icon getIcon(String className) {
        if (className != null) {
            DebuggerHook.primeHook();
            ObjectPreferencesIcon icon = _icons.get(className);
            if (icon != null) {
                return icon.getIcon();
            }
        }
        return null;
    }

    public static synchronized void addDebuggerListener(DebuggerListener listener) {
        DebuggerHook.primeHook();
        DebuggerHook.addTool(listener, _debuggerListeners, Category.DEBUGGER_LISTENER);
    }

    public static synchronized void removeDebuggerListener(DebuggerListener listener) {
        DebuggerHook.removeTool(listener, _debuggerListeners);
    }

    public static List<DebuggerListener> getDebuggerListeners(Project project) {
        DebuggerHook.primeHook();
        return DebuggerHook.getTools(_debuggerListeners, project);
    }

    public static synchronized void addExecutionListener(ExecutionListener listener) {
        DebuggerHook.primeHook();
        DebuggerHook.addTool(listener, _executionListeners, Category.EXECUTION_LISTENER);
    }

    public static synchronized void removeExecutionListener(ExecutionListener listener) {
        DebuggerHook.removeTool(listener, _executionListeners);
    }

    public static List<ExecutionListener> getExecutionListeners(Project project) {
        DebuggerHook.primeHook();
        return DebuggerHook.getTools(_executionListeners, project);
    }

    public static synchronized void addSmartDataProvider(SmartDataProvider provider) {
        DebuggerHook.primeHook();
        DebuggerHook.addTool(provider, _smartDataProviders, Category.SMART_DATA_PROVIDER);
    }

    public static synchronized void removeSmartDataProvider(SmartDataProvider provider) {
        DebuggerHook.removeTool(provider, _smartDataProviders);
    }

    public static List<SmartDataProvider> getSmartDataProviders(Project project) {
        return DebuggerHook.getTools(_smartDataProviders, project);
    }

    public static synchronized void addGutterClickHandler(DebuggerBreakpointGutterToggleHandler handler) {
        DebuggerHook.primeHook();
        DebuggerHook.addTool(handler, _gutterClickHandlers, Category.DEBUGGER_EXTENDER_GUTTER_CLICK_HANDLER);
    }

    public static synchronized void removeGutterClickHandler(DebuggerBreakpointGutterToggleHandler handler) {
        DebuggerHook.removeTool(handler, _gutterClickHandlers);
    }

    public static Map<String, DebuggerBreakpointGutterToggleHandler> getBreakpointGutterToggleHandlers(Project project) {
        DebuggerHook.primeHook();
        HashMap<String, DebuggerBreakpointGutterToggleHandler> handlers = new HashMap<String, DebuggerBreakpointGutterToggleHandler>();
        if (_gutterClickHandlers != null) {
            for (String nodeClass : _gutterClickHandlers.keySet()) {
                handlers.put(nodeClass, _gutterClickHandlers.get(nodeClass).getTool());
            }
        }
        return handlers;
    }

    public static synchronized void addToolTipExpressionProvider(ToolTipExpressionProvider provider) {
        DebuggerHook.primeHook();
        DebuggerHook.addTool(provider, _toolTipExpressionProviders, Category.TOOLTIP_EXPRESSION_PROVIDER);
    }

    public static synchronized void removeToolTipExpressionProvider(ToolTipExpressionProvider provider) {
        DebuggerHook.removeTool(provider, _toolTipExpressionProviders);
    }

    public static List<ToolTipExpressionProvider> getToolTipExpressionProviders(Project project) {
        DebuggerHook.primeHook();
        return DebuggerHook.getTools(_toolTipExpressionProviders, project);
    }

    public static synchronized void addInspectorExpressionProvider(DebuggerInspectorExpressionProvider provider) {
        DebuggerHook.primeHook();
        DebuggerHook.addTool(provider, _inspectorExpressionProviders, Category.INSPECTOR_EXPRESSION_PROVIDER);
    }

    public static synchronized void removeInspectorExpressionProvider(DebuggerInspectorExpressionProvider provider) {
        DebuggerHook.removeTool(provider, _inspectorExpressionProviders);
    }

    public static List<DebuggerInspectorExpressionProvider> getInspectorExpressionProviders(Project project) {
        return DebuggerHook.getTools(_inspectorExpressionProviders, project);
    }

    private static <T> void addTool(T tool, Map<String, ToolDescription<T>> knownTools, Category category) {
        if (tool == null) {
            assert (tool != null) : "tool argument cannot be null in call to addTool";
            return;
        }
        ToolDescription desc = new ToolDescription(tool, category);
        String className = desc.getClassName();
        String key = Integer.toString(System.identityHashCode(tool));
        if (!knownTools.containsKey(key)) {
            knownTools.put(key, desc);
        } else {
            DebuggerHook.logDuplicateTool(className, category, null);
        }
    }

    public static synchronized <T> void removeTool(T tool, Map<String, ToolDescription<T>> knownTools) {
        if (tool == null) {
            assert (tool != null) : "tool arguments cannot be null in call to removeTool";
            return;
        }
        if (knownTools != null) {
            String key = Integer.toString(System.identityHashCode(tool));
            knownTools.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> getTools(Map<String, ToolDescription<T>> knownTools, Project project) {
        if (knownTools == null) {
            assert (knownTools != null) : "knownTools argument cannot be null in call to getTools";
            return Collections.emptyList();
        }
        Class<DebuggerHook> clazz = DebuggerHook.class;
        synchronized (DebuggerHook.class) {
            DebuggerHook.primeHook();
            ArrayList<ToolDescription<T>> toolDescriptions = new ArrayList<ToolDescription<T>>(knownTools.values());
            // ** MonitorExit[clazz] (shouldn't be in output)
            ArrayList list = new ArrayList(toolDescriptions.size());
            for (ToolDescription toolDescription : toolDescriptions) {
                Object tool;
                if (!toolDescription.areRulesSatisfied(project) || (tool = toolDescription.getTool()) == null) continue;
                list.add(tool);
            }
            return list;
        }
    }

    private static void logDuplicateTool(String className, Category category, HashStructure hash) {
        DebuggerHook.logError("Duplicate Registration: " + className, category.toString(), hash);
    }

    private static boolean checkRule(String rule, String categoryAsString, HashStructure hash) {
        String errorMsg = RunnerUtils.checkMissingRule(rule, categoryAsString);
        if (errorMsg != null) {
            DebuggerHook.logError(errorMsg, categoryAsString, hash);
            return true;
        }
        errorMsg = RunnerUtils.checkValidRule(rule, categoryAsString);
        if (errorMsg != null) {
            DebuggerHook.logError(errorMsg, categoryAsString, hash);
            return false;
        }
        return true;
    }

    private static synchronized <T> Map<String, ToolDescription<T>> updateTools(HashStructure hashStructure, Map<String, ToolDescription<T>> knownTools, Category category) {
        ArrayList newTools = new ArrayList();
        if (knownTools == null) {
            knownTools = new LinkedHashMap<String, ToolDescription<T>>();
        }
        DebuggerHook.getItems(hashStructure, category, newTools);
        for (ToolDescription desc : newTools) {
            String key = desc.getClassName();
            if (key == null) continue;
            if (!knownTools.containsKey(key)) {
                if (!DebuggerHook.checkRule(desc.getRule(), category.toString(), hashStructure)) continue;
                knownTools.put(key, desc);
                continue;
            }
            DebuggerHook.logDuplicateTool(key, category, hashStructure);
        }
        return knownTools;
    }

    private static synchronized void primeHook() {
        if (hashStructureHook == null) {
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    DebuggerHook.getItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    DebuggerHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    private static synchronized void getItemsFromHook(HashStructure hashStructure) {
        _debuggerListeners = DebuggerHook.updateTools(hashStructure, _debuggerListeners, Category.DEBUGGER_LISTENER);
        _executionListeners = DebuggerHook.updateTools(hashStructure, _executionListeners, Category.EXECUTION_LISTENER);
        _smartDataProviders = DebuggerHook.updateTools(hashStructure, _smartDataProviders, Category.SMART_DATA_PROVIDER);
        _toolTipExpressionProviders = DebuggerHook.updateTools(hashStructure, _toolTipExpressionProviders, Category.TOOLTIP_EXPRESSION_PROVIDER);
        _inspectorExpressionProviders = DebuggerHook.updateTools(hashStructure, _inspectorExpressionProviders, Category.INSPECTOR_EXPRESSION_PROVIDER);
        DebuggerHook.updateDebuggerExtenders(hashStructure);
        DebuggerHook.updateDebuggerWindowProviders(hashStructure);
        DebuggerHook.updateCustomBreakpointTypes(hashStructure);
        DebuggerHook.updateBreakpointGutterClickHandlers(hashStructure);
        DebuggerHook.updateExpansions(hashStructure);
        DebuggerHook.updateExpansionSuggestions(hashStructure);
        DebuggerHook.updateExpressions(hashStructure);
        DebuggerHook.updateExpressionSuggestions(hashStructure);
        DebuggerHook.updateHideAllFields(hashStructure);
        DebuggerHook.updateHideFields(hashStructure);
        DebuggerHook.updateIcons(hashStructure);
        DebuggerHook.updateToStringBehavior(hashStructure);
    }

    private static <T> void getItems(HashStructure hashStructure, Category itemCategory, List<T> items) {
        List definitions = hashStructure.getAsList(itemCategory.toString());
        if (definitions != null && definitions.size() > 0) {
            block17: for (Object definition : definitions) {
                HashStructure defHash = (HashStructure)definition;
                ToolDescription item = null;
                switch (itemCategory) {
                    default: {
                        assert (false);
                        continue block17;
                    }
                    case OBJECT_EXPRESSION: {
                        item = new Expression(defHash);
                        break;
                    }
                    case OBJECT_EXPANSION: {
                        item = new Expansion(defHash);
                        break;
                    }
                    case OBJECT_HIDE_ALL_FIELDS: {
                        item = new HideAllFields(defHash);
                        break;
                    }
                    case OBJECT_HIDE_FIELD: {
                        item = new HideField(defHash);
                        break;
                    }
                    case OBJECT_ICON: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ObjectPreferencesIcon(defHash, extensionId);
                        break;
                    }
                    case OBJECT_TOSTRING_BEHAVIOR: {
                        item = new BehaviorForClass(defHash);
                        break;
                    }
                    case DEBUGGER_EXTENDER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new DebuggerExtenderDescription(defHash, extensionId);
                        String name = "handles-source-extension";
                        if (!defHash.containsKey(name)) break;
                        DebuggerExtenderDescription dedItem = (DebuggerExtenderDescription)item;
                        List list = defHash.getAsList(name);
                        for (HashStructure sourceItem : list) {
                            String sourceExt = sourceItem.getString("#text");
                            dedItem.addHandledSourceExtension(sourceExt);
                        }
                        break;
                    }
                    case DEBUGGER_WINDOW_PROVIDER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.DEBUGGER_WINDOW_PROVIDER);
                        break;
                    }
                    case DEBUGGER_EXTENDER_CUSTOM_BREAKPOINT_TYPE: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new CustomBreakpointType(defHash, extensionId);
                        break;
                    }
                    case DEBUGGER_LISTENER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.DEBUGGER_LISTENER);
                        break;
                    }
                    case EXECUTION_LISTENER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.EXECUTION_LISTENER);
                        break;
                    }
                    case SMART_DATA_PROVIDER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.SMART_DATA_PROVIDER);
                        break;
                    }
                    case TOOLTIP_EXPRESSION_PROVIDER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.TOOLTIP_EXPRESSION_PROVIDER);
                        break;
                    }
                    case INSPECTOR_EXPRESSION_PROVIDER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.INSPECTOR_EXPRESSION_PROVIDER);
                        break;
                    }
                    case DEBUGGER_EXTENDER_GUTTER_CLICK_HANDLER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.DEBUGGER_EXTENDER_GUTTER_CLICK_HANDLER);
                    }
                }
                items.add(item);
            }
        }
    }

    private static void logError(String msg, String category, HashStructure hash) {
        String extensionId = hash == null ? null : HashStructureHook.getExtensionId((HashStructure)hash);
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    private static String getAttributeValue(HashStructure hash, String category, String name) {
        String value = hash.getString(name, null);
        if (value == null || value.trim().length() == 0) {
            DebuggerHook.logError("Missing " + name + " attribute", category, hash);
            return null;
        }
        return value;
    }

    private static ClassLoader getClassLoader(String extensionId) {
        ClassLoader loader = null;
        if (extensionId != null) {
            loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
        }
        if (loader == null) {
            loader = DebuggerHook.class.getClass().getClassLoader();
        }
        return loader;
    }

    private static final class ObjectPreferencesIcon {
        private HashStructure hash;
        private String extensionId;
        private String className;
        private String iconName;
        private Icon icon;

        private ObjectPreferencesIcon(HashStructure hash, String extensionId) {
            this.hash = hash;
            this.extensionId = extensionId;
        }

        private ObjectPreferencesIcon(String className, String iconName) {
            this.className = className;
            this.iconName = iconName;
        }

        public String getClassName() {
            if (this.className == null) {
                this.className = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_ICON.toString(), "class");
            }
            return this.className;
        }

        public Icon getIcon() {
            if (this.icon == null) {
                if (this.iconName == null) {
                    this.iconName = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_ICON.toString(), "icon");
                }
                if (this.iconName != null) {
                    String loadName = this.iconName;
                    if (loadName.startsWith("res:")) {
                        loadName = loadName.substring(4);
                    }
                    URL iconURL = DebuggerHook.getClassLoader(this.extensionId).getResource(loadName);
                    this.icon = this.loadIcon(iconURL);
                    if (this.icon != null) {
                        return this.icon;
                    }
                    iconURL = URLFactory.newURL((String)this.iconName);
                    this.icon = this.loadIcon(iconURL);
                    if (this.icon != null) {
                        return this.icon;
                    }
                    if (this.iconName.startsWith("uri:")) {
                        loadName = this.iconName.substring(4);
                        iconURL = URLFactory.newURL((String)loadName);
                        this.icon = this.loadIcon(iconURL);
                        if (this.icon != null) {
                            return this.icon;
                        }
                    }
                }
            }
            return this.icon;
        }

        private Icon loadIcon(URL iconURL) {
            if (iconURL != null) {
                return new ImageIcon(iconURL);
            }
            return null;
        }
    }

    private static final class HideField {
        private HashStructure hash;
        private String className;
        private String fieldName;

        private HideField(HashStructure hash) {
            this.hash = hash;
        }

        public String getClassName() {
            if (this.className == null) {
                this.className = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_HIDE_FIELD.toString(), "class");
            }
            return this.className;
        }

        public String getFieldName() {
            if (this.fieldName == null) {
                this.fieldName = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_HIDE_FIELD.toString(), "field");
            }
            return this.fieldName;
        }
    }

    private static final class HideAllFields {
        private HashStructure hash;
        private String className;

        private HideAllFields(HashStructure hash) {
            this.hash = hash;
        }

        public String getClassName() {
            if (this.className == null) {
                this.className = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_HIDE_ALL_FIELDS.toString(), "class");
            }
            return this.className;
        }
    }

    private static final class Expansion {
        private HashStructure hash;
        private String className;
        private String expressions;
        private Boolean selected;

        private Expansion(HashStructure hash) {
            this.hash = hash;
        }

        public String getClassName() {
            if (this.className == null) {
                this.className = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_EXPANSION.toString(), "class");
            }
            return this.className;
        }

        public String getExpressions() {
            if (this.expressions == null) {
                this.expressions = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_EXPANSION.toString(), "expressions");
            }
            return this.expressions;
        }

        public boolean isSelected() {
            if (this.selected == null) {
                this.selected = this.hash.getBoolean("selected", false);
            }
            return this.selected;
        }
    }

    private static final class Expression {
        private HashStructure hash;
        private String className;
        private String expression;
        private Boolean selected;

        private Expression(HashStructure hash) {
            this.hash = hash;
        }

        public String getClassName() {
            if (this.className == null) {
                this.className = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_EXPRESSION.toString(), "class");
            }
            return this.className;
        }

        public String getExpression() {
            if (this.expression == null) {
                this.expression = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_EXPRESSION.toString(), "expression");
            }
            return this.expression;
        }

        public boolean isSelected() {
            if (this.selected == null) {
                this.selected = this.hash.getBoolean("selected", false);
            }
            return this.selected;
        }
    }

    private static class ToolDescription<T> {
        private String extensionId;
        private String className;
        private T tool;
        protected HashStructure hash;
        protected Category category;
        private String rule;

        private ToolDescription(HashStructure hash, String extensionId, Category category) {
            this.hash = hash;
            this.extensionId = extensionId;
            this.category = category;
        }

        private ToolDescription(T tool, Category category) {
            this.tool = tool;
            this.className = tool.getClass().getName();
            this.category = category;
            this.rule = "always-enabled";
        }

        protected String getValue(String name) {
            return DebuggerHook.getAttributeValue(this.hash, this.category.toString(), name);
        }

        public String getClassName() {
            if (this.className == null) {
                this.className = this.getValue("class");
            }
            return this.className;
        }

        public String getRule() {
            if (this.rule == null) {
                this.rule = DebuggerHook.getAttributeValue(this.hash, this.category.toString(), "rule");
                if (this.rule == null) {
                    this.rule = "always-enabled";
                }
            }
            return this.rule;
        }

        public boolean areRulesSatisfied(Project project) {
            return RunnerUtils.areRulesSatisfied(this.getRule(), project, null);
        }

        public synchronized T getTool() {
            if (this.tool == null) {
                ClassLoader classLoader = DebuggerHook.getClassLoader(this.extensionId);
                MetaClass metaClass = new MetaClass(classLoader, this.getClassName());
                try {
                    this.tool = metaClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                    DebuggerHook.logError("Failed to create instance of class " + this.getClassName(), this.category.toString(), this.hash);
                }
            }
            return this.tool;
        }
    }

    private static final class CustomBreakpointType
    extends ToolDescription<DebuggerBreakpointDeclarator> {
        private CustomBreakpointType(HashStructure hash, String extensionId) {
            super(hash, extensionId, Category.DEBUGGER_EXTENDER_CUSTOM_BREAKPOINT_TYPE);
        }

        public String getDebuggerExtenderId() {
            return this.getValue("debugger-extender-id");
        }

        public String getTypeString() {
            return this.getValue("type-string");
        }
    }

    private static final class DebuggerExtenderDescription
    extends ToolDescription<DebuggerExtenderDeclarator> {
        private List<String> sourceExtensionsHandled = new ArrayList<String>();

        private DebuggerExtenderDescription(HashStructure hash, String extensionId) {
            super(hash, extensionId, Category.DEBUGGER_EXTENDER);
        }

        public String getId() {
            return this.getValue("id");
        }

        HashStructure getHash() {
            return this.hash;
        }

        String getCategoryString() {
            return this.category.toString();
        }

        private void addHandledSourceExtension(String ext) {
            this.sourceExtensionsHandled.add(ext);
        }

        public List<String> getHandledSourceExtensions() {
            return this.sourceExtensionsHandled;
        }
    }

    static class BehaviorForClass {
        private HashStructure hash;
        private String classOrPackageName;
        private DataValueToStringBehavior behavior;

        BehaviorForClass(HashStructure hash) {
            this.hash = hash;
        }

        public String getClassName() {
            if (this.classOrPackageName == null) {
                this.classOrPackageName = DebuggerHook.getAttributeValue(this.hash, Category.OBJECT_TOSTRING_BEHAVIOR.toString(), "class");
            }
            return this.classOrPackageName;
        }

        public DataValueToStringBehavior getBehavior() {
            if (this.behavior == null) {
                this.behavior = new DataValueToStringBehavior();
                this.behavior.setUseToString(this.hash.getBoolean("use-toString", true));
                this.behavior.setUseToStringOnlyWhenOverridden(this.hash.getBoolean("only-when-overridden", true));
                this.behavior.setUseToStringOnlyWhenNoExpressionSpecified(this.hash.getBoolean("only-when-no-expression"));
            }
            return this.behavior;
        }
    }

    private static enum Category {
        OBJECT_TOSTRING_BEHAVIOR{

            public String toString() {
                return "object-toString-behavior";
            }
        }
        ,
        OBJECT_EXPRESSION{

            public String toString() {
                return "object-expression";
            }
        }
        ,
        OBJECT_EXPANSION{

            public String toString() {
                return "object-expansion";
            }
        }
        ,
        OBJECT_HIDE_FIELD{

            public String toString() {
                return "object-hide-field";
            }
        }
        ,
        OBJECT_HIDE_ALL_FIELDS{

            public String toString() {
                return "object-hide-all-fields";
            }
        }
        ,
        OBJECT_ICON{

            public String toString() {
                return "object-icon";
            }
        }
        ,
        DEBUGGER_EXTENDER{

            public String toString() {
                return "debugger-extender";
            }
        }
        ,
        DEBUGGER_EXTENDER_CUSTOM_BREAKPOINT_TYPE{

            public String toString() {
                return "debugger-extender-custom-breakpoint-type";
            }
        }
        ,
        DEBUGGER_LISTENER{

            public String toString() {
                return "debugger-listener";
            }
        }
        ,
        EXECUTION_LISTENER{

            public String toString() {
                return "execution-listener";
            }
        }
        ,
        SMART_DATA_PROVIDER{

            public String toString() {
                return "smart-data-provider";
            }
        }
        ,
        TOOLTIP_EXPRESSION_PROVIDER{

            public String toString() {
                return "tooltip-expression-provider";
            }
        }
        ,
        INSPECTOR_EXPRESSION_PROVIDER{

            public String toString() {
                return "inspector-expression-provider";
            }
        }
        ,
        DEBUGGER_WINDOW_PROVIDER{

            public String toString() {
                return "debugger-window-provider";
            }
        }
        ,
        DEBUGGER_EXTENDER_GUTTER_CLICK_HANDLER{

            public String toString() {
                return "debugger-extender-gutter-click-handler";
            }
        };

    }
}

