/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.net.URL;
import java.util.Map;
import oracle.ide.runner.DebuggerBreakpointLogEntry;

public interface DebuggerBreakpoint {
    public URL getScope();

    public boolean isEnabled();

    public String getCondition();

    public String getHiddenCondition();

    public boolean canEditCondition();

    public int getPassCount();

    public boolean canEditPassCount();

    public String getGroupName();

    public boolean canEditGroupName();

    public String getCustomDescription();

    public String getCustomTypeString();

    public String getBreakForThreadNamed();

    public String getBreakForThreadNotNamed();

    public boolean canEditBreakForThreads();

    public boolean isHaltOnBreakpointHit();

    public boolean isBeepOnBreakpointHit();

    public DebuggerBreakpointLogEntry getLogEntryOnBreakpointHit();

    public String getEnableBreakpointGroupOnBreakpointHit();

    public String getDisableBreakpointGroupOnBreakpointHit();

    public boolean canEditBreakpointHitActions();

    public Map<String, String> getProperties();

    public BreakpointKind getKind();

    public static enum BreakpointScope {
        GLOBAL,
        WORKSPACE,
        PROJECT;

    }

    public static enum BreakpointState {
        ENABLED,
        UNVERIFIED,
        VERIFIED,
        DISABLED,
        MOVED,
        REFACTORED,
        EDITED,
        SCOPE_CHANGED;

    }

    public static enum BreakpointKind {
        METHOD,
        FILE_LINE,
        URL_LINE,
        EXCEPTION,
        PROPERTIES;

    }
}

