/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.ceditor.options.S2Highlight;
import oracle.ide.ceditor.options.S2Style;
import oracle.ide.ceditor.options.SyntaxHighlight;
import oracle.ide.ceditor.options.SyntaxStyle;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class SyntaxColorsOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "SyntaxColorsOptions";
    private static final String STYLES = "styleList";
    private static final String SELECTED_SCHEME = "selectedScheme";
    private static final String FIRST_TIME = "firstTime";
    private static final String MIGRATED = "migrated";

    public SyntaxColorsOptions() {
        this(HashStructure.newInstance());
    }

    public SyntaxColorsOptions(HashStructure hash) {
        super(hash);
    }

    public static SyntaxColorsOptions getInstance(PropertyStorage prefs) {
        return new SyntaxColorsOptions(SyntaxColorsOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public ListStructure getStyles() {
        return this._hash.getOrCreateListStructure(STYLES);
    }

    public List getStyleList() {
        ArrayList<HashStructureAdapter> styleList = new ArrayList<HashStructureAdapter>();
        ListStructure styles = this.getStyles();
        for (Object next : styles) {
            if (!(next instanceof HashStructure)) continue;
            HashStructure hash = (HashStructure)next;
            String type = hash.getString("type");
            if ("style".equals(type)) {
                styleList.add(new S2Style(hash));
                continue;
            }
            if (!"highlight".equals(type)) continue;
            styleList.add(new S2Highlight(hash));
        }
        return styleList;
    }

    public void setStyleList(List styleList) {
        ListStructure styles = this.getStyles();
        styles.clear();
        for (Object next : styleList) {
            HashStructure hash = HashStructure.newInstance();
            styles.add((Object)hash);
            if (next instanceof S2Style) {
                ((S2Style)((Object)next)).copyTo((Object)new S2Style(hash));
                continue;
            }
            if (next instanceof S2Highlight) {
                ((S2Highlight)((Object)next)).copyTo((Object)new S2Highlight(hash));
                continue;
            }
            if (next instanceof SyntaxStyle) {
                ((SyntaxStyle)((Object)next)).copyTo((Object)new SyntaxStyle(hash));
                continue;
            }
            if (next instanceof SyntaxHighlight) {
                ((SyntaxHighlight)((Object)next)).copyTo((Object)new SyntaxHighlight(hash));
                continue;
            }
            styles.remove(styles.size() - 1);
        }
    }

    public String getSelectedScheme() {
        return this._hash.getString(SELECTED_SCHEME, null);
    }

    public void setSelectedScheme(String selectedScheme) {
        this._hash.putString(SELECTED_SCHEME, selectedScheme);
    }

    public boolean getFirstTime() {
        return this._hash.getBoolean(FIRST_TIME, true);
    }

    public void setFirstTime(boolean firstTime) {
        this._hash.putBoolean(FIRST_TIME, firstTime);
    }

    public boolean getMigrated() {
        return this._hash.getBoolean(MIGRATED, false);
    }

    public void setMigrated(boolean migrated) {
        this._hash.putBoolean(MIGRATED, migrated);
    }
}

