/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditor;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ideimpl.editor.EditorException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

final class LongLineDetector {
    private LongLineDetector() {
    }

    public static void detectLongLines(TextBuffer textBuffer, Context context) {
        if (Ide.isStarting()) {
            return;
        }
        if (!EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences()).isLongLineWarning()) {
            return;
        }
        LineMap lineMap = textBuffer.getLineMap();
        int longLines = 0;
        int lineLimit = EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getLongLineWarningLimit();
        for (int i = 0; i < lineMap.getLineCount(); ++i) {
            if (lineMap.getLineEndOffset(i) - lineMap.getLineStartOffset(i) <= lineLimit) continue;
            ++longLines;
        }
        if (longLines > 0) {
            JPanel messageContents = new JPanel(new BorderLayout());
            IdeAction reformatAction = IdeAction.find((String)"CodeEditor.Format");
            context.setProperty("NavigationManager.VETO_NAVIGATION", (Object)Boolean.TRUE);
            reformatAction.updateAction(context);
            String messageText = CEditor.format("LONG_LINE_TEXT", lineLimit);
            JCheckBox reformatCB = new JCheckBox(CEditor.get("LONG_LINE_CHECK"));
            reformatCB.setSelected(true);
            if (reformatAction.isEnabled()) {
                messageContents.add((Component)reformatCB, "South");
                messageText = CEditor.format("LONG_LINE_TEXT_WITH_REFORMAT", lineLimit);
            }
            MultiLineLabel messageLabel = new MultiLineLabel(messageText);
            messageLabel.setTextWrapper(WordWrapper.getTextWrapper());
            messageLabel.setPreferredAspectRatio(5.0f);
            messageContents.add((Component)messageLabel, "Center");
            boolean open = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)messageContents, (String)CEditor.get("LONG_LINE_TITLE"), null, (boolean)false, (String)CEditor.get("LONG_LINE_OPEN"), (String)CEditor.get("LONG_LINE_CANCEL"));
            if (!open) {
                throw new EditorException(EditorException.Type.CREATION, false);
            }
            if (reformatAction.isEnabled() && reformatCB.isSelected()) {
                try {
                    if (reformatAction.isEnabled()) {
                        context.getNode().markDirty(true);
                        reformatAction.performAction(context);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("global").log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }
}

